/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.AuthEnvelopedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthEnvelopedData;
import org.bouncycastle.cms.CMSAuthEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputAEADEncryptor;

public class CMSAuthEnvelopedDataGenerator
extends CMSAuthEnvelopedGenerator {
    private CMSAuthEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        AttributeTable attributeTable;
        Object object4;
        Object object2;
        Object object3;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSet dERSet = null;
        try {
            object3 = outputAEADEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object3);
            if (this.authAttrsGenerator != null) {
                object2 = this.authAttrsGenerator.getAttributes(Collections.EMPTY_MAP);
                dERSet = new DERSet(object2.toASN1EncodableVector());
                outputAEADEncryptor.getAADStream().write(dERSet.getEncoded("DER"));
            }
            ((OutputStream)object3).close();
        }
        catch (IOException iOException) {
            throw new CMSException("unable to process authenticated content: " + iOException.getMessage(), iOException);
        }
        object3 = byteArrayOutputStream.toByteArray();
        object2 = outputAEADEncryptor.getMAC();
        AlgorithmIdentifier algorithmIdentifier = outputAEADEncryptor.getAlgorithmIdentifier();
        BEROctetString bEROctetString = new BEROctetString((byte[])object3);
        GenericKey genericKey = outputAEADEncryptor.getKey();
        for (Object object4 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add((ASN1Encodable)object4.generate(genericKey));
        }
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(cMSTypedData.getContentType(), algorithmIdentifier, (ASN1OctetString)bEROctetString);
        object4 = null;
        if (this.unauthAttrsGenerator != null) {
            attributeTable = this.unauthAttrsGenerator.getAttributes(Collections.EMPTY_MAP);
            object4 = new DLSet(attributeTable.toASN1EncodableVector());
        }
        attributeTable = new ContentInfo(CMSObjectIdentifiers.authEnvelopedData, (ASN1Encodable)new AuthEnvelopedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), encryptedContentInfo, (ASN1Set)dERSet, (ASN1OctetString)new DEROctetString((byte[])object2), (ASN1Set)object4));
        return new CMSAuthEnvelopedData((ContentInfo)attributeTable);
    }

    public CMSAuthEnvelopedData generate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputAEADEncryptor);
    }
}

