/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum StandardPlural {
    ZERO("zero"),
    ONE("one"),
    TWO("two"),
    FEW("few"),
    MANY("many"),
    OTHER("other"),
    EQ_0("=0"),
    EQ_1("=1");

    public static final int OTHER_INDEX;
    public static final List<StandardPlural> VALUES;
    public static final int COUNT;
    private final String keyword;

    private StandardPlural(String kw) {
        this.keyword = kw;
    }

    public final String getKeyword() {
        return this.keyword;
    }

    public static final StandardPlural orNullFromString(CharSequence keyword2) {
        switch (keyword2.length()) {
            case 1: {
                if (keyword2.charAt(0) == '0') {
                    return EQ_0;
                }
                if (keyword2.charAt(0) != '1') break;
                return EQ_1;
            }
            case 2: {
                if ("=0".contentEquals(keyword2)) {
                    return EQ_0;
                }
                if (!"=1".contentEquals(keyword2)) break;
                return EQ_1;
            }
            case 3: {
                if ("one".contentEquals(keyword2)) {
                    return ONE;
                }
                if ("two".contentEquals(keyword2)) {
                    return TWO;
                }
                if (!"few".contentEquals(keyword2)) break;
                return FEW;
            }
            case 4: {
                if ("many".contentEquals(keyword2)) {
                    return MANY;
                }
                if (!"zero".contentEquals(keyword2)) break;
                return ZERO;
            }
            case 5: {
                if (!"other".contentEquals(keyword2)) break;
                return OTHER;
            }
        }
        return null;
    }

    public static final StandardPlural orOtherFromString(CharSequence keyword2) {
        StandardPlural p = StandardPlural.orNullFromString(keyword2);
        return p != null ? p : OTHER;
    }

    public static final StandardPlural fromString(CharSequence keyword2) {
        StandardPlural p = StandardPlural.orNullFromString(keyword2);
        if (p != null) {
            return p;
        }
        throw new IllegalArgumentException(keyword2.toString());
    }

    public static final int indexOrNegativeFromString(CharSequence keyword2) {
        StandardPlural p = StandardPlural.orNullFromString(keyword2);
        return p != null ? p.ordinal() : -1;
    }

    public static final int indexOrOtherIndexFromString(CharSequence keyword2) {
        StandardPlural p = StandardPlural.orNullFromString(keyword2);
        return p != null ? p.ordinal() : OTHER.ordinal();
    }

    public static final int indexFromString(CharSequence keyword2) {
        StandardPlural p = StandardPlural.orNullFromString(keyword2);
        if (p != null) {
            return p.ordinal();
        }
        throw new IllegalArgumentException(keyword2.toString());
    }

    static {
        OTHER_INDEX = OTHER.ordinal();
        VALUES = Collections.unmodifiableList(Arrays.asList(StandardPlural.values()));
        COUNT = VALUES.size();
    }
}

