/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoVertexT1OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaVertex;
import org.freehep.graphics2d.VectorGraphics;

public class JaVertexT1
extends JaVertex {
    private static final long serialVersionUID = 1L;

    @Override
    public final JaObject copy() {
        JaVertexT1 temp = (JaVertexT1)this.copy(new JaVertexT1());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaVertexT1) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(0.0f));
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        gp.moveTo(0.0f, 0.0f);
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        Ellipse2D.Float vertex = new Ellipse2D.Float();
        ((RectangularShape)vertex).setFrame(-length, -length, 2.0 * length, 2.0 * length);
        gp.append(vertex, false);
        gp = this.trans(gp, 1.0);
        g2.fill((Shape)gp);
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        float radius = this.getLaTexRadius(scale);
        String base = "\\Vertex";
        String command = "";
        command = (int)radius == 0 ? "%" : base + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + "){" + D_FORMAT.format(radius) + "}";
        return command;
    }

    @Override
    public final boolean editPanel() {
        JaxoVertexT1OptionsPanel vert1op = new JaxoVertexT1OptionsPanel(this);
        return vert1op.hasChanged();
    }
}

