/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.Global;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.ResourceBundle;
import org.freehep.graphics2d.VectorGraphics;

public abstract class JaObject
implements Serializable {
    public static final int SELECT_NONE = 0;
    public static final int SELECT_BODY = 11;
    public static final int SELECT_UL = 12;
    public static final int SELECT_UR = 13;
    public static final int SELECT_LR = 14;
    public static final int SELECT_LL = 15;
    public static final int MOVE = 50;
    public static final int RESIZE = 51;
    public static final int COPY = 52;
    public static final int LENGTH = 8;
    public static final int INIT_SIZE = 25;
    public static final int SELECT_P1 = 1;
    public static final int SELECT_P2 = 2;
    public static final int SELECT_P3 = 3;
    public static final int BB_MIN_X = 0;
    public static final int BB_MIN_Y = 1;
    public static final int BB_MAX_X = 2;
    public static final int BB_MAX_Y = 3;
    public static final DecimalFormat D_FORMAT;
    protected static final long serialVersionUID = 314159L;
    private int x;
    private int y;
    private int relw;
    private int relh;
    private float xx;
    private float yy;
    private double xu;
    private double yu;
    private boolean isUser;
    private float rrelw;
    private float rrelh;
    private double urelw;
    private double urelh;
    private Color color;
    private GeneralPath gp = new GeneralPath();
    private double[] boundingbox = new double[]{0.0, 0.0, 0.0, 0.0};
    private boolean marked = false;

    public final GeneralPath getGeneralPath() {
        return this.gp;
    }

    public void updateCoor() {
        this.x = Global.fromX(this.xx);
        this.y = Global.fromY(this.yy);
        this.relw = Global.fromX(this.rrelw);
        this.relh = Global.fromY(this.rrelh);
    }

    public void updateNDC() {
        this.xx = Global.toX(this.x);
        this.yy = Global.toY(this.y);
        this.rrelw = Global.toX(this.relw);
        this.rrelh = Global.toY(this.relh);
    }

    public double[] getBoundingBox() {
        int length = this.boundingbox.length;
        double[] newArray = new double[length];
        System.arraycopy(this.boundingbox, 0, newArray, 0, length);
        return newArray;
    }

    public final void setBoundingBox(double[] bb) {
        this.boundingbox[0] = bb[0];
        this.boundingbox[1] = bb[1];
        this.boundingbox[2] = bb[2];
        this.boundingbox[3] = bb[3];
    }

    public final void setAsMarked(boolean mark) {
        this.marked = mark;
    }

    public final boolean isMarked() {
        return this.marked;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public final int getX() {
        return this.x;
    }

    public final double getXndc() {
        return this.xx;
    }

    public final double getXuser() {
        return this.xu;
    }

    public final void setX(int newX) {
        this.x = newX;
        this.xx = Global.toX(this.x);
    }

    public final int getY() {
        return this.y;
    }

    public final double getYndc() {
        return this.yy;
    }

    public final double getYuser() {
        return this.yu;
    }

    public final void setY(int newY) {
        this.y = newY;
        this.yy = Global.toY(this.y);
    }

    public void setLocation(double xc, double yc, String what) {
        if (what.equals("NDC")) {
            this.xx = (float)xc;
            this.yy = (float)yc;
            this.x = Global.fromX(this.xx);
            this.y = Global.fromY(this.yy);
            this.isUser = false;
        } else if (what.equals("USER")) {
            this.xu = xc;
            this.yu = yc;
            this.isUser = true;
        } else {
            this.isUser = false;
            this.x = (int)xc;
            this.y = (int)yc;
            this.isUser = false;
        }
    }

    public void setRelWH(double w, double h, String what) {
        if (what.equals("NDC")) {
            this.rrelw = (float)w;
            this.rrelh = (float)h;
            this.relw = Global.fromX(this.rrelw);
            this.relh = Global.fromY(this.rrelh);
        } else if (what.equals("USER")) {
            this.urelw = w;
            this.urelh = h;
            this.isUser = true;
        }
    }

    public final int getWidth() {
        return Math.abs(this.getRelw());
    }

    public final int getHeight() {
        return Math.abs(this.getRelh());
    }

    public final int getRelw() {
        return this.relw;
    }

    public final void setRelw(int newRelw) {
        this.relw = newRelw;
        this.rrelw = Global.toX(this.relw);
    }

    public final int getRelh() {
        return this.relh;
    }

    public final double getRelHndc() {
        return this.rrelh;
    }

    public final double getRelHuser() {
        return this.urelh;
    }

    public final double getRelWndc() {
        return this.rrelw;
    }

    public final double getRelWuser() {
        return this.urelw;
    }

    public final void setRelh(int newRelh) {
        this.relh = newRelh;
        this.rrelh = Global.toY(this.relh);
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color c) {
        this.color = c;
    }

    public final void setRelWAndH(int w, int h) {
        this.setRelw(w);
        this.setRelh(h);
    }

    public final void setLocation(int newX, int newY) {
        this.setX(newX);
        this.setY(newY);
    }

    public void moveBy(int deltaX, int deltaY) {
        this.setX(this.x + deltaX);
        this.setY(this.y + deltaY);
    }

    public final void setSize(int w, int h, int rw, int rh) {
        this.setRelw(rw);
        this.setRelh(rh);
    }

    public final Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public final Dimension getRelSize() {
        return new Dimension(this.relw, this.relh);
    }

    public void drawVisualAid(VectorGraphics g2) {
    }

    protected GeneralPath trans(GeneralPath path, double scale) {
        AffineTransform at = new AffineTransform();
        double theta = Math.atan2(this.relh, this.relw);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.relw > 0 && this.relh >= 0) {
            at.translate(this.x, this.y);
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw >= 0 && this.relh < 0) {
            at.translate(this.x, this.y + height);
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw < 0 && this.relh <= 0) {
            at.translate(this.x + width, this.y + height);
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw <= 0 && this.relh > 0) {
            at.translate(this.x + width, this.y);
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        return path;
    }

    protected GeneralPath transdl(GeneralPath path, double scale) {
        AffineTransform at = new AffineTransform();
        double theta = Math.atan2(this.relh, this.relw);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.relw > 0 && this.relh >= 0) {
            at.translate(this.x, this.y);
            at.rotate(theta - 0.01, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw >= 0 && this.relh < 0) {
            at.translate(this.x, this.y + height);
            at.rotate(theta + 0.01, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw < 0 && this.relh <= 0) {
            at.translate(this.x + width, this.y + height);
            at.rotate(theta + 0.01, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw <= 0 && this.relh > 0) {
            at.translate(this.x + width, this.y);
            at.rotate(theta + 0.01, 0.0, 0.0);
            at.scale(scale, scale);
            path.transform(at);
        }
        return path;
    }

    protected GeneralPath transv(GeneralPath path, double scale) {
        AffineTransform at = new AffineTransform();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.relw > 0 && this.relh >= 0) {
            at.translate(this.x, this.y);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw >= 0 && this.relh < 0) {
            at.translate(this.x, this.y + height);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw < 0 && this.relh <= 0) {
            at.translate(this.x + width, this.y + height);
            at.scale(scale, scale);
            path.transform(at);
        }
        if (this.relw <= 0 && this.relh > 0) {
            at.translate(this.x + width, this.y);
            at.scale(scale, scale);
            path.transform(at);
        }
        return path;
    }

    public Point2D scalePoint(double orx, double ory, double scale, double px, double py) {
        Point2D.Double newP = new Point2D.Double(scale * (px - orx) + orx, scale * (py - ory) + ory);
        return newP;
    }

    public abstract void jaxoDraw(VectorGraphics var1, boolean var2);

    public abstract void drawHandles(VectorGraphics var1);

    public abstract int getGrabbedHandle(int var1, int var2, int var3);

    public abstract JaObject copy();

    public abstract boolean isCopy(JaObject var1);

    public abstract String latexCommand(float var1, Dimension var2);

    public abstract String latexWidth();

    public abstract void rescaleObject(int var1, int var2, float var3);

    public abstract boolean editPanel();

    static {
        block4: {
            D_FORMAT = new DecimalFormat("######.##", new DecimalFormatSymbols(new Locale("en", "US")));
            try {
                BeanInfo info = Introspector.getBeanInfo(JaObject.class);
                PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    PropertyDescriptor pd = propertyDescriptors[i];
                    if (pd.getName().equals("boundingBox")) {
                        pd.setValue("transient", Boolean.TRUE);
                        continue;
                    }
                    if (!pd.getName().equals("gp")) continue;
                    pd.setValue("transient", Boolean.TRUE);
                }
            }
            catch (IntrospectionException e) {
                if (!JaxoPrefs.verbose()) break block4;
                System.err.println(ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("IntrospectionException_in_JaxoObject:_") + e);
            }
        }
    }
}

