/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoLoopOptionsPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import jhplot.jadraw.JaGlLoop;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public abstract class JaLoopObject
extends JaObject {
    private static final long serialVersionUID = 1L;
    private float stroke;
    private float dash;
    private float freq;
    private boolean arrow;
    private boolean flip;
    private int amp;
    private boolean doubleLine;
    private float dlSeparation;

    public JaLoopObject() {
        this.setRelw(25);
        this.setRelh(25);
        this.setAmp(JaxoPrefs.getIntPref(104));
        this.setFreq(20.0f);
        this.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        this.setStroke(JaxoPrefs.getFloatPref(200));
        this.setDoubleLine(false);
        this.setDLSeparation(JaxoPrefs.getFloatPref(201));
    }

    public final JaObject copy(JaLoopObject temp) {
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setColor(this.getColor());
        temp.setStroke(this.getStroke());
        temp.setDoubleLine(this.getDoubleLine());
        temp.setDLSeparation(this.getDLSeparation());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaLoopObject && comp.getX() == this.getX() && ((JaLoopObject)comp).getY() == this.getY() && ((JaLoopObject)comp).getColor().equals(this.getColor()) && ((JaLoopObject)comp).getStroke() == this.getStroke() && ((JaLoopObject)comp).getDoubleLine() == this.getDoubleLine() && ((JaLoopObject)comp).getDLSeparation() == this.getDLSeparation() && ((JaLoopObject)comp).getRelw() == this.getRelw() && ((JaLoopObject)comp).getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    public final float getStroke() {
        return this.stroke;
    }

    public final void setStroke(float newStroke) {
        this.stroke = newStroke;
    }

    public final float getDash() {
        return this.dash;
    }

    public final void setDash(float newDash) {
        this.dash = newDash;
    }

    public final float getFreq() {
        return this.freq;
    }

    public final void setFreq(float newFreq) {
        this.freq = newFreq;
    }

    public final int getAmp() {
        return this.amp;
    }

    public final void setAmp(int newAmp) {
        this.amp = newAmp;
    }

    public final boolean isArrow() {
        return this.arrow;
    }

    public final boolean getArrow() {
        return this.arrow;
    }

    public final void setArrow(boolean arr) {
        this.arrow = arr;
    }

    public final boolean isFlip() {
        return this.flip;
    }

    public final boolean getFlip() {
        return this.flip;
    }

    public final void setFlip(boolean newFlip) {
        this.flip = newFlip;
    }

    public final void setDoubleLine(boolean dline) {
        this.doubleLine = dline;
    }

    public final boolean getDoubleLine() {
        return this.doubleLine;
    }

    public final void setDLSeparation(float dlsep) {
        this.dlSeparation = dlsep;
    }

    public final float getDLSeparation() {
        return this.dlSeparation;
    }

    @Override
    public final void drawVisualAid(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.3f));
        int lp4 = 12;
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            g2.drawLine(x - lp4, y, x + lp4, y);
            g2.drawLine(x, y - lp4, x, y + lp4);
        } else if (this.getRelw() <= 0 && this.getRelh() > 0) {
            g2.drawLine(x + w - lp4, y, x + w + lp4, y);
            g2.drawLine(x + w, y - lp4, x + w, y + lp4);
        } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
            g2.drawLine(x + w, y + h - lp4, x + w, y + h + lp4);
            g2.drawLine(x + w - lp4, y + h, x + w + lp4, y + h);
        } else {
            g2.drawLine(x - lp4, y + h, x + lp4, y + h);
            g2.drawLine(x, y + h - lp4, x, y + h + lp4);
        }
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.3f));
        if (this.getRelw() > 0 && this.getRelh() >= 0 || this.getRelw() < 0 && this.getRelh() <= 0) {
            g2.drawRect(this.getX() - 4, this.getY() - 4, 8, 8);
            g2.drawRect(this.getX() + this.getWidth() - 4, this.getY() + this.getHeight() - 4, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(this.getX() - 4 + 1, this.getY() - 4 + 1, 7, 7);
                g2.fillRect(this.getX() + this.getWidth() - 4 + 1, this.getY() + this.getHeight() - 4 + 1, 7, 7);
            }
        } else if (this.getRelw() <= 0 && this.getRelh() > 0 || this.getRelw() >= 0 && this.getRelh() < 0) {
            g2.drawRect(this.getX() - 4, this.getY() + this.getHeight() - 4, 8, 8);
            g2.drawRect(this.getX() + this.getWidth() - 4, this.getY() - 4, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(this.getX() - 4 + 1, this.getY() + this.getHeight() - 4 + 1, 7, 7);
                g2.fillRect(this.getX() + this.getWidth() - 4 + 1, this.getY() - 4 + 1, 7, 7);
            }
        }
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        if (editmode == 50 || editmode == 52) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
            }
            if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
            }
            if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
            }
            if (this.getRelw() <= 0 && this.getRelh() > 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
            }
            return 0;
        }
        if (editmode == 51) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 14;
                }
            } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 12;
                }
            } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 13;
                }
            } else if (this.getRelw() <= 0 && this.getRelh() > 0 && clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                return 15;
            }
            return 0;
        }
        return 0;
    }

    protected final GeneralPath transl(GeneralPath gp, double scale) {
        AffineTransform at = new AffineTransform();
        double theta = Math.atan2(this.getRelh(), this.getRelw());
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            at.translate(this.getX() - this.getWidth(), this.getY() - this.getHeight());
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        if (this.getRelw() >= 0 && this.getRelh() < 0) {
            at.translate(this.getX() - this.getWidth(), this.getY() + 2 * this.getHeight());
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        if (this.getRelw() < 0 && this.getRelh() <= 0) {
            at.translate(this.getX() + 2 * this.getWidth(), this.getY() + 2 * this.getHeight());
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        if (this.getRelw() <= 0 && this.getRelh() > 0) {
            at.translate(this.getX() + 2 * this.getWidth(), this.getY() - this.getHeight());
            at.rotate(theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        return gp;
    }

    protected final GeneralPath loopArrow(VectorGraphics g2, Color c, double length, float size, boolean fl) {
        g2.setStroke((Stroke)new BasicStroke(2.0f));
        GeneralPath gp = new GeneralPath();
        float arrowsize = 5.0f * size / 8.0f;
        gp.moveTo(arrowsize, 0.0f);
        gp.lineTo(-arrowsize, arrowsize / 1.5f);
        gp.lineTo(-arrowsize / 1.5f, 0.0f);
        gp.lineTo(-arrowsize, -arrowsize / 1.5f);
        gp.closePath();
        AffineTransform at = new AffineTransform();
        at.translate(0.0, length);
        if (this.flip) {
            at.rotate(Math.toRadians(180.0), 0.0, 0.0);
        }
        gp.transform(at);
        gp = this.transar(gp, 1.0);
        g2.setPaint((Paint)c);
        g2.fill((Shape)gp);
        return gp;
    }

    protected final GeneralPath dLoopArrow(VectorGraphics g2, Color c, double length, float size, boolean fl, float dlSep) {
        g2.setStroke((Stroke)new BasicStroke(2.0f));
        GeneralPath gp = new GeneralPath();
        float arrowsize = 5.0f * size / 8.0f;
        gp.moveTo(arrowsize, dlSep);
        gp.lineTo(-arrowsize, arrowsize / 1.5f + dlSep);
        gp.lineTo(-arrowsize / 1.5f, dlSep);
        gp.lineTo(-arrowsize, -arrowsize / 1.5f + dlSep);
        gp.closePath();
        AffineTransform at = new AffineTransform();
        at.translate(0.0, length);
        if (this.flip) {
            at.rotate(Math.toRadians(180.0), 0.0, 0.0);
        }
        gp.transform(at);
        gp = this.transar(gp, 1.0);
        g2.setPaint((Paint)c);
        g2.fill((Shape)gp);
        return gp;
    }

    private GeneralPath transar(GeneralPath gp, double scale) {
        int ampangle = 360;
        AffineTransform at = new AffineTransform();
        double theta = Math.atan2(this.getRelh(), this.getRelw());
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            at.translate(this.getX(), this.getY());
            at.rotate((Math.PI - Math.toRadians(ampangle)) / 2.0 + theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        if (this.getRelw() >= 0 && this.getRelh() < 0) {
            at.translate(this.getX(), this.getY() + this.getHeight());
            at.rotate((Math.PI - Math.toRadians(ampangle)) / 2.0 + theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        if (this.getRelw() < 0 && this.getRelh() <= 0) {
            at.translate(this.getX() + this.getWidth(), this.getY() + this.getHeight());
            at.rotate((Math.PI - Math.toRadians(ampangle)) / 2.0 + theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        if (this.getRelw() <= 0 && this.getRelh() > 0) {
            at.translate(this.getX() + this.getWidth(), this.getY());
            at.rotate((Math.PI - Math.toRadians(ampangle)) / 2.0 + theta, 0.0, 0.0);
            at.scale(scale, scale);
            gp.transform(at);
        }
        return gp;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = 0;
        int newRelHeight = 0;
        int oldWidth = this.getSize().width;
        int oldHeight = this.getSize().height;
        int oldRelWidth = this.getRelSize().width;
        int oldRelHeight = this.getRelSize().height;
        int newAmp = (int)((float)this.getAmp() * scale);
        double newLength = Math.sqrt(oldWidth * oldWidth + oldHeight * oldHeight) * (double)scale;
        int wiggleNumbers = 0;
        wiggleNumbers = this instanceof JaGlLoop ? (int)(Math.sqrt(oldWidth * oldWidth + oldHeight * oldHeight) * 2.0 * Math.PI / (double)this.getFreq() / (double)0.6f) : (int)(Math.sqrt(oldWidth * oldWidth + oldHeight * oldHeight) * 2.0 * Math.PI / (double)this.getFreq());
        float newFreq = 0.0f;
        newFreq = this instanceof JaGlLoop ? (float)(newLength * 2.0 * Math.PI / (double)wiggleNumbers / (double)0.6f) : (float)(newLength * 2.0 * Math.PI / (double)wiggleNumbers);
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
        double theta = Math.atan2(oldRelHeight, oldRelWidth);
        if (oldRelWidth < 0 && oldRelHeight <= 0) {
            newRelHeight = (int)(newLength * Math.sin(theta)) - 1;
            newRelWidth = (int)(newLength * Math.cos(theta)) - 1;
        } else if (oldRelWidth >= 0 && oldRelHeight < 0) {
            newRelHeight = (int)(newLength * Math.sin(theta)) - 1;
            newRelWidth = (int)(newLength * Math.cos(theta)) + 1;
        } else if (oldRelWidth <= 0 && oldRelHeight > 0) {
            newRelHeight = (int)(newLength * Math.sin(theta)) + 1;
            newRelWidth = (int)(newLength * Math.cos(theta)) - 1;
        } else if (oldRelWidth > 0 && oldRelHeight >= 0) {
            newRelHeight = (int)(newLength * Math.sin(theta)) + 1;
            newRelWidth = (int)(newLength * Math.cos(theta)) + 1;
        }
        this.setAmp(newAmp);
        this.setFreq(newFreq);
        this.setRelWAndH(newRelWidth, newRelHeight);
    }

    @Override
    public final boolean editPanel() {
        JaxoLoopOptionsPanel loopop = new JaxoLoopOptionsPanel(this);
        return loopop.hasChanged();
    }

    @Override
    public final String latexWidth() {
        String thisValue = Float.toString(this.getStroke() / 2.0f);
        String base = "\\SetWidth{";
        String closing = "}";
        String lineWidth = base.concat(thisValue.concat(closing));
        return lineWidth;
    }

    protected Point2D getLaTexCenter(float scaleFactor, int canvasHeight) {
        Point2D.Float centerPoint = new Point2D.Float();
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            float cx = (float)this.getX() / scaleFactor;
            float cy = (float)(canvasHeight - this.getY()) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
            float cx = (float)this.getX() / scaleFactor;
            float cy = (float)(canvasHeight - (this.getY() + this.getHeight())) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
            float cx = (float)(this.getX() + this.getWidth()) / scaleFactor;
            float cy = (float)(canvasHeight - (this.getY() + this.getHeight())) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() <= 0 && this.getRelh() > 0) {
            float cx = (float)(this.getX() + this.getWidth()) / scaleFactor;
            float cy = (float)(canvasHeight - this.getY()) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        }
        return centerPoint;
    }

    protected float getLaTexRadius(float scaleFactor) {
        float length = (float)Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        return length /= scaleFactor;
    }

    protected Point2D getLaTexAngles() {
        Point2D.Float anglesPoint = new Point2D.Float();
        if (this.getRelw() == 0) {
            int n = 90;
        }
        int sAngle = (int)Math.round(Math.atan2(this.getRelh(), this.getRelw()) * 180.0 / Math.PI);
        sAngle = -sAngle + 180;
        int eAngle = sAngle + 360;
        if (this.isFlip()) {
            ((Point2D)anglesPoint).setLocation(eAngle, sAngle);
        } else {
            ((Point2D)anglesPoint).setLocation(sAngle, eAngle);
        }
        return anglesPoint;
    }
}

