/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaArcObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaGlArc
extends JaArcObject {
    private static final long serialVersionUID = 1L;

    public JaGlArc() {
        this.setStangle(0);
    }

    @Override
    public final JaObject copy() {
        JaGlArc temp = new JaGlArc();
        temp.setArcPts(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getX(), this.getY());
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setAmp(this.getAmp());
        temp.setFreq(this.getFreq());
        temp.setColor(this.getColor());
        temp.setStroke(this.getStroke());
        temp.setDoubleLine(this.getDoubleLine());
        temp.setDLSeparation(this.getDLSeparation());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaGlArc arc;
        boolean isCopy = false;
        if (comp instanceof JaGlArc && (arc = (JaGlArc)comp).getX1() == this.getX1() && arc.getX2() == this.getX2() && arc.getY1() == this.getY1() && arc.getY2() == this.getY2() && arc.getX() == this.getX() && arc.getY() == this.getY() && arc.getAmp() == this.getAmp() && arc.getFreq() == this.getFreq() && arc.getColor().equals(this.getColor()) && arc.getStroke() == this.getStroke() && arc.getDoubleLine() == this.getDoubleLine() && arc.getDLSeparation() == this.getDLSeparation() && arc.getRelw() == this.getRelw() && arc.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        GeneralPath gp = this.getGeneralPath();
        if (this.testArea()) {
            return;
        }
        gp.reset();
        gp.moveTo(0.0f, 0.0f);
        double[] par = this.getArcParameters();
        Arc2D.Float arc = new Arc2D.Float();
        if (this.isResizing()) {
            g2.setStroke((Stroke)new BasicStroke(1.0f));
            g2.setColor(JaxoColor.RED);
            if (this.getDoubleLine()) {
                ((Arc2D)arc).setArc(-par[2] - (double)this.getDLSeparation(), -par[2] - (double)this.getDLSeparation(), 2.0 * (par[2] + (double)this.getDLSeparation()), 2.0 * (par[2] + (double)this.getDLSeparation()), 0.0, Math.toDegrees(par[3]), 0);
                gp.append(arc, false);
                ((Arc2D)arc).setArc(-par[2] + (double)this.getDLSeparation(), -par[2] + (double)this.getDLSeparation(), 2.0 * (par[2] - (double)this.getDLSeparation()), 2.0 * (par[2] - (double)this.getDLSeparation()), 0.0, Math.toDegrees(par[3]), 0);
                gp.append(arc, false);
            } else {
                ((Arc2D)arc).setArc(-par[2], -par[2], 2.0 * par[2], 2.0 * par[2], 0.0, Math.toDegrees(par[3]), 0);
                gp.append(arc, false);
            }
            gp = this.newtransarc(gp, par[0], par[1], par[4], 1.0);
            g2.draw((Shape)gp);
        } else {
            int i;
            g2.setColor(this.getColor());
            g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
            gp.reset();
            float boh = 0.6f;
            int a = Math.abs(this.getAmp());
            int angamp = -180;
            if (this.getAmp() < 0) {
                angamp = 180;
            }
            double arcLength = 2.0 * par[2] * Math.abs(par[3] / 2.0);
            int n = (int)Math.round((arcLength - (double)this.getFreq()) / (double)this.getFreq() / (double)boh);
            float ts = (float)(arcLength / (double)(1.0f + boh * (float)n));
            if (this.getDoubleLine()) {
                for (i = 0; i < n; ++i) {
                    ((Arc2D)arc).setArc((float)i * ts * boh, -ts / 2.0f + this.getDLSeparation(), ts, a, 180.0, angamp, 0);
                    gp.append(arc, true);
                    ((Arc2D)arc).setArc((float)i * ts * boh, -ts / 2.0f - this.getDLSeparation(), ts, a, 180.0, angamp, 0);
                    gp.append(arc, false);
                    ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, -ts / 2.0f + this.getDLSeparation(), ts * (1.0f - boh), a, 0.0, angamp, 0);
                    gp.append(arc, true);
                    ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, -ts / 2.0f - this.getDLSeparation(), ts * (1.0f - boh), a, 0.0, angamp, 0);
                    gp.append(arc, false);
                }
                ((Arc2D)arc).setArc((float)n * ts * boh, -ts / 2.0f + this.getDLSeparation(), ts, a, 180.0, angamp, 0);
                gp.append(arc, true);
                ((Arc2D)arc).setArc((float)n * ts * boh, -ts / 2.0f - this.getDLSeparation(), ts, a, 180.0, angamp, 0);
                gp.append(arc, false);
            } else {
                for (i = 0; i < n; ++i) {
                    ((Arc2D)arc).setArc((float)i * ts * boh, -ts / 2.0f, ts, a, 180.0, angamp, 0);
                    gp.append(arc, true);
                    ((Arc2D)arc).setArc((float)(i + 1) * ts * boh, -ts / 2.0f, ts * (1.0f - boh), a, 0.0, angamp, 0);
                    gp.append(arc, true);
                }
                ((Arc2D)arc).setArc((float)n * ts * boh, -ts / 2.0f, ts, a, 180.0, angamp, 0);
                gp.append(arc, true);
            }
            gp = this.conformalGP(gp, arcLength, -par[3]);
            AffineTransform at = new AffineTransform();
            at.translate(-par[2], 0.0);
            at.scale(1.0 / (Math.abs(par[3]) / 2.0), 1.0 / (Math.abs(par[3]) / 2.0));
            gp.transform(at);
            gp = this.newtransarc(gp, par[0], par[1], par[4], 1.0);
            g2.draw((Shape)gp);
        }
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        double[] par = this.getArcParameters();
        double cx = par[0] / (double)scale;
        double cy = ((double)canvasDim.height - par[1]) / (double)scale;
        double r = par[2] / (double)scale;
        double ea = -Math.toDegrees(par[4]);
        double sa = Math.toDegrees(par[3] - par[4]);
        double amp = (double)(-this.getAmp()) / (2.0 * (double)scale);
        double nwin = (2.0 * par[2] * Math.abs(par[3] / 2.0) - (double)this.getFreq()) / (double)this.getFreq() / 0.7;
        String command = "";
        String base = "\\GlueArc";
        if (this.getDoubleLine()) {
            float offSet = this.getDLSeparation() / scale;
            String command1 = base + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")(" + D_FORMAT.format(r + (double)offSet) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + "){" + D_FORMAT.format(amp) + "}{" + D_FORMAT.format(nwin) + "}";
            String command2 = base + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")(" + D_FORMAT.format(r - (double)offSet) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + "){" + D_FORMAT.format(amp) + "}{" + D_FORMAT.format(nwin) + "}";
            command = command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(this.getDLSeparation()) + ")"));
        } else {
            command = base + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")(" + D_FORMAT.format(r) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + "){" + D_FORMAT.format(amp) + "}{" + D_FORMAT.format(nwin) + "}";
        }
        return command;
    }

    private Point2D conformal(float px, float py, double length, double angle) {
        float nx = (float)(length / 2.0 * (1.0 + Math.exp((double)py * angle / length) * Math.cos((double)px * angle / length)));
        float ny = (float)(-length / 2.0 * Math.exp((double)py * angle / length) * Math.sin((double)(-px) * angle / length));
        return new Point2D.Float(nx, ny);
    }

    private GeneralPath conformalGP(GeneralPath gpp, double length, double angle) {
        GeneralPath gp2 = new GeneralPath();
        FlatteningPathIterator pi = new FlatteningPathIterator(gpp.getPathIterator(null), 0.05);
        float[] segm = new float[6];
        float corr = 1.0f - 20.0f / (float)length;
        gp2.moveTo(0.0f, 0.0f);
        while (!pi.isDone()) {
            int type = pi.currentSegment(segm);
            float px1 = (float)this.conformal(segm[0], segm[1], length, angle).getX();
            float py1 = (float)this.conformal(segm[0], segm[1], length, angle).getY();
            float px2 = (float)this.conformal(segm[2], segm[3], length, angle).getX();
            float py2 = (float)this.conformal(segm[2], segm[3], length, angle).getY();
            float px3 = (float)this.conformal(segm[4], segm[5], length, angle).getX();
            float py3 = (float)this.conformal(segm[4], segm[5], length, angle).getY();
            if (type == 0) {
                gp2.moveTo(px1, py1);
            } else if (type == 1) {
                gp2.lineTo(px1, py1);
            } else if (type == 2) {
                px1 = (float)this.conformal(segm[0], corr * segm[1], length, angle).getX();
                py1 = (float)this.conformal(segm[0], corr * segm[1], length, angle).getY();
                gp2.quadTo(px1, py1, px2, py2);
            } else if (type == 3) {
                gp2.curveTo(px1, py1, px2, py2, px3, py3);
            } else {
                gp2.closePath();
            }
            pi.next();
        }
        return gp2;
    }
}

