/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaArcObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaGArc
extends JaArcObject {
    private static final long serialVersionUID = 1L;

    @Override
    public final JaObject copy() {
        JaGArc temp = new JaGArc();
        temp.setArcPts(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getX(), this.getY());
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setColor(this.getColor());
        temp.setStroke(this.getStroke());
        temp.setArrow(this.isArrow());
        temp.setFlip(this.isFlip());
        temp.setStangle(this.getStangle());
        temp.setDash(this.getDash());
        temp.setDoubleLine(this.getDoubleLine());
        temp.setDLSeparation(this.getDLSeparation());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaGArc arc;
        boolean isCopy = false;
        if (comp instanceof JaGArc && (arc = (JaGArc)comp).getX1() == this.getX1() && arc.getX2() == this.getX2() && arc.getY1() == this.getY1() && arc.getY2() == this.getY2() && arc.getX() == this.getX() && arc.getY() == this.getY() && arc.getColor().equals(this.getColor()) && arc.getStroke() == this.getStroke() && arc.isArrow() == this.isArrow() && arc.isFlip() == this.isFlip() && arc.getStangle() == this.getStangle() && arc.getDash() == this.getDash() && arc.getDoubleLine() == this.getDoubleLine() && arc.getDLSeparation() == this.getDLSeparation() && arc.getRelw() == this.getRelw() && arc.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        GeneralPath gp = this.getGeneralPath();
        if (this.testArea()) {
            return;
        }
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        GeneralPath gptmp = new GeneralPath();
        gp.reset();
        double[] par = this.getArcParameters();
        if (this.isArrow() && !this.isResizing()) {
            if (this.getDoubleLine()) {
                gp = this.dArcArrow(g2, this.getColor(), par[2], 3.0f * this.getStroke(), this.isFlip(), this.getDLSeparation());
                gp = this.newtransarc(gp, par[0], par[1], (Math.PI - par[3]) / 2.0 + par[4], 1.0);
                g2.fill((Shape)gp);
                gptmp.append(gp, false);
                gp.reset();
                gp = this.dArcArrow(g2, this.getColor(), par[2], 3.0f * this.getStroke(), this.isFlip(), -this.getDLSeparation());
                gp = this.newtransarc(gp, par[0], par[1], (Math.PI - par[3]) / 2.0 + par[4], 1.0);
                g2.fill((Shape)gp);
                gptmp.append(gp, false);
            } else {
                gp = this.arcArrow(g2, this.getColor(), par[2], 4.0f * this.getStroke(), this.isFlip());
                gp = this.newtransarc(gp, par[0], par[1], (Math.PI - par[3]) / 2.0 + par[4], 1.0);
                g2.fill((Shape)gp);
                gptmp.append(gp, false);
            }
        }
        if (this.isResizing()) {
            g2.setColor(JaxoColor.RED);
            g2.setStroke((Stroke)new BasicStroke(1.0f));
        } else {
            g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        }
        gp.reset();
        Arc2D.Double arc = new Arc2D.Double();
        if (this.getDoubleLine()) {
            float cf1 = (float)((par[2] + (double)this.getDLSeparation()) / par[2]);
            float cf2 = (float)((par[2] - (double)this.getDLSeparation()) / par[2]);
            float[] dashes1 = new float[]{cf1 * this.getDash(), 4.0f * cf1 * this.getDash()};
            float[] dashes2 = new float[]{cf2 * this.getDash(), 4.0f * cf2 * this.getDash()};
            ((Arc2D)arc).setArc(-par[2] + (double)this.getDLSeparation(), -par[2] + (double)this.getDLSeparation(), 2.0 * (par[2] - (double)this.getDLSeparation()), 2.0 * (par[2] - (double)this.getDLSeparation()), 0.0, Math.toDegrees(par[3]), 0);
            gp.append(arc, false);
            gp = this.newtransarc(gp, par[0], par[1], par[4], 1.0);
            g2.setStroke((Stroke)new BasicStroke(this.getStroke(), 1, 0, 10.0f, dashes2, 0.0f));
            gptmp.append(gp, false);
            gp.reset();
            ((Arc2D)arc).setArc(-par[2] - (double)this.getDLSeparation(), -par[2] - (double)this.getDLSeparation(), 2.0 * (par[2] + (double)this.getDLSeparation()), 2.0 * (par[2] + (double)this.getDLSeparation()), 0.0, Math.toDegrees(par[3]), 0);
            gp.append(arc, false);
            gp = this.newtransarc(gp, par[0], par[1], par[4], 1.0);
            g2.setStroke((Stroke)new BasicStroke(this.getStroke(), 1, 0, 10.0f, dashes1, 0.0f));
            gptmp.append(gp, false);
        } else {
            float[] dashes = new float[]{this.getDash(), 4.0f * this.getDash()};
            ((Arc2D)arc).setArc(-par[2], -par[2], 2.0 * par[2], 2.0 * par[2], 0.0, Math.toDegrees(par[3]), 0);
            gp.append(arc, false);
            gp = this.newtransarc(gp, par[0], par[1], par[4], 1.0);
            g2.setStroke((Stroke)new BasicStroke(this.getStroke(), 1, 0, 10.0f, dashes, 0.0f));
            gptmp.append(gp, false);
        }
        g2.draw((Shape)gptmp);
        Rectangle2D bb = gptmp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        double[] par = this.getArcParameters();
        double cx = par[0] / (double)scale;
        double cy = ((double)canvasDim.height - par[1]) / (double)scale;
        double r = par[2] / (double)scale;
        double sa = -Math.toDegrees(par[4]);
        double ea = Math.toDegrees(par[3] - par[4]);
        float dashSize = this.getLaTexDashSize(scale);
        String command = "";
        String base = "\\DashCArc";
        if (this.isArrow()) {
            if (this.isFlip()) {
                base = "\\DashArrowArcn";
                double swap = ea;
                ea = sa;
                sa = swap;
            } else {
                base = "\\DashArrowArc";
            }
        }
        if (this.getDoubleLine()) {
            float offSet = this.getDLSeparation() / scale;
            float dashSize1 = (float)((r + (double)offSet) / r) * dashSize;
            float dashSize2 = (float)((r - (double)offSet) / r) * dashSize;
            String command1 = base + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")(" + D_FORMAT.format(r + (double)offSet) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + "){" + D_FORMAT.format(dashSize1) + "}";
            String command2 = base + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")(" + D_FORMAT.format(r - (double)offSet) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + "){" + D_FORMAT.format(dashSize2) + "}";
            command = command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(this.getDLSeparation()) + ")"));
        } else {
            command = base + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")(" + D_FORMAT.format(r) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + "){" + D_FORMAT.format(dashSize) + "}";
        }
        return command;
    }

    private float getLaTexDashSize(float scaleFactor) {
        float dshSize = this.getDash() / scaleFactor;
        return dshSize;
    }
}

