/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import jhplot.jadraw.JaLoopObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaFLoop
extends JaLoopObject {
    private static final long serialVersionUID = 1L;

    @Override
    public final JaObject copy() {
        JaFLoop temp = (JaFLoop)this.copy(new JaFLoop());
        temp.setArrow(this.isArrow());
        temp.setFlip(this.isFlip());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaFLoop && super.isCopy(comp) && ((JaFLoop)comp).isArrow() == this.isArrow() && ((JaFLoop)comp).isFlip() == this.isFlip()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        GeneralPath gptmp = new GeneralPath();
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        if (this.isArrow()) {
            if (this.getDoubleLine()) {
                gp = this.dLoopArrow(g2, this.getColor(), length, 3.0f * this.getStroke(), this.getFlip(), this.getDLSeparation());
                gptmp.append(gp, false);
                gp.reset();
                gp = this.dLoopArrow(g2, this.getColor(), length, 3.0f * this.getStroke(), this.getFlip(), -this.getDLSeparation());
                gptmp.append(gp, false);
            } else {
                gp = this.loopArrow(g2, this.getColor(), length, 4.0f * this.getStroke(), this.getFlip());
                gptmp.append(gp, false);
            }
        }
        gp.reset();
        gp.moveTo(0.0f, 0.0f);
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        Ellipse2D.Double loop = new Ellipse2D.Double();
        if (this.getDoubleLine()) {
            ((RectangularShape)loop).setFrame(-length - (double)this.getDLSeparation(), -length - (double)this.getDLSeparation(), 2.0 * (length + (double)this.getDLSeparation()), 2.0 * (length + (double)this.getDLSeparation()));
            gp.append(loop, false);
            ((RectangularShape)loop).setFrame(-length + (double)this.getDLSeparation(), -length + (double)this.getDLSeparation(), 2.0 * (length - (double)this.getDLSeparation()), 2.0 * (length - (double)this.getDLSeparation()));
            gp.append(loop, false);
        } else {
            ((RectangularShape)loop).setFrame(-length, -length, 2.0 * length, 2.0 * length);
            gp.append(loop, false);
        }
        gp = this.trans(gp, 1.0);
        gptmp.append(gp, false);
        g2.draw((Shape)gptmp);
        Rectangle2D bb = gptmp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        float radius = this.getLaTexRadius(scale);
        Point2D angles = this.getLaTexAngles();
        String command = "";
        String base = "\\CArc";
        if (this.isArrow()) {
            base = this.isFlip() ? "\\ArrowArcn" : "\\ArrowArc";
        }
        if ((int)radius == 0) {
            command = "%";
        } else if (this.getDoubleLine()) {
            float offSet = this.getDLSeparation() / scale;
            String command1 = base + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(radius + offSet) + "," + D_FORMAT.format(angles.getX()) + "," + D_FORMAT.format(angles.getY()) + ")";
            String command2 = base + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(radius - offSet) + "," + D_FORMAT.format(angles.getX()) + "," + D_FORMAT.format(angles.getY()) + ")";
            command = command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(this.getDLSeparation()) + ")"));
        } else {
            command = base + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(radius) + "," + D_FORMAT.format(angles.getX()) + "," + D_FORMAT.format(angles.getY()) + ")";
        }
        return command;
    }
}

