/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoBlobOptionsPanel;
import japlot.jaxodraw.JaxoColor;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import jhplot.jadraw.JaFillObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaBlob
extends JaFillObject {
    private static final long serialVersionUID = 1L;
    private int rotAngle;
    private float transp;
    private boolean fill;

    public JaBlob() {
        this.setRelw(25);
        this.setRelh(25);
        this.rotAngle = 0;
        this.transp = 1.0f;
        this.fill = true;
    }

    public final int getRotAngle() {
        return this.rotAngle;
    }

    public final void setRotAngle(int newangle) {
        this.rotAngle = newangle;
    }

    public void setTransparency(float transp) {
        this.transp = transp;
    }

    public void setFilled(boolean fill) {
        this.fill = fill;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public float getTransparency() {
        return this.transp;
    }

    @Override
    public final JaObject copy() {
        JaBlob temp = new JaBlob();
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setColor(this.getColor());
        temp.setFilled(this.isFilled());
        temp.setTransparency(this.getTransparency());
        temp.setFillColor(this.getFillColor());
        temp.setStroke(this.getStroke());
        temp.setRotAngle(this.getRotAngle());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaBlob temp;
        boolean isCopy = false;
        if (comp instanceof JaBlob && (temp = (JaBlob)comp).getX() == this.getX() && temp.getY() == this.getY() && temp.getColor().equals(this.getColor()) && temp.getFillColor().equals(this.getFillColor()) && temp.getStroke() == this.getStroke() && temp.getRotAngle() == this.getRotAngle() && temp.isFilled() == this.isFilled() && temp.getRelw() == this.getRelw() && temp.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void drawVisualAid(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.3f));
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            g2.drawLine(this.getX() - 12, this.getY(), this.getX() + 8 + 4, this.getY());
            g2.drawLine(this.getX(), this.getY() - 12, this.getX(), this.getY() + 8 + 4);
        }
        if (this.getRelw() <= 0 && this.getRelh() > 0) {
            g2.drawLine(this.getX() + this.getWidth() - 12, this.getY(), this.getX() + this.getWidth() + 12, this.getY());
            g2.drawLine(this.getX() + this.getWidth(), this.getY() - 12, this.getX() + this.getWidth(), this.getY() + 12);
        }
        if (this.getRelw() < 0 && this.getRelh() <= 0) {
            g2.drawLine(this.getX() + this.getWidth(), this.getY() + this.getHeight() - 12, this.getX() + this.getWidth(), this.getY() + this.getHeight() + 12);
            g2.drawLine(this.getX() + this.getWidth() - 12, this.getY() + this.getHeight(), this.getX() + this.getWidth() + 12, this.getY() + this.getHeight());
        }
        if (this.getRelw() >= 0 && this.getRelh() < 0) {
            g2.drawLine(this.getX() - 12, this.getY() + this.getHeight(), this.getX() + 12, this.getY() + this.getHeight());
            g2.drawLine(this.getX(), this.getY() + this.getHeight() - 12, this.getX(), this.getY() + this.getHeight() + 12);
        }
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.3f));
        if (this.getRelw() > 0 && this.getRelh() >= 0 || this.getRelw() < 0 && this.getRelh() <= 0) {
            g2.drawRect(this.getX() - 4, this.getY() - 4, 8, 8);
            g2.drawRect(this.getX() + this.getWidth() - 4, this.getY() + this.getHeight() - 4, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(this.getX() - 4 + 1, this.getY() - 4 + 1, 7, 7);
                g2.fillRect(this.getX() + this.getWidth() - 4 + 1, this.getY() + this.getHeight() - 4 + 1, 7, 7);
            }
        }
        if (this.getRelw() <= 0 && this.getRelh() > 0 || this.getRelw() >= 0 && this.getRelh() < 0) {
            g2.drawRect(this.getX() - 4, this.getY() + this.getHeight() - 4, 8, 8);
            g2.drawRect(this.getX() + this.getWidth() - 4, this.getY() - 4, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(this.getX() - 4 + 1, this.getY() + this.getHeight() - 4 + 1, 7, 7);
                g2.fillRect(this.getX() + this.getWidth() - 4 + 1, this.getY() - 4 + 1, 7, 7);
            }
        }
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        if (editmode == 50 || editmode == 52) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
            }
            if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
            }
            if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
            }
            if (this.getRelw() <= 0 && this.getRelh() > 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 11;
                }
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 11;
                }
            }
            return 0;
        }
        if (editmode == 51) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                    return 14;
                }
            } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 12;
                }
            } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= this.getX() + this.getWidth() - 4 && clickX <= this.getX() + this.getWidth() + 4 && clickY >= this.getY() - 4 && clickY <= this.getY() + 4) {
                    return 13;
                }
            } else if (this.getRelw() <= 0 && this.getRelh() > 0 && clickX >= this.getX() - 4 && clickX <= this.getX() + 4 && clickY >= this.getY() + this.getHeight() - 4 && clickY <= this.getY() + this.getHeight() + 4) {
                return 15;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(this.rotAngle), 0.0, 0.0);
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        Ellipse2D.Float blob = new Ellipse2D.Float();
        ((RectangularShape)blob).setFrame(-this.getWidth(), -this.getHeight(), 2 * this.getWidth(), 2 * this.getHeight());
        gp.append(blob, false);
        gp.transform(at);
        gp = this.transc(gp, 1.0);
        Composite cold = g2.getComposite();
        AlphaComposite c = AlphaComposite.getInstance(3, this.transp);
        g2.setComposite((Composite)c);
        g2.setColor(this.getFillColor());
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        if (this.fill) {
            g2.fill((Shape)gp);
        }
        gp.reset();
        gp.append(blob, false);
        gp.transform(at);
        gp = this.transc(gp, 1.0);
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
        g2.setComposite(cold);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        Point2D axes = this.getLaTexAxes(scale);
        int rotate = this.getLaTexRotation();
        String command = "";
        if ((int)axes.getX() == 0 && (int)axes.getY() == 0) {
            command = "%";
        } else if (JaxoColor.isGrayScale(this.getFillColor())) {
            String grayScale = JaxoColor.getGreyScale(this.getFillColor());
            command = "\\GOval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")(" + D_FORMAT.format(rotate) + "){" + grayScale + "}";
        } else {
            String tlc = JaxoColor.getColorName(this.getColor());
            String tfc = JaxoColor.getColorName(this.getFillColor());
            command = "\\COval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")(" + D_FORMAT.format(rotate) + "){" + tlc + "}{" + tfc + "}";
        }
        return command;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
        this.setRelWAndH(newRelWidth, newRelHeight);
    }

    private GeneralPath transc(GeneralPath gpp, double scale) {
        AffineTransform at = new AffineTransform();
        if (this.getRelw() >= 0 && this.getRelh() >= 0) {
            at.translate(this.getX(), this.getY());
            at.scale(scale, scale);
            gpp.transform(at);
        }
        if (this.getRelw() >= 0 && this.getRelh() < 0) {
            at.translate(this.getX(), this.getY() + this.getHeight());
            at.scale(scale, scale);
            gpp.transform(at);
        }
        if (this.getRelw() < 0 && this.getRelh() <= 0) {
            at.translate(this.getX() + this.getWidth(), this.getY() + this.getHeight());
            at.scale(scale, scale);
            gpp.transform(at);
        }
        if (this.getRelw() < 0 && this.getRelh() > 0) {
            at.translate(this.getX() + this.getWidth(), this.getY());
            at.scale(scale, scale);
            gpp.transform(at);
        }
        return gpp;
    }

    private Point2D getLaTexCenter(float scaleFactor, int canvasHeight) {
        Point2D.Float centerPoint = new Point2D.Float();
        if (this.getRelw() > 0 && this.getRelh() >= 0) {
            float cx = (float)this.getX() / scaleFactor;
            float cy = (float)(canvasHeight - this.getY()) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
            float cx = (float)this.getX() / scaleFactor;
            float cy = (float)(canvasHeight - (this.getY() + this.getHeight())) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
            float cx = (float)(this.getX() + this.getWidth()) / scaleFactor;
            float cy = (float)(canvasHeight - (this.getY() + this.getHeight())) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        } else if (this.getRelw() <= 0 && this.getRelh() > 0) {
            float cx = (float)(this.getX() + this.getWidth()) / scaleFactor;
            float cy = (float)(canvasHeight - this.getY()) / scaleFactor;
            ((Point2D)centerPoint).setLocation(cx, cy);
        }
        return centerPoint;
    }

    private Point2D getLaTexAxes(float scaleFactor) {
        Point2D.Float axesVec = new Point2D.Float();
        float wdt = (float)this.getWidth() / scaleFactor;
        float hgt = (float)this.getHeight() / scaleFactor;
        ((Point2D)axesVec).setLocation(wdt, hgt);
        return axesVec;
    }

    private int getLaTexRotation() {
        int rt = -this.rotAngle;
        return rt;
    }

    @Override
    public final boolean editPanel() {
        JaxoBlobOptionsPanel blobop = new JaxoBlobOptionsPanel(this);
        return blobop.hasChanged();
    }
}

