/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoArcOptionsPanel;
import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import jhplot.jadraw.JaGlArc;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaPArc;
import org.freehep.graphics2d.VectorGraphics;

public abstract class JaArcObject
extends JaObject {
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private float stroke;
    private float dash;
    private float freq;
    private int stangle;
    private boolean arrow;
    private boolean flip;
    private boolean end;
    private int amp;
    private boolean doubleLine;
    private float dlSeparation;
    private boolean isRes = false;

    public JaArcObject() {
        this.setRelw(25);
        this.setRelh(25);
        this.setAmp(-JaxoPrefs.getIntPref(104));
        this.setFreq(20.0f);
        this.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        this.setStroke(JaxoPrefs.getFloatPref(200));
        this.setDoubleLine(false);
        this.setDLSeparation(JaxoPrefs.getFloatPref(201));
    }

    public final void setIsResizing(boolean ir) {
        this.isRes = ir;
    }

    public final boolean isResizing() {
        return this.isRes;
    }

    public final void setX1(int newx1) {
        this.x1 = newx1;
    }

    public final int getX1() {
        return this.x1;
    }

    public final void setX2(int newx2) {
        this.x2 = newx2;
    }

    public final int getX2() {
        return this.x2;
    }

    public final void setY1(int newy1) {
        this.y1 = newy1;
    }

    public final int getY1() {
        return this.y1;
    }

    public final void setY2(int newy2) {
        this.y2 = newy2;
    }

    public final int getY2() {
        return this.y2;
    }

    public final void setArcPts(int sx1, int sy1, int sx2, int sy2, int sx3, int sy3) {
        this.setX1(sx1);
        this.setY1(sy1);
        this.setX2(sx2);
        this.setY2(sy2);
        this.setX(sx3);
        this.setY(sy3);
    }

    public final float getStroke() {
        return this.stroke;
    }

    public final void setStroke(float newStroke) {
        this.stroke = newStroke;
    }

    public final float getDash() {
        return this.dash;
    }

    public final void setDash(float newDash) {
        this.dash = newDash;
    }

    public final float getFreq() {
        return this.freq;
    }

    public final void setFreq(float newFreq) {
        this.freq = newFreq;
    }

    public final int getAmp() {
        return this.amp;
    }

    public final void setAmp(int newAmp) {
        this.amp = newAmp;
    }

    public final int getStangle() {
        return this.stangle;
    }

    public final void setStangle(int newStangle) {
        this.stangle = newStangle;
    }

    public final boolean isArrow() {
        return this.arrow;
    }

    public final boolean getArrow() {
        return this.arrow;
    }

    public final void setArrow(boolean arr) {
        this.arrow = arr;
    }

    public final boolean isEnd() {
        return this.end;
    }

    public final boolean getEnd() {
        return this.end;
    }

    public final void setEnd(boolean mid) {
        this.end = mid;
    }

    public final boolean isFlip() {
        return this.flip;
    }

    public final boolean getFlip() {
        return this.flip;
    }

    public final void setFlip(boolean newFlip) {
        this.flip = newFlip;
    }

    public final void setDoubleLine(boolean dline) {
        this.doubleLine = dline;
    }

    public final boolean getDoubleLine() {
        return this.doubleLine;
    }

    public final void setDLSeparation(float dlsep) {
        this.dlSeparation = dlsep;
    }

    public final float getDLSeparation() {
        return this.dlSeparation;
    }

    @Override
    public final void drawVisualAid(VectorGraphics g2) {
        float ax1 = this.getX1();
        float ay1 = this.getY1();
        float ax2 = this.getX2();
        float ay2 = this.getY2();
        float ax3 = this.getX();
        float ay3 = this.getY();
        GeneralPath gp = new GeneralPath();
        gp.moveTo(ax1, ay1);
        gp.lineTo(ax2, ay2);
        gp.lineTo(ax3, ay3);
        gp.closePath();
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.draw((Shape)gp);
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        int ax1 = this.getX1();
        int ay1 = this.getY1();
        int ax2 = this.getX2();
        int ay2 = this.getY2();
        int ax3 = this.getX();
        int ay3 = this.getY();
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.drawRect(ax1 - 4, ay1 - 4, 8, 8);
        g2.drawRect(ax2 - 4, ay2 - 4, 8, 8);
        g2.drawRect(ax3 - 4, ay3 - 4, 8, 8);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(ax1 - 4 + 1, ay1 - 4 + 1, 7, 7);
            g2.fillRect(ax2 - 4 + 1, ay2 - 4 + 1, 7, 7);
            g2.fillRect(ax3 - 4 + 1, ay3 - 4 + 1, 7, 7);
        }
    }

    public final double[] getArcParameters() {
        double[] params = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double ax1 = this.getX1();
        double ay1 = this.getY1();
        double ax2 = this.getX2();
        double ay2 = this.getY2();
        double ax3 = this.getX();
        double ay3 = this.getY();
        double a = this.getA(ax1, ay1, ax2, ay2, ax3, ay3);
        double b = this.getB(ax1, ay1, ax2, ay2, ax3, ay3);
        double c = this.getC(ax1, ay1, ax2, ay2, ax3, ay3);
        this.setRelw((int)Math.round(ax3 - ax1));
        this.setRelh((int)Math.round(ay3 - ay1));
        double radius = Math.sqrt(a * a / 4.0 + b * b / 4.0 - c);
        double cordlength = Math.sqrt(Math.pow(ax1 - ax3, 2.0) + Math.pow(ay1 - ay3, 2.0));
        double alpha = 2.0 * Math.asin(cordlength / (2.0 * radius));
        double theta = Math.atan2(ay3 + b / 2.0, ax3 + a / 2.0);
        double[] arcp = new double[]{0.0, 0.0};
        if (ax1 <= ax2 && ax2 <= ax3 && ay2 <= ay3 && ay3 <= ay1 || ax3 <= ax1 && ax1 <= ax2 && ay1 <= ay2 && ay2 <= ay3 || ax2 <= ax3 && ax3 < ax1 && ay3 <= ay1 && ay1 <= ay2 || ax1 <= ax2 && ax2 <= ax3 && ay2 <= ay1 && ay1 < ay3 || ax3 < ax1 && ax1 <= ax2 && ay1 <= ay3 && ay3 < ay2 || ax2 <= ax3 && ax3 < ax1 && ay3 <= ay2 && ay2 < ay1 || ax1 <= ax2 && ax2 < ax3 && ay3 <= ay2 && ay2 < ay1 || ax2 <= ax3 && ax3 <= ax1 && ay1 < ay3 && ay3 < ay2 || ax3 <= ax1 && ax1 < ax2 && ay2 <= ay1 && ay1 < ay3 || ax2 < ax1 && ax1 <= ax3 && ay3 <= ay2 && ay2 <= ay1 || ax3 < ax2 && ax2 < ax1 && ay1 <= ay3 && ay3 <= ay2 || ax1 < ax3 && ax3 < ax2 && ay2 <= ay1 && ay1 <= ay3 || ax2 < ax1 && ax1 < ax3 && ay2 < ay3 && ay3 <= ay1 || ax1 < ax3 && ax3 <= ax2 && ay1 < ay2 && ay2 < ay3 || ax3 <= ax2 && ax2 <= ax1 && ay3 < ay1 && ay1 <= ay2 || ax2 < ax1 && ax1 <= ax3 && ay2 < ay1 && ay1 < ay3 || ax3 < ax2 && ax2 < ax1 && ay3 < ay2 && ay2 < ay1 || ax1 <= ax3 && ax3 < ax2 && ay1 < ay3 && ay3 <= ay2 || ax3 <= ax1 && ax1 < ax2 && ay3 < ay1 && ay1 <= ay2) {
            theta = Math.atan2(ay3 + b / 2.0, ax3 + a / 2.0);
            arcp = this.testArc(radius, -a / 2.0, -b / 2.0, alpha, theta, ax1, ay1);
        } else if (ax3 <= ax2 && ax2 <= ax1 && ay2 <= ay1 && ay1 <= ay3 || ax1 <= ax3 && ax3 <= ax2 && ay3 <= ay2 && ay2 <= ay1 || ax2 <= ax1 && ax1 < ax3 && ay1 <= ay3 && ay3 <= ay2 || ax3 <= ax2 && ax2 <= ax1 && ay2 <= ay3 && ay3 < ay1 || ax1 < ax3 && ax3 <= ax2 && ay3 <= ay1 && ay1 < ay2 || ax2 <= ax1 && ax1 < ax3 && ay1 <= ay2 && ay2 < ay3 || ax3 <= ax2 && ax2 < ax1 && ay1 <= ay2 && ay2 < ay3 || ax2 <= ax1 && ax1 <= ax3 && ay3 < ay1 && ay1 < ay2 || ax1 <= ax3 && ax3 < ax2 && ay2 <= ay3 && ay3 < ay1 || ax2 < ax3 && ax3 <= ax1 && ay1 <= ay2 && ay2 <= ay3 || ax1 < ax2 && ax2 < ax3 && ay3 <= ay1 && ay1 <= ay2 || ax3 < ax1 && ax1 < ax2 && ay2 <= ay3 && ay3 <= ay1 || ax2 < ax3 && ax3 < ax1 && ay2 < ay1 && ay1 <= ay3 || ax3 < ax1 && ax1 <= ax2 && ay3 < ay2 && ay2 < ay1 || ax1 <= ax2 && ax2 <= ax3 && ay1 < ay3 && ay3 <= ay2 || ax2 < ax3 && ax3 <= ax1 && ay2 < ay3 && ay3 < ay1 || ax1 < ax2 && ax2 < ax3 && ay1 < ay2 && ay2 < ay3) {
            theta = Math.atan2(ay1 + b / 2.0, ax1 + a / 2.0);
            arcp = this.testArc(radius, -a / 2.0, -b / 2.0, alpha, theta, ax3, ay3);
        }
        params[0] = -a / 2.0;
        params[1] = -b / 2.0;
        params[2] = radius;
        params[3] = arcp[0];
        params[4] = arcp[1];
        return params;
    }

    private double getA(double ax1, double ay1, double ax2, double ay2, double ax3, double ay3) {
        double y12 = ay1 - ay2;
        double y13 = ay1 - ay3;
        double y23 = ay2 - ay3;
        double a = (-y12 * (ax3 * ax3 + y13 * y23) + ax2 * ax2 * y13 - ax1 * ax1 * y23) / (ax3 * y12 + ax1 * y23 - ax2 * y13);
        return a;
    }

    private double getB(double ax1, double ay1, double ax2, double ay2, double ax3, double ay3) {
        double y12 = ay1 - ay2;
        double y13 = ay1 - ay3;
        double y23 = ay2 - ay3;
        double b = (ax1 * ax1 * ax2 - ax1 * ax2 * ax2 - ax1 * ax1 * ax3 + ax2 * ax2 * ax3 + ax1 * ax3 * ax3 - ax2 * ax3 * ax3 - ax3 * ay1 * y12 - ax3 * y12 * ay2 + ax2 * ay1 * y13 - ax1 * ay2 * y23 + ax2 * y13 * ay3 - ax1 * y23 * ay3) / (ax3 * y12 + ax1 * y23 - ax2 * y13);
        return b;
    }

    private double getC(double ax1, double ay1, double ax2, double ay2, double ax3, double ay3) {
        double y12 = ay1 - ay2;
        double y13 = ay1 - ay3;
        double y23 = ay2 - ay3;
        double c = (-ax2 * ax2 * ax3 * ay1 + ax2 * ax3 * ax3 * ay1 + ax1 * ax1 * ax3 * ay2 - ax1 * ax3 * ax3 * ay2 + ax3 * ay1 * y12 * ay2 - ax1 * ax1 * ax2 * ay3 + ax1 * ax2 * ax2 * ay3 - ax2 * ay1 * y13 * ay3 + ax1 * ay2 * y23 * ay3) / (ax3 * y12 + ax1 * y23 - ax2 * y13);
        return c;
    }

    protected final boolean testArea() {
        double sideC;
        double sideB;
        boolean failed = false;
        double sideA = Math.sqrt(Math.pow(this.getX1() - this.getX2(), 2.0) + Math.pow(this.getY1() - this.getY2(), 2.0));
        double semip = 0.5 * (sideA + (sideB = Math.sqrt(Math.pow(this.getX() - this.getX2(), 2.0) + Math.pow(this.getY() - this.getY2(), 2.0))) + (sideC = Math.sqrt(Math.pow(this.getX1() - this.getX(), 2.0) + Math.pow(this.getY1() - this.getY(), 2.0))));
        double area = Math.sqrt(semip * (semip - sideA) * (semip - sideB) * (semip - sideC));
        if (area < 150.0) {
            failed = true;
        }
        return failed;
    }

    protected final double[] testArc(double r, double cx, double cy, double al, double th, double tx, double ty) {
        double[] newpar = new double[]{0.0, 0.0};
        double newalpha = al;
        double newtheta = th;
        double ax1 = this.getX1();
        double ay1 = this.getY1();
        double ax2 = this.getX2();
        double ay2 = this.getY2();
        double ax3 = this.getX();
        double ay3 = this.getY();
        double xG = (ax1 + ax2 + ax3) / 3.0;
        double yG = (ay1 + ay2 + ay3) / 3.0;
        double fact = 1.5;
        ax1 = xG + fact * (ax1 - xG);
        ay1 = yG + fact * (ay1 - yG);
        ax2 = xG + fact * (ax2 - xG);
        ay2 = yG + fact * (ay2 - yG);
        ax3 = xG + fact * (ax3 - xG);
        ay3 = yG + fact * (ay3 - yG);
        double a = this.getA(ax1, ay1, ax2, ay2, ax3, ay3);
        double b = this.getB(ax1, ay1, ax2, ay2, ax3, ay3);
        double c = this.getC(ax1, ay1, ax2, ay2, ax3, ay3);
        double radius = Math.sqrt(a * a / 4.0 + b * b / 4.0 - c);
        Arc2D.Double arc = new Arc2D.Double(-r, -r, 2.0 * r, 2.0 * r, 0.0, Math.toDegrees(al), 0);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.append(arc, false);
        gp = this.newtransarc(gp, cx, cy, th, 1.0);
        if (Math.abs(gp.getCurrentPoint().getX() - tx) > 1.0E-4) {
            newpar[0] = Math.PI * 2 - al;
            newpar[1] = th;
            Arc2D.Double arc1 = new Arc2D.Double(-radius, -radius, 2.0 * radius, 2.0 * radius, 0.0, Math.toDegrees(newpar[0]), 1);
            GeneralPath gp1 = new GeneralPath();
            gp1.moveTo(0.0f, 0.0f);
            gp1.append(arc1, false);
            gp1 = this.newtransarc(gp1, -a / 2.0, -b / 2.0, newpar[1], 1.0);
            Arc2D.Double arc3 = new Arc2D.Double(-r, -r, 2.0 * r, 2.0 * r, 0.0, Math.toDegrees(newpar[0]), 0);
            GeneralPath gp3 = new GeneralPath();
            gp3.moveTo(0.0f, 0.0f);
            gp3.append(arc3, false);
            gp3 = this.newtransarc(gp3, cx, cy, newpar[1], 1.0);
            if (Math.abs(gp3.getCurrentPoint().getX() - tx) > 0.001) {
                newpar[0] = al;
                return newpar;
            }
            Point2D.Double testPoint = new Point2D.Double(this.getX2(), this.getY2());
            if (!gp1.contains(testPoint)) {
                newpar[0] = al;
                newpar[1] = Math.atan2(ty - cy, tx - cx);
            }
            return newpar;
        }
        Arc2D.Double arc2 = new Arc2D.Double(-radius, -radius, 2.0 * radius, 2.0 * radius, 0.0, Math.toDegrees(al), 1);
        GeneralPath gp2 = new GeneralPath();
        gp2.moveTo(0.0f, 0.0f);
        gp2.append(arc2, false);
        gp2 = this.newtransarc(gp2, -a / 2.0, -b / 2.0, th, 1.0);
        Point2D.Double testPoint = new Point2D.Double(this.getX2(), this.getY2());
        if (!gp2.contains(testPoint)) {
            newpar[0] = Math.PI * 2 - al;
            newpar[1] = Math.atan2(ty - cy, tx - cx);
            return newpar;
        }
        newpar[0] = newalpha;
        newpar[1] = newtheta;
        return newpar;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        int ax1 = this.getX1();
        int ay1 = this.getY1();
        int ax2 = this.getX2();
        int ay2 = this.getY2();
        int ax3 = this.getX();
        int ay3 = this.getY();
        int l2 = 4;
        if (editmode == 50 || editmode == 52) {
            if (clickX >= ax1 - l2 && clickX <= ax1 + l2 && clickY >= ay1 - l2 && clickY <= ay1 + l2) {
                return 11;
            }
            if (clickX >= ax2 - l2 && clickX <= ax2 + l2 && clickY >= ay2 - l2 && clickY <= ay2 + l2) {
                return 11;
            }
            if (clickX >= ax3 - l2 && clickX <= ax3 + l2 && clickY >= ay3 - l2 && clickY <= ay3 + l2) {
                return 11;
            }
        } else if (editmode == 51) {
            if (clickX >= this.x1 - l2 && clickX <= ax1 + l2 && clickY >= ay1 - l2 && clickY <= ay1 + l2) {
                return 1;
            }
            if (clickX >= ax2 - l2 && clickX <= ax2 + l2 && clickY >= ay2 - l2 && clickY <= ay2 + l2) {
                return 2;
            }
            if (clickX >= ax3 - l2 && clickX <= ax3 + l2 && clickY >= ay3 - l2 && clickY <= ay3 + l2) {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public final void moveBy(int deltaX, int deltaY) {
        this.setArcPts(this.getX1() + deltaX, this.getY1() + deltaY, this.getX2() + deltaX, this.getY2() + deltaY, this.getX() + deltaX, this.getY() + deltaY);
    }

    protected final GeneralPath arcArrow(VectorGraphics g2, Color c, double length, float size, boolean fl) {
        g2.setColor(c);
        g2.setStroke((Stroke)new BasicStroke(2.0f));
        GeneralPath gp = new GeneralPath();
        float arrowsize = 5.0f * size / 8.0f;
        gp.moveTo(arrowsize, 0.0f);
        gp.lineTo(-arrowsize, arrowsize / 1.5f);
        gp.lineTo(-arrowsize / 1.5f, 0.0f);
        gp.lineTo(-arrowsize, -arrowsize / 1.5f);
        gp.closePath();
        AffineTransform at = new AffineTransform();
        at.translate(0.0, -length);
        if (!this.flip) {
            at.rotate(Math.toRadians(180.0), 0.0, 0.0);
        }
        gp.transform(at);
        return gp;
    }

    protected final GeneralPath dArcArrow(VectorGraphics g2, Color c, double length, float size, boolean fl, float dlSep) {
        g2.setStroke((Stroke)new BasicStroke(2.0f));
        GeneralPath gp = new GeneralPath();
        float arrowsize = 5.0f * size / 8.0f;
        gp.moveTo(arrowsize, dlSep);
        gp.lineTo(-arrowsize, arrowsize / 1.5f + dlSep);
        gp.lineTo(-arrowsize / 1.5f, 0.0f + dlSep);
        gp.lineTo(-arrowsize, -arrowsize / 1.5f + dlSep);
        gp.closePath();
        AffineTransform at = new AffineTransform();
        at.translate(0.0, -length);
        if (!this.flip) {
            at.rotate(Math.toRadians(180.0), 0.0, 0.0);
        }
        gp.transform(at);
        g2.setPaint((Paint)c);
        g2.fill((Shape)gp);
        return gp;
    }

    protected final GeneralPath newtransarc(GeneralPath gp, double cx, double cy, double theta, double scale) {
        AffineTransform at = new AffineTransform();
        at.translate(cx, cy);
        at.rotate(theta, 0.0, 0.0);
        at.scale(scale, scale);
        gp.transform(at);
        return gp;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        Point2D p1 = this.scalePoint(orx, ory, scale, this.getX1(), this.getY1());
        Point2D p2 = this.scalePoint(orx, ory, scale, this.getX2(), this.getY2());
        Point2D p3 = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setArcPts((int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()), (int)Math.round(p3.getX()), (int)Math.round(p3.getY()));
        double[] par = this.getArcParameters();
        int namp = (int)((float)this.getAmp() * scale);
        int nwig = 0;
        float nfreq = 0.0f;
        if (this instanceof JaPArc) {
            nwig = (int)(Math.PI * 2 * par[2] / (double)this.getFreq());
            nfreq = (float)(Math.PI * 2 * par[2] / (double)nwig);
        }
        if (this instanceof JaGlArc) {
            nwig = (int)(Math.PI * 2 * par[2] / (double)this.getFreq() / 0.6);
            nfreq = (float)(Math.PI * 2 * par[2] / (double)nwig / 0.6);
        }
        this.setAmp(namp);
        this.setFreq(nfreq);
    }

    @Override
    public final boolean editPanel() {
        JaxoArcOptionsPanel arcop = new JaxoArcOptionsPanel(this);
        return arcop.hasChanged();
    }

    @Override
    public final String latexWidth() {
        String thisValue = Float.toString(this.getStroke() / 2.0f);
        String base = "\\SetWidth{";
        String closing = "}";
        String lineWidth = base.concat(thisValue.concat(closing));
        return lineWidth;
    }
}

