/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPopupListener;
import japlot.jaxodraw.JaxoPrefs;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JaxoTabbedCanvasPanel
extends JTabbedPane
implements ChangeListener {
    private JaxoPopupListener popupListener;
    private JaxoMainPanel thePanel;
    private HashMap fileNames = new HashMap();
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));

    public JaxoTabbedCanvasPanel(JaxoMainPanel panel) {
        this.thePanel = panel;
        this.popupListener = new JaxoPopupListener(this.thePanel, 0);
        this.addMouseListener(this.popupListener);
        this.addChangeListener(this);
    }

    @Override
    public final void stateChanged(ChangeEvent evt) {
        JaxoCanvas theCanvas = (JaxoCanvas)this.getSelectedComponent();
        this.thePanel.setFlagPanelFileName(theCanvas.getCanvasGraph().getSaveFileName());
        if (this.thePanel.isEditMode()) {
            this.thePanel.getEbtPanel().pressButton(this.thePanel.getEbtPanel().getIndex(this.thePanel.getMode()));
            theCanvas.drawWithHandles(true);
        } else if (this.thePanel.isParticleMode()) {
            this.thePanel.getPbtPanel().pressButton(this.thePanel.getPbtPanel().getIndex(this.thePanel.getMode()));
            theCanvas.drawWithHandles(false);
        } else if (this.thePanel.isMiscMode()) {
            this.thePanel.getMbtPanel().pressButton(this.thePanel.getMbtPanel().getIndex(this.thePanel.getMode()));
            theCanvas.drawWithHandles(false);
        }
        theCanvas.drawVisualAid(false);
        theCanvas.repaint();
        if (theCanvas.getOffScreenImage() != null) {
            this.thePanel.updateZoom();
        }
    }

    public final void registerTitle(String title) {
        Integer integer = (Integer)this.fileNames.get(title);
        if (integer == null) {
            this.fileNames.put(title, new Integer(0));
        } else {
            this.fileNames.put(title, new Integer(integer + 1));
        }
    }

    public final String getIndexedTitle(String title) {
        int val;
        Integer integer = (Integer)this.fileNames.get(title);
        if (integer != null && (val = integer.intValue()) != 0) {
            return new StringBuffer(title).append("_").append(val).toString();
        }
        return title;
    }

    public final void removeTitle(int index, String title) {
        boolean more = false;
        for (int i = 0; i < this.getTabCount(); ++i) {
            String name;
            if (i == index || (name = this.getComponentAt(i).getName()) == null || !name.equals(title)) continue;
            more = true;
            break;
        }
        if (!more) {
            this.fileNames.remove(title);
        }
    }

    public final void removeAllUntitled() {
        for (int i = 0; i < this.fileNames.size(); ++i) {
            this.fileNames.remove("Untitled");
            this.fileNames.remove("Sans titre");
            this.fileNames.remove("N.N.");
            this.fileNames.remove("Senza titolo");
            this.fileNames.remove("Sin t\ufffdtulo");
        }
    }

    public final void setModifiedIcon(int index) {
        ImageIcon modifiedCanvas = new ImageIcon(JaxoTabbedCanvasPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/modified.png"));
        this.setIconAt(index, modifiedCanvas);
    }

    public final void removeModifiedIcon(int index) {
        this.setIconAt(index, null);
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.popupListener.setLanguage(languageString);
        this.removeAllUntitled();
        for (int i = 0; i < this.getTabCount(); ++i) {
            ((JaxoCanvas)this.getComponentAt(i)).setLanguage(languageString);
            String name = this.getComponentAt(i).getName();
            if (name == null || !name.equals("Untitled") && !name.equals("Sans titre") && !name.equals("N.N.") && !name.equals("Senza titolo") && !name.equals("Sin t\ufffdtulo")) continue;
            this.getComponentAt(i).setName(this.language.getString("Untitled"));
            this.registerTitle(this.language.getString("Untitled"));
            this.setTitleAt(i, this.getIndexedTitle(this.language.getString("Untitled")));
            ((JaxoCanvas)this.getComponentAt(i)).setCanvasTick(this.language.getString("Untitled"));
        }
    }
}

