/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoGroup;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class JaxoRescalePanel
extends JPanel {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoGroup theGroup;
    private boolean changed = false;

    public JaxoRescalePanel(JaxoGroup group) {
        this.theGroup = group;
        JPanel prad = new JPanel();
        prad.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelrad = new SpinnerNumberModel(1.0, 0.0, 50.0, 0.05);
        JLabel rad = new JLabel(this.language.getString("Scale") + ": ", 4);
        prad.add(rad);
        JSpinner sprad = new JSpinner(modelrad);
        prad.add(sprad);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 5, 5, 5);
        prad.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(prad, sc);
        dimSPanel.add((Component)prad, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Scale_Factor"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.language.getString("Rescale_Group"), 2, 1, null, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            float newScale = Math.abs(modelrad.getNumber().floatValue());
            this.rescaleGroup(this.theGroup, newScale);
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    private void rescaleGroup(JaxoGroup group, float scl) {
        double[] bbox = group.getBoundingBox();
        int orx = (int)Math.round(bbox[0]);
        int ory = (int)Math.round(bbox[1]);
        this.theGroup.rescaleObject(orx, ory, scl);
    }
}

