/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPopupListener;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JaxoMiscButtons
extends JPanel
implements ActionListener {
    private static final String[] MISC_BUTTON_ICONS = new String[]{"japlot/jaxodraw/icons/box.png", "japlot/jaxodraw/icons/blob.png", "japlot/jaxodraw/icons/vertexT1.png", "japlot/jaxodraw/icons/zigzag.png", "japlot/jaxodraw/icons/font_truetype.png", "japlot/jaxodraw/icons/latex.png"};
    private static final int[] MISC_MODES = new int[]{30, 31, 32, 33, 34, 35};
    private JaxoPopupListener popupListener;
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private int mnbts = 6;
    private JButton[] miscButtons = new JButton[this.mnbts];
    private String[] miscFlagModes = new String[]{this.language.getString("Box"), this.language.getString("Blob"), this.language.getString("Vertex"), this.language.getString("Zigzag"), this.language.getString("Text"), this.language.getString("LaTex")};
    private String[] miscTips = new String[]{this.language.getString("Draw_a_box"), this.language.getString("Draw_a_blob"), this.language.getString("Draw_a_vertex"), this.language.getString("Draw_a_zigzag_line"), this.language.getString("Draw_a_text_string"), this.language.getString("Draw_a_LaTex_text")};
    private Border raisedbevel = BorderFactory.createRaisedBevelBorder();
    private Border loweredbevel = BorderFactory.createLoweredBevelBorder();
    private Border raisedetched = BorderFactory.createEtchedBorder(0);

    public JaxoMiscButtons(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        JPanel miscButtonPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        miscButtonPanel.setLayout(gridbag);
        for (int i = 0; i < this.mnbts; ++i) {
            this.miscButtons[i] = new JButton();
            this.miscButtons[i].setIcon(new ImageIcon(JaxoMiscButtons.class.getClassLoader().getResource(MISC_BUTTON_ICONS[i])));
            this.miscButtons[i].setToolTipText(this.miscTips[i]);
            this.miscButtons[i].addActionListener(this);
            this.miscButtons[i].setMinimumSize(new Dimension(40, 40));
            this.miscButtons[i].setPreferredSize(new Dimension(40, 40));
            this.miscButtons[i].setBorder(this.raisedbevel);
            this.miscButtons[i].setFocusPainted(false);
        }
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 3; ++i) {
                c.gridx = i;
                c.gridy = j;
                gridbag.setConstraints(this.miscButtons[i + 3 * j], c);
                miscButtonPanel.add(this.miscButtons[i + 3 * j]);
            }
        }
        JPanel finalMiscButtonPanel = new JPanel();
        finalMiscButtonPanel.setLayout(new BorderLayout());
        finalMiscButtonPanel.setBorder(this.raisedetched);
        finalMiscButtonPanel.add((Component)miscButtonPanel, "Center");
        this.setLayout(new GridLayout(0, 1));
        this.add(finalMiscButtonPanel);
        this.popupListener = new JaxoPopupListener(this.thePanel, 1);
        this.miscButtons[2].addMouseListener(this.popupListener);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.mnbts; ++i) {
            if (evt.getSource() != this.miscButtons[i]) continue;
            this.thePanel.miscEvent(MISC_MODES[i]);
            this.thePanel.getCanvas().resetNOfClicks();
        }
    }

    public final void reset() {
        for (int i = 0; i < this.mnbts; ++i) {
            this.setButtonBorder(i, this.raisedbevel);
            this.setButtonBackground(i, null);
            this.miscButtons[i].setFocusPainted(false);
        }
    }

    public final JButton getVertexButton() {
        return this.miscButtons[2];
    }

    public final int getIndex(int i) {
        int j = this.mnbts + 1;
        for (int jj = 0; jj < this.mnbts; ++jj) {
            if (i != MISC_MODES[jj]) continue;
            j = jj;
        }
        return j;
    }

    public final void pressButton(int j) {
        this.setButtonBackground(j, new Color(170, 170, 180));
        this.setButtonBorder(j, this.loweredbevel);
        this.miscButtons[j].setFocusPainted(false);
        this.miscButtons[j].setSelected(true);
    }

    public final String getMiscFlagModes(int i) {
        return this.miscFlagModes[i];
    }

    public final int getmnbts() {
        return this.mnbts;
    }

    public final void setButtonBackground(int i, Color bgColor) {
        this.miscButtons[i].setBackground(bgColor);
    }

    public final void setButtonBorder(int i, Border border) {
        this.miscButtons[i].setBorder(border);
    }

    public final void clickButton(int i) {
        this.miscButtons[i].doClick();
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.miscFlagModes[0] = this.language.getString("Box");
        this.miscFlagModes[1] = this.language.getString("Blob");
        this.miscFlagModes[2] = this.language.getString("Vertex");
        this.miscFlagModes[3] = this.language.getString("Zigzag");
        this.miscFlagModes[4] = this.language.getString("Text");
        this.miscFlagModes[5] = this.language.getString("LaTex");
        this.miscTips[0] = this.language.getString("Draw_a_box");
        this.miscTips[1] = this.language.getString("Draw_a_blob");
        this.miscTips[2] = this.language.getString("Draw_a_vertex");
        this.miscTips[3] = this.language.getString("Draw_a_zigzag_line");
        this.miscTips[4] = this.language.getString("Draw_a_text_string");
        this.miscTips[5] = this.language.getString("Draw_a_LaTex_text");
        for (int i = 0; i < this.mnbts; ++i) {
            this.miscButtons[i].setToolTipText(this.miscTips[i]);
        }
        this.popupListener.setLanguage(languageString);
    }

    public final void updatePop(int up) {
        this.popupListener.updatePop(up);
    }
}

