/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.Plot;
import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoGroupOptionsPanel;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoStaticCanvasMethods;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.util.Vector;
import jhplot.jadraw.JaArcObject;
import jhplot.jadraw.JaBlob;
import jhplot.jadraw.JaBox;
import jhplot.jadraw.JaFillObject;
import jhplot.jadraw.JaGlArc;
import jhplot.jadraw.JaGlLine;
import jhplot.jadraw.JaGlLoop;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaLineObject;
import jhplot.jadraw.JaLoopObject;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaPArc;
import jhplot.jadraw.JaPLine;
import jhplot.jadraw.JaPLoop;
import jhplot.jadraw.JaText;
import jhplot.jadraw.JaVertexT2;
import jhplot.jadraw.JaVertexT4;
import jhplot.jadraw.JaVertexT5;
import jhplot.jadraw.JaZigZagLine;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoGroup
extends JaObject {
    private float stroke;
    private int groupAmp;
    private int groupTeXSize;
    private Font groupTextFont;
    private Vector groupObList = new Vector(5, 5);
    private String[] availableFonts;

    public JaxoGroup() {
        this.setRelw(25);
        this.setRelh(25);
        this.setStroke(JaxoPrefs.getFloatPref(200));
        this.setAmp(JaxoPrefs.getIntPref(104));
        this.setTeXSize(JaxoPrefs.getIntPref(107));
        this.setTextFont(new Font(JaxoPrefs.getPref(7), JaxoPrefs.getIntPref(105), JaxoPrefs.getIntPref(106)));
    }

    @Override
    public final JaObject copy() {
        JaxoGroup temp = new JaxoGroup();
        temp.setObList(this.copyObList(this.groupObList));
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setSize(this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        temp.setBoundingBox(this.getBoundingBox());
        temp.setStroke(this.getStroke());
        temp.setAmp(this.getAmp());
        temp.setTeXSize(this.getTeXSize());
        temp.setTextFont(this.getTextFont());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoGroup) {
            JaxoGroup group = (JaxoGroup)comp;
            Vector v1 = this.getObList();
            Vector v2 = group.getObList();
            int length = v1.size();
            if (length == v2.size()) {
                boolean temp = true;
                for (int i = 0; i < length; ++i) {
                    JaObject ob1 = (JaObject)v1.elementAt(i);
                    JaObject ob2 = (JaObject)v2.elementAt(i);
                    temp = temp && ob1.isCopy(ob2);
                }
                isCopy = temp;
            }
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        double[] gbox = this.getBoundingBox();
        int gx = (int)gbox[0];
        int gy = (int)gbox[1];
        int gwidth = (int)Math.round(gbox[2] - gbox[0]);
        int gheight = (int)Math.round(gbox[3] - gbox[1]);
        if (editmode == 50 || editmode == 52) {
            if (clickX >= gx + gwidth && clickX <= gx + gwidth + 8 && clickY >= gy + gheight && clickY <= gy + gheight + 8) {
                return 11;
            }
            if (clickX >= gx - 8 && clickX <= gx && clickY >= gy + gheight && clickY <= gy + gheight + 8) {
                return 11;
            }
            if (clickX >= gx + gwidth && clickX <= gx + gwidth + 8 && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 11;
            }
            if (clickX >= gx - 8 && clickX <= gx && clickY >= gy - 8 && clickY <= gy) {
                return 11;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        double[] gbox = this.getBoundingBox();
        int gx = (int)gbox[0];
        int gy = (int)gbox[1];
        int gwidth = (int)Math.round(gbox[2] - gbox[0]);
        int gheight = (int)Math.round(gbox[3] - gbox[1]);
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.drawRect(gx - 8, gy - 8, 8, 8);
        g2.drawRect(gx - 8, gy + gheight, 8, 8);
        g2.drawRect(gx + gwidth, gy - 8, 8, 8);
        g2.drawRect(gx + gwidth, gy + gheight, 8, 8);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(gx - 8 + 1, gy - 8 + 1, 7, 7);
            g2.fillRect(gx - 8 + 1, gy + gheight + 1, 7, 7);
            g2.fillRect(gx + gwidth + 1, gy - 8 + 1, 7, 7);
            g2.fillRect(gx + gwidth + 1, gy + gheight + 1, 7, 7);
        }
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        JaObject ob;
        int i;
        int length = this.groupObList.size();
        for (i = 0; i < length; ++i) {
            ob = (JaObject)this.groupObList.elementAt(i);
            if (!Plot.drawFirst(ob)) continue;
            ob.jaxoDraw(g2, drawToScreen);
        }
        for (i = 0; i < length; ++i) {
            ob = (JaObject)this.groupObList.elementAt(i);
            Plot.drawRest(ob, g2, drawToScreen);
        }
    }

    @Override
    public final void moveBy(int deltaX, int deltaY) {
        int length = this.groupObList.size();
        super.moveBy(deltaX, deltaY);
        for (int i = 0; i < length; ++i) {
            JaObject ob = (JaObject)this.groupObList.elementAt(i);
            ob.moveBy(deltaX, deltaY);
        }
        double[] bbox = this.getBoundingBox();
        this.setBoundingBox(bbox);
        this.setX((int)Math.round(bbox[0]));
        this.setY((int)Math.round(bbox[1]));
        this.setRelw((int)Math.round(bbox[2] - bbox[0]));
        this.setRelh((int)Math.round(bbox[3] - bbox[1]));
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        String command = "%";
        return command;
    }

    @Override
    public final String latexWidth() {
        String lineWidth = "%";
        return lineWidth;
    }

    @Override
    public final double[] getBoundingBox() {
        double minX = 0.0;
        double maxX = 1.0;
        double minY = 0.0;
        double maxY = 1.0;
        double[] bBox = new double[]{minX, minY, maxX, maxY};
        int length = this.groupObList.size();
        for (int i = 0; i < length; ++i) {
            JaObject ob = (JaObject)this.groupObList.elementAt(i);
            bBox = ob.getBoundingBox();
            if (i == 0) {
                minX = bBox[0];
                minY = bBox[1];
                maxX = bBox[2];
                maxY = bBox[3];
                continue;
            }
            if (bBox[0] < minX) {
                minX = bBox[0];
            }
            if (bBox[1] < minY) {
                minY = bBox[1];
            }
            if (bBox[2] > maxX) {
                maxX = bBox[2];
            }
            if (!(bBox[3] > maxY)) continue;
            maxY = bBox[3];
        }
        bBox[0] = minX;
        bBox[1] = minY;
        bBox[2] = maxX;
        bBox[3] = maxY;
        return bBox;
    }

    public final void clearGroup() {
        this.groupObList.removeAllElements();
    }

    public final Vector getObList() {
        return this.groupObList;
    }

    public final void setObList(Vector obList) {
        this.groupObList = obList;
    }

    public final int groupObListSize() {
        return this.groupObList.size();
    }

    private Vector copyObList(Vector obList) {
        Vector<JaObject> newoblist = new Vector<JaObject>(5, 5);
        for (int i = 0; i < obList.size(); ++i) {
            JaObject ob = (JaObject)obList.elementAt(i);
            JaObject newob = ob.copy();
            newoblist.add(newob);
        }
        return newoblist;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        double[] boundbox = this.getBoundingBox();
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            ob.rescaleObject(orx, ory, scale);
        }
        double[] newbb = new double[]{boundbox[0], boundbox[1], (boundbox[2] - boundbox[0]) * (double)scale + boundbox[0], (boundbox[3] - boundbox[1]) * (double)scale + boundbox[1]};
        this.setBoundingBox(newbb);
        this.setX((int)Math.round(newbb[0]));
        this.setY((int)Math.round(newbb[1]));
        this.setRelw((int)Math.round(newbb[2] - newbb[0]));
        this.setRelh((int)Math.round(newbb[3] - newbb[1]));
    }

    public final float getStroke() {
        return this.stroke;
    }

    public final void setStroke(float newStroke) {
        this.stroke = newStroke;
    }

    public final int getAmp() {
        return this.groupAmp;
    }

    public final void setAmp(int amp) {
        this.groupAmp = amp;
    }

    public final int getTeXSize() {
        return this.groupTeXSize;
    }

    public final void setTeXSize(int teXSize) {
        this.groupTeXSize = teXSize;
    }

    public final Font getTextFont() {
        return this.groupTextFont;
    }

    public final void setTextFont(Font textFont) {
        this.groupTextFont = textFont;
    }

    public final void setGroupColor(Color newColor) {
        this.setColor(newColor);
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaLatexText) continue;
            if (ob instanceof JaxoGroup) {
                ob.setColor(newColor);
                ((JaxoGroup)ob).setGroupColor(newColor);
                continue;
            }
            if (ob instanceof JaBlob || ob instanceof JaBox || ob instanceof JaVertexT5) {
                if (JaxoColor.isGrayScale(((JaFillObject)ob).getFillColor())) continue;
                ob.setColor(newColor);
                continue;
            }
            ob.setColor(newColor);
        }
    }

    public final void setGroupStroke(float newStroke) {
        this.setStroke(newStroke);
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaLineObject) {
                ((JaLineObject)ob).setStroke(newStroke);
                continue;
            }
            if (ob instanceof JaLoopObject) {
                ((JaLoopObject)ob).setStroke(newStroke);
                continue;
            }
            if (ob instanceof JaArcObject) {
                ((JaArcObject)ob).setStroke(newStroke);
                continue;
            }
            if (ob instanceof JaBox) {
                ((JaBox)ob).setStroke(newStroke);
                continue;
            }
            if (ob instanceof JaBlob) {
                ((JaBlob)ob).setStroke(newStroke);
                continue;
            }
            if (ob instanceof JaVertexT2) {
                ((JaVertexT2)ob).setStroke(newStroke);
                continue;
            }
            if (ob instanceof JaVertexT4) {
                ((JaVertexT4)ob).setStroke(newStroke);
                continue;
            }
            if (ob instanceof JaVertexT5) {
                ((JaVertexT5)ob).setStroke(newStroke);
                continue;
            }
            if (!(ob instanceof JaxoGroup)) continue;
            ((JaxoGroup)ob).setGroupStroke(newStroke);
        }
    }

    public final boolean areAmpObject() {
        boolean thereare = false;
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaxoGroup) {
                thereare = ((JaxoGroup)ob).areAmpObject();
                continue;
            }
            if (!(ob instanceof JaGlLine) && !(ob instanceof JaPLine) && !(ob instanceof JaZigZagLine) && !(ob instanceof JaPLoop) && !(ob instanceof JaGlLoop) && !(ob instanceof JaGlArc) && !(ob instanceof JaPArc)) continue;
            thereare = true;
            break;
        }
        return thereare;
    }

    public final void setGroupAmp(int newAmp) {
        this.setAmp(newAmp);
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaLineObject) {
                ((JaLineObject)ob).setAmp(newAmp);
                continue;
            }
            if (ob instanceof JaLoopObject) {
                ((JaLoopObject)ob).setAmp(newAmp);
                continue;
            }
            if (ob instanceof JaArcObject) {
                ((JaArcObject)ob).setAmp(newAmp);
                continue;
            }
            if (!(ob instanceof JaxoGroup)) continue;
            ((JaxoGroup)ob).setGroupAmp(newAmp);
        }
    }

    public final boolean areTeXLabels() {
        boolean thereare = false;
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaxoGroup) {
                thereare = ((JaxoGroup)ob).areTeXLabels();
                if (!thereare) continue;
                break;
            }
            if (!(ob instanceof JaLatexText)) continue;
            thereare = true;
            break;
        }
        return thereare;
    }

    public final boolean arePSLabels() {
        boolean thereare = false;
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaxoGroup) {
                thereare = ((JaxoGroup)ob).arePSLabels();
                if (!thereare) continue;
                break;
            }
            if (!(ob instanceof JaText)) continue;
            thereare = true;
            break;
        }
        return thereare;
    }

    public final void setGroupTeXSize(int newSize) {
        this.setTeXSize(newSize);
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaLatexText) {
                ((JaLatexText)ob).setLatexFS(newSize);
                continue;
            }
            if (!(ob instanceof JaxoGroup)) continue;
            ((JaxoGroup)ob).setGroupTeXSize(newSize);
        }
    }

    public final void setGroupTextFont(Font newFont) {
        this.setTextFont(newFont);
        for (int i = 0; i < this.groupObListSize(); ++i) {
            JaObject ob = (JaObject)this.getObList().elementAt(i);
            if (ob instanceof JaText) {
                ((JaText)ob).setFont(newFont);
                continue;
            }
            if (!(ob instanceof JaxoGroup)) continue;
            ((JaxoGroup)ob).setGroupTextFont(newFont);
        }
    }

    @Override
    public final boolean editPanel() {
        if (this.availableFonts == null) {
            this.availableFonts = JaxoStaticCanvasMethods.getSystemFonts();
        }
        JaxoGroupOptionsPanel groupop = new JaxoGroupOptionsPanel(this, this.availableFonts);
        return groupop.hasChanged();
    }

    public final void setAvailableFonts(String[] fonts) {
        this.availableFonts = fonts;
    }
}

