/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoExportImg;
import japlot.jaxodraw.JaxoExportLatex;
import japlot.jaxodraw.JaxoExportLatexPS;
import japlot.jaxodraw.JaxoExportPS;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class JaxoExportPanel {
    public static final int LATEX_EPS = 0;
    public static final int LATEX = 1;
    public static final int PS_PORTRAIT = 2;
    public static final int PS_LANDSCAPE = 3;
    public static final int PS_EPS = 4;
    public static final int JPG = 5;
    public static final int PNG = 6;
    public static final int SVG = 7;
    private JaxoGraph graph;
    private Dimension canvasD;
    private String currentTab = "";
    private JDialog dialog;
    private JComboBox chooseFileFormat;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));

    public final void setCurrentTab(String newTab) {
        this.currentTab = newTab;
    }

    public final void export(JaxoGraph newGraph, Dimension d) {
        this.graph = newGraph;
        this.canvasD = d;
        Vector<String> fileFormats = new Vector<String>();
        fileFormats.addElement("LaTeX -> EPS");
        fileFormats.addElement("LaTeX");
        fileFormats.addElement("PS Portrait");
        fileFormats.addElement("PS Landscape");
        fileFormats.addElement("EPS");
        fileFormats.addElement("JPG");
        fileFormats.addElement("PNG");
        this.chooseFileFormat = new JComboBox(fileFormats);
        this.chooseFileFormat.setSelectedIndex(0);
        JButton previewButton = new JButton(this.language.getString("Preview"));
        previewButton.setToolTipText(this.language.getString("Open_a_preview_window"));
        previewButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.preview(JaxoExportPanel.this.chooseFileFormat.getSelectedIndex());
            }
        });
        JLabel label = new JLabel(this.language.getString("Please_choose_an_export_file_format:"));
        JPanel prevButtonPanel = new JPanel();
        prevButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        prevButtonPanel.add(previewButton);
        JPanel comboBoxPanel = new JPanel();
        comboBoxPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        comboBoxPanel.add(this.chooseFileFormat);
        JPanel tempPanel = new JPanel(false);
        tempPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tempPanel.add(comboBoxPanel);
        tempPanel.add(prevButtonPanel);
        JButton exportButton = new JButton(this.language.getString("Export"));
        exportButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.exportButtonClicked();
            }
        });
        JButton cancelButton = new JButton(this.language.getString("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.cancelButtonClicked();
            }
        });
        JPanel buttonPanel = new JPanel(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.add(exportButton);
        buttonPanel.add(cancelButton);
        JPanel optionsPanel = new JPanel(false);
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        optionsPanel.setLayout(new BorderLayout());
        optionsPanel.add((Component)label, "North");
        optionsPanel.add((Component)tempPanel, "Center");
        optionsPanel.add((Component)buttonPanel, "South");
        optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "pressed");
        optionsPanel.getActionMap().put("pressed", new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.cancelButtonClicked();
            }
        });
        this.dialog = new JDialog();
        this.dialog.getContentPane().add(optionsPanel);
        this.dialog.setSize(new Dimension(400, 200));
        this.dialog.setTitle(this.language.getString("Export"));
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    private void exportButtonClicked() {
        int ff = this.chooseFileFormat.getSelectedIndex();
        switch (ff) {
            case 1: {
                JaxoExportLatex exp = new JaxoExportLatex();
                exp.setCurrentTab(this.currentTab);
                exp.setMode(1);
                exp.export(this.graph);
                break;
            }
            case 0: {
                JaxoExportLatexPS lps = new JaxoExportLatexPS();
                lps.setCurrentTab(this.currentTab);
                lps.setMode(0);
                lps.export(this.graph);
                break;
            }
            case 2: {
                JaxoExportPS psPortrait = new JaxoExportPS();
                psPortrait.setCurrentTab(this.currentTab);
                psPortrait.setMode(2);
                psPortrait.setCanvasD(this.canvasD);
                psPortrait.export(this.graph);
                break;
            }
            case 3: {
                JaxoExportPS psLandscape = new JaxoExportPS();
                psLandscape.setCurrentTab(this.currentTab);
                psLandscape.setMode(3);
                psLandscape.setCanvasD(this.canvasD);
                psLandscape.export(this.graph);
                break;
            }
            case 4: {
                JaxoExportPS eps = new JaxoExportPS();
                eps.setCurrentTab(this.currentTab);
                eps.setMode(4);
                eps.setCanvasD(this.canvasD);
                eps.export(this.graph);
                break;
            }
            case 5: {
                JaxoExportImg imgJPG = new JaxoExportImg();
                imgJPG.setCurrentTab(this.currentTab);
                imgJPG.setMode(5);
                imgJPG.setCanvasD(this.canvasD);
                imgJPG.export(this.graph);
                break;
            }
            case 6: {
                JaxoExportImg imgPNG = new JaxoExportImg();
                imgPNG.setCurrentTab(this.currentTab);
                imgPNG.setMode(6);
                imgPNG.setCanvasD(this.canvasD);
                imgPNG.export(this.graph);
                break;
            }
        }
        this.dialog.dispose();
    }

    private void cancelButtonClicked() {
        this.dialog.dispose();
    }

    public final void preview(int i) {
        switch (i) {
            case 1: {
                JaxoPreview preLatex = new JaxoPreview();
                preLatex.previewLatex(this.graph);
                break;
            }
            case 0: {
                JaxoPreview preLatexPS = new JaxoPreview();
                preLatexPS.previewLatexPS(this.graph, this.canvasD, false);
                break;
            }
            case 2: {
                JaxoPreview prePortrait = new JaxoPreview();
                prePortrait.previewPS(this.graph, this.canvasD, 2);
                break;
            }
            case 3: {
                JaxoPreview preLandscape = new JaxoPreview();
                preLandscape.previewPS(this.graph, this.canvasD, 3);
                break;
            }
            case 4: {
                JaxoPreview preEPS = new JaxoPreview();
                preEPS.previewEPS(this.graph, this.canvasD);
                break;
            }
            case 5: {
                JaxoPreview preJPG = new JaxoPreview();
                preJPG.previewIMG(this.graph, this.canvasD);
                break;
            }
            case 6: {
                JaxoPreview prePNG = new JaxoPreview();
                prePNG.previewIMG(this.graph, this.canvasD);
                break;
            }
        }
    }
}

