/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.Plot;
import japlot.jaxodraw.JaxoDraw;
import japlot.jaxodraw.JaxoExport;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JOptionPane;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoExportPS
extends JaxoExport
implements Printable {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension canvasD;
    private float transX;
    private float transY;
    private double scale = 1.0;

    public final void setCanvasD(Dimension newD) {
        this.canvasD = newD;
    }

    @Override
    public final void export(JaxoGraph newGraph) {
        this.setGraph(newGraph);
        this.checkforLatexText();
        int mode = this.getMode();
        if (mode == 4) {
            this.exportEPS(newGraph);
        } else {
            this.exportPS(newGraph, mode);
        }
    }

    public final void exportPS(JaxoGraph graph, int mode) {
        block2: {
            this.checkforLatexText();
            String exportPSFileName = this.getExportFileName();
            try {
                this.doExportPS(graph, mode, exportPSFileName);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_export_file_") + exportPSFileName + "!");
                if (!JaxoPrefs.verbose()) break block2;
                System.err.println(ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportPS(JaxoGraph graph, int mode, String exportPSFileName) throws IOException {
        this.checkforLatexText();
        if (exportPSFileName.length() != 0) {
            if (!exportPSFileName.trim().endsWith(".ps")) {
                exportPSFileName = exportPSFileName.trim() + ".ps";
            }
            String tempFileName = ".temp.ps";
            File tempFile = new File(tempFileName);
            tempFile.deleteOnExit();
            this.exportPS(graph, this.canvasD, tempFileName, mode);
            BufferedReader inbr = null;
            BufferedWriter outbr = null;
            try {
                String str;
                inbr = new BufferedReader(new FileReader(tempFileName));
                outbr = new BufferedWriter(new FileWriter(exportPSFileName));
                Calendar rightNow = Calendar.getInstance();
                String firstLine = "%!PS-Adobe-3.0";
                String thirdLine = "%%Creator: " + JaxoDraw.USER_NAME + " with " + "japlot.jaxodraw-1.0";
                String forthLine = "%%Title: " + graph.getDescription();
                String fifthLine = "%%CreationDate: " + rightNow.get(5) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(1);
                boolean isFirstLine = true;
                while ((str = inbr.readLine()) != null) {
                    if (isFirstLine) {
                        outbr.write(firstLine, 0, firstLine.length());
                        outbr.newLine();
                        outbr.write(thirdLine, 0, thirdLine.length());
                        outbr.newLine();
                        outbr.write(forthLine, 0, forthLine.length());
                        outbr.newLine();
                        outbr.write(fifthLine, 0, fifthLine.length());
                        outbr.newLine();
                        isFirstLine = false;
                        continue;
                    }
                    outbr.write(str, 0, str.length());
                    outbr.newLine();
                }
            }
            finally {
                if (inbr != null) {
                    inbr.close();
                }
                if (outbr != null) {
                    outbr.close();
                }
            }
        }
    }

    public final void exportEPS(JaxoGraph newGraph) {
        this.setGraph(newGraph);
        String exportEPSFileName = this.getExportFileName();
        this.exportEPS(newGraph, exportEPSFileName);
    }

    public final void exportEPS(JaxoGraph graph, String exportEPSFileName) {
        block2: {
            try {
                this.doExportEPS(graph, exportEPSFileName);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_export_file_") + exportEPSFileName + "!");
                if (!JaxoPrefs.verbose()) break block2;
                System.err.println(ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportEPS(JaxoGraph graph, String exportEPSFileName) throws IOException {
        if (exportEPSFileName.length() != 0) {
            if (!exportEPSFileName.trim().endsWith(".eps")) {
                exportEPSFileName = exportEPSFileName.trim() + ".eps";
            }
            String tempFileName = ".temp.eps";
            File tempFile = new File(tempFileName);
            tempFile.deleteOnExit();
            this.exportPS(graph, this.canvasD, tempFileName, 4);
            BufferedReader inbr = null;
            BufferedWriter outbr = null;
            try {
                String str;
                inbr = new BufferedReader(new FileReader(tempFileName));
                outbr = new BufferedWriter(new FileWriter(exportEPSFileName));
                double[] bb = this.getBB();
                Calendar rightNow = Calendar.getInstance();
                String firstLine = "%!PS-Adobe-3.0 EPSF-3.0";
                String secondLine = "%%BoundingBox: " + (int)bb[0] + " " + (int)bb[1] + " " + (int)bb[2] + " " + (int)bb[3];
                String thirdLine = "%%Creator: " + JaxoDraw.USER_NAME + " with " + "japlot.jaxodraw-1.0";
                String forthLine = "%%Title: " + graph.getDescription();
                String fifthLine = "%%CreationDate: " + rightNow.get(5) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(1);
                String setpagedevice = "setpagedevice";
                boolean isFirstLine = true;
                while ((str = inbr.readLine()) != null) {
                    if (isFirstLine) {
                        outbr.write(firstLine, 0, firstLine.length());
                        outbr.newLine();
                        outbr.write(secondLine, 0, secondLine.length());
                        outbr.newLine();
                        outbr.write(thirdLine, 0, thirdLine.length());
                        outbr.newLine();
                        outbr.write(forthLine, 0, forthLine.length());
                        outbr.newLine();
                        outbr.write(fifthLine, 0, fifthLine.length());
                        outbr.newLine();
                        isFirstLine = false;
                        continue;
                    }
                    if (str.indexOf(setpagedevice) != -1) {
                        str = str.replaceAll(setpagedevice, "");
                    }
                    outbr.write(str, 0, str.length());
                    outbr.newLine();
                }
            }
            finally {
                if (inbr != null) {
                    inbr.close();
                }
                if (outbr != null) {
                    outbr.close();
                }
            }
        }
    }

    @Override
    public final int print(Graphics g, PageFormat pf, int pageIndex) {
        this.transX = (float)pf.getImageableX();
        this.transY = (float)pf.getImageableY();
        double scaleX = pf.getImageableWidth() / (double)this.canvasD.width;
        double scaleY = pf.getImageableHeight() / (double)this.canvasD.height;
        if (pageIndex == 0) {
            JaObject ob;
            int i;
            VectorGraphics g2 = VectorGraphics.create((Graphics)g);
            this.scale = scaleX;
            if (scaleY < scaleX) {
                this.scale = scaleY;
            }
            if (this.scale > 1.0) {
                this.scale = 1.0;
            }
            g2.translate((double)this.transX, (double)this.transY);
            g2.scale(this.scale, this.scale);
            JaxoGraph graph = this.getGraph();
            int length = graph.listSize();
            for (i = 0; i < length; ++i) {
                ob = graph.listElementAt(i);
                if (!Plot.drawFirst(ob)) continue;
                ob.jaxoDraw(g2, false);
            }
            for (i = 0; i < length; ++i) {
                ob = graph.listElementAt(i);
                Plot.drawRest(ob, g2, false);
            }
            return 0;
        }
        return 1;
    }

    private double[] getBB() {
        double[] bBox = this.getGraph().getBoundingBox();
        double tmp = bBox[1];
        bBox[0] = bBox[0] * this.scale + (double)this.transX - 1.0;
        bBox[1] = 793.0 - (bBox[3] * this.scale + (double)this.transY) - 1.0;
        bBox[2] = bBox[2] * this.scale + (double)this.transX + 1.0;
        bBox[3] = 793.0 - (tmp * this.scale + (double)this.transY) + 1.0;
        return bBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportPS(JaxoGraph newGraph, Dimension d, String fileName, int mode) {
        this.setGraph(newGraph);
        this.canvasD = d;
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, psMimeType);
        if (factories.length == 0) {
            JOptionPane.showMessageDialog(null, this.language.getString("No_suitable_factories_found!"));
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(fileName);
                StreamPrintService sps = factories[0].getPrintService(fos);
                DocPrintJob job = sps.createPrintJob();
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                if (mode == 2) {
                    aset.add(OrientationRequested.PORTRAIT);
                } else if (mode == 3) {
                    aset.add(OrientationRequested.LANDSCAPE);
                } else {
                    aset.add(OrientationRequested.PORTRAIT);
                }
                SimpleDoc doc = new SimpleDoc(this, flavor, null);
                PrintJobWatcher pjDone = new PrintJobWatcher(job);
                job.print(doc, aset);
                pjDone.waitForDone();
            }
            catch (PrintException pe) {
                JOptionPane.showMessageDialog(null, this.language.getString("PrintException:_Cannot_print_file") + fileName + "!");
                if (JaxoPrefs.verbose()) {
                    System.err.println(pe);
                }
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_print_file") + fileName + "!");
                if (JaxoPrefs.verbose()) {
                    System.err.println(ie);
                }
            }
            finally {
                block25: {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ioEx) {
                        if (!JaxoPrefs.verbose()) break block25;
                        System.err.println(ioEx);
                    }
                }
            }
        }
    }

    class PrintJobWatcher {
        private boolean done = false;

        PrintJobWatcher(DocPrintJob job) {
            job.addPrintJobListener(new PrintJobAdapter(){

                @Override
                public final void printJobCanceled(PrintJobEvent pje) {
                    this.allDone();
                }

                @Override
                public final void printJobCompleted(PrintJobEvent pje) {
                    this.allDone();
                }

                @Override
                public final void printJobFailed(PrintJobEvent pje) {
                    this.allDone();
                }

                @Override
                public final void printJobNoMoreEvents(PrintJobEvent pje) {
                    this.allDone();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void allDone() {
                    PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.this.done = true;
                        PrintJobWatcher.this.notifyAll();
                    }
                }
            });
        }

        public final synchronized void waitForDone() {
            block3: {
                try {
                    while (!this.done) {
                        super.wait();
                    }
                }
                catch (InterruptedException e) {
                    JOptionPane.showMessageDialog(null, JaxoExportPS.this.language.getString("InterruptedException_:_Print_job_aborted!"));
                    if (!JaxoPrefs.verbose()) break block3;
                    System.err.println(e);
                }
            }
        }
    }
}

