/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoExport;
import japlot.jaxodraw.JaxoExportLatex;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JaxoExportLatexPS
extends JaxoExport {
    private static ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));

    @Override
    public final void export(JaxoGraph newGraph) {
        int status;
        this.setGraph(newGraph);
        this.checkforPSText();
        String exportFileName = this.getExportFileName();
        if (exportFileName.length() != 0 && (status = this.exportLatexPS(newGraph, exportFileName)) != 0) {
            System.err.println("Status in JaxoExportLatexPS: " + status);
        }
    }

    public final int exportLatexPS(JaxoGraph graph, String fileName) {
        int dviStatus;
        int texStatus;
        int status;
        block6: {
            if (!fileName.trim().endsWith(".eps")) {
                fileName = fileName.trim() + ".eps";
            }
            status = 0;
            String baseName = "Jaxo_tmp";
            String latexFileName = baseName + ".tex";
            String dviFileName = baseName + ".dvi";
            String logFileName = baseName + ".log";
            String auxFileName = baseName + ".aux";
            File latexFile = new File(latexFileName);
            latexFile.deleteOnExit();
            File dviFile = new File(dviFileName);
            dviFile.deleteOnExit();
            File logFile = new File(logFileName);
            logFile.deleteOnExit();
            File auxFile = new File(auxFileName);
            auxFile.deleteOnExit();
            JaxoExportLatex lat = new JaxoExportLatex();
            lat.exportLatex(graph, latexFileName);
            String latexExe = JaxoPrefs.getStringPref(9);
            String dvipsExe = JaxoPrefs.getStringPref(10);
            String latexCommand = latexExe + " --interaction scrollmode " + latexFileName;
            String dvipsCommand = dvipsExe + " -E -o " + fileName + " " + dviFileName;
            texStatus = 0;
            dviStatus = 0;
            try {
                texStatus = JaxoExportLatexPS.executeCommand(latexCommand, true);
                if (texStatus == 0) {
                    dviStatus = JaxoExportLatexPS.executeCommand(dvipsCommand, false);
                }
            }
            catch (IOException anIOException) {
                JOptionPane.showMessageDialog(null, language.getString("IOException:_Cannot_execute_command!") + language.getString("Please_try_'Export_LaTeX'_and_run_latex_manually."));
                if (JaxoPrefs.verbose()) {
                    System.err.println(anIOException);
                }
            }
            catch (InterruptedException intexc) {
                JOptionPane.showMessageDialog(null, language.getString("InterruptedException:_Cannot_execute_command!") + language.getString("Please_try_'Export_LaTeX'_and_run_latex_manually."));
                if (!JaxoPrefs.verbose()) break block6;
                System.err.println(intexc);
            }
        }
        status = texStatus + dviStatus;
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeCommand(String command, boolean follow) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command);
        int exit = 0;
        if (follow) {
            JTextArea area = new JTextArea(80, 40);
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
            JScrollPane areaScrollPane = new JScrollPane(area);
            areaScrollPane.setVerticalScrollBarPolicy(22);
            areaScrollPane.setPreferredSize(new Dimension(500, 300));
            areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(language.getString("LaTeX_output")), BorderFactory.createEmptyBorder(5, 5, 5, 5)), areaScrollPane.getBorder()));
            JFrame frame = new JFrame();
            frame.getContentPane().add((Component)areaScrollPane, "Center");
            frame.setDefaultCloseOperation(2);
            frame.setTitle(command);
            frame.pack();
            frame.setVisible(true);
            try (BufferedReader lsIn = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String lsStr;
                while ((lsStr = lsIn.readLine()) != null) {
                    area.append(lsStr + "\n");
                }
            }
            if ((exit = process.waitFor()) != 0) {
                JOptionPane.showMessageDialog(null, language.getString("Error:_Execution_of_LaTeX_failed!") + language.getString("Please_check_the_output_window_for_further_information."));
                process.destroy();
            } else {
                frame.dispose();
            }
        } else {
            exit = process.waitFor();
            if (exit != 0) {
                JOptionPane.showMessageDialog(null, language.getString("Error:_Execution_of_dvips_failed!"));
                process.destroy();
            }
        }
        return exit;
    }
}

