/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.Plot;
import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoExport;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoExportImg
extends JaxoExport {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension canvasD;
    private String format;

    public final void setCanvasD(Dimension newD) {
        this.canvasD = newD;
    }

    @Override
    public final void export(JaxoGraph newGraph) {
        this.setGraph(newGraph);
        this.format = this.getMode() == 5 ? "jpg" : "png";
        this.checkforLatexText();
        String exportFileName = this.getExportFileName();
        if (exportFileName.length() != 0) {
            this.exportImg(exportFileName);
        }
    }

    private void exportImg(String exportFileName) {
        block2: {
            RenderedImage rendImage = this.createImage();
            try {
                File file = new File(exportFileName);
                ImageIO.write(rendImage, this.format, file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, this.language.getString("IOException:_Cannot_export_file_") + exportFileName + "!");
                if (!JaxoPrefs.verbose()) break block2;
                System.err.println(e);
            }
        }
    }

    private RenderedImage createImage() {
        JaObject ob;
        int i;
        int width = this.canvasD.width;
        int height = this.canvasD.height;
        BufferedImage bufferedImage = this.format.equals("png") ? this.getARGBImage(width, height) : this.getRGBImage(width, height);
        VectorGraphics g2d = (VectorGraphics)bufferedImage.createGraphics();
        if (this.format.equals("png")) {
            Color transparent = new Color(0, 0, 0, 0);
            g2d.setColor(transparent);
            g2d.setComposite((Composite)AlphaComposite.Src);
        } else {
            g2d.setColor(JaxoCanvas.BCKG_COLOR);
        }
        g2d.fillRect(0, 0, width, height);
        JaxoGraph graph = this.getGraph();
        int length = graph.listSize();
        for (i = 0; i < length; ++i) {
            ob = graph.listElementAt(i);
            if (!Plot.drawFirst(ob)) continue;
            ob.jaxoDraw(g2d, false);
        }
        for (i = 0; i < length; ++i) {
            ob = graph.listElementAt(i);
            Plot.drawRest(ob, g2d, false);
        }
        g2d.dispose();
        double[] bb = graph.getBoundingBox();
        int x = (int)Math.round(bb[0]);
        int y = (int)Math.round(bb[1]);
        int w = (int)Math.round(bb[2] - bb[0]) + 1;
        int h = (int)Math.round(bb[3] - bb[1]) + 1;
        return bufferedImage.getSubimage(x, y, w, h);
    }

    private BufferedImage getRGBImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    private BufferedImage getARGBImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }
}

