/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoChooseFile;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoPrefs;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public abstract class JaxoExport {
    private static final String[] SUFFICES = new String[]{"eps", "tex", "ps", "ps", "eps", "jpg", "png", "svg"};
    private static final String[] DESCRIPTION = new String[]{"Encapsulated_Postscript_file_(*.eps)", "LaTex_file_(*.tex)", "Postscript_file_(*.ps)", "Postscript_file_(*.ps)", "Encapsulated_Postscript_file_(*.eps)", "JPG_Image_file_(*.jpg)", "PNG_Image_file_(*.png)", "Scalable_Vector_Graphics_file_(*.svg)"};
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoGraph graph;
    private String currentTab = "";
    private int mode;
    public static String ExportFile = null;

    public final void setCurrentTab(String newTab) {
        this.currentTab = newTab;
    }

    public void setExportFile(String exportFile) {
        ExportFile = exportFile;
    }

    public String getExportFile() {
        return ExportFile;
    }

    public final void setMode(int newMode) {
        this.mode = newMode;
    }

    public final int getMode() {
        return this.mode;
    }

    public final void setGraph(JaxoGraph newGraph) {
        this.graph = newGraph;
    }

    public final JaxoGraph getGraph() {
        return this.graph;
    }

    public final String getExportFileName() {
        if (ExportFile != null) {
            return ExportFile;
        }
        String suffix = SUFFICES[this.mode];
        String describe = this.language.getString(DESCRIPTION[this.mode]);
        JaxoChooseFile c = new JaxoChooseFile();
        String[] suff = new String[]{suffix};
        String exportFileName = c.chooseFile(suff, this.language.getString("Export"), describe, this.currentTab);
        if (exportFileName.trim().length() > 0) {
            File testfile;
            if (!exportFileName.trim().endsWith("." + suffix)) {
                exportFileName = exportFileName.trim() + "." + suffix;
            }
            if ((testfile = new File(exportFileName)).exists()) {
                String s1 = this.language.getString("Overwrite");
                String s2 = this.language.getString("Cancel");
                Object[] options = new Object[]{s1, s2};
                int n = JOptionPane.showOptionDialog(null, exportFileName + " " + this.language.getString("_exists!_Overwrite?"), this.language.getString("Overwrite_Confirmation"), 0, 3, null, options, s1);
                if (n != 0) {
                    exportFileName = "";
                }
            }
        } else {
            exportFileName = "";
        }
        return exportFileName;
    }

    public final void checkforLatexText() {
        if (this.graph.containsLatexText()) {
            Object[] message = new Object[]{this.language.getString("There_are_LaTeX_text_objects_in_this_graph."), this.language.getString("They_will_not_be_exported_to_this_format!")};
            JOptionPane.showMessageDialog(null, message, this.language.getString("Warning"), 2);
        }
    }

    public final void checkforPSText() {
        if (this.graph.containsPSText()) {
            Object[] message = new Object[]{this.language.getString("There_are_Postscript_text_objects_in_this_graph."), this.language.getString("They_will_not_be_exported_to_LaTeX!")};
            JOptionPane.showMessageDialog(null, message, this.language.getString("Warning"), 2);
        }
    }

    public abstract void export(JaxoGraph var1);
}

