/*
 * Decompiled with CFR 0.152.
 */
package japlot;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jhplot.jadraw.JaAxes;
import jhplot.utils.GHFontChooser;
import jplot3d.JColor;
import jplot3d.Utils;

public class JaAxesOptionsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private final int X;
    private final int Y;
    private final int NAXES;
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private JaAxes theBox;
    private String sBox;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private ImageIcon colorFillPreviewIcon;
    private JButton colorbt;
    private JButton colorFillbt;
    private JPanel colorPanel;
    private JPanel colorFillPanel;
    private TitledBorder colorPanelTitle;
    private TitledBorder colorFillPanelTitle;
    private Color newColor;
    private Color newFillColor;
    private Image colorPreview;
    private Image colorFillPreview;
    private int newXfin;
    private int newYfin;
    private int newWidth;
    private int newHeight;
    private int newRelWidth;
    private int newRelHeight;
    private int newXin;
    private int newYin;
    private float newStroke;
    private boolean changed = false;
    private JTabbedPane jtpMain;
    private JPanel jglobal;
    private JColor gridColor;
    private JCheckBox[] axesRange;
    private JSpinner[] spnAxesMin;
    private JSpinner[] spnAxesMax;
    private JColor axesColor;
    private final Font fdefo = new Font("SansSerif", 1, 14);
    private JCheckBox[] chkDisplay;
    private JCheckBox[] chkDisplayMirror;
    private JCheckBox[] chkDisplayGrid;
    private JCheckBox[] chkAuto;
    private JButton btnFontsAxes;
    private JSpinner[] spnLabelOffset;
    private JSpinner[] spnTickSize;
    private JSpinner[] spnTicks;
    private JSpinner[] spnSubTicks;
    private JSpinner[] spnSubTickSize;
    private SpinnerNumberModel modelXin;
    private SpinnerNumberModel modelXfin;
    private SpinnerNumberModel modelYfin;
    private SpinnerNumberModel modelYin;
    private SpinnerNumberModel modelstin;

    public JaAxesOptionsPanel(JaAxes box) {
        this.theBox = box;
        this.X = 0;
        this.Y = 1;
        this.NAXES = 2;
        this.sBox = this.language.getString("Axes_parameters");
        this.theIcon = new ImageIcon(JaAxesOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/box.png"));
        this.newColor = this.theBox.getColor();
        this.newFillColor = this.theBox.getFillColor();
        this.colorPreview = this.getChooserImage(this.newColor);
        this.colorFillPreview = this.getChooserImage(this.newFillColor);
        this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        this.colorFillPreviewIcon = new ImageIcon(this.colorFillPreview);
        this.newWidth = this.theBox.getSize().width;
        this.newHeight = this.theBox.getSize().height;
        this.newRelWidth = this.theBox.getRelSize().width;
        this.newRelHeight = this.theBox.getRelSize().height;
        this.getXYCoord(this.theBox.getX(), this.theBox.getY(), this.newRelWidth, this.newRelHeight);
        this.newStroke = this.theBox.getStroke();
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        this.jtpMain = new JTabbedPane();
        this.jglobal = new JPanel();
        this.jtpMain.add("Global", this.jglobal);
        this.jtpMain.add("Axes", this.createAxisPane());
        this.jtpMain.add("Ranges", this.createAxisRange());
        this.jtpMain.setSelectedIndex(0);
        this.modelXin = new SpinnerNumberModel(this.newXin, 0, this.d.width, 1);
        JLabel xin = new JLabel("Xmin: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(this.modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        this.modelYin = new SpinnerNumberModel(this.newYin, 0, this.d.height, 1);
        JLabel yin = new JLabel("Ymin: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(this.modelYin);
        pyin.add(spyin);
        JPanel pxfin = new JPanel();
        pxfin.setLayout(new GridLayout(0, 2));
        this.modelXfin = new SpinnerNumberModel(this.newXfin, 0, this.d.width, 1);
        JLabel xfin = new JLabel("Xmax: ", 4);
        pxfin.add(xfin);
        JSpinner spxfin = new JSpinner(this.modelXfin);
        pxfin.add(spxfin);
        JPanel pyfin = new JPanel();
        pyfin.setLayout(new GridLayout(0, 2));
        this.modelYfin = new SpinnerNumberModel(this.newYfin, 0, this.d.height, 1);
        JLabel yfin = new JLabel("Ymax: ", 4);
        pyfin.add(yfin);
        JSpinner spyfin = new JSpinner(this.modelYfin);
        pyfin.add(spyfin);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 0, 5);
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 5);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 5, 0, 5);
        pxfin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxfin, sc);
        dimSPanel.add((Component)pxfin, sc);
        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(5, 5, 5, 5);
        pyfin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyfin, sc);
        dimSPanel.add((Component)pyfin, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Position/Size"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel pstin = new JPanel();
        GridBagLayout subgb = new GridBagLayout();
        GridBagConstraints subc = new GridBagConstraints();
        pstin.setLayout(subgb);
        this.modelstin = new SpinnerNumberModel(this.newStroke, 0.0, 100.0, 0.2);
        JLabel stin = new JLabel(this.language.getString("Line_Width"), 4);
        JSpinner spstin = new JSpinner(this.modelstin);
        subc.gridx = 0;
        subc.gridy = 0;
        subc.insets = new Insets(0, 5, 5, 5);
        subgb.setConstraints(stin, subc);
        pstin.add((Component)stin, subc);
        subc.gridx = 1;
        subc.gridy = 0;
        spstin.setPreferredSize(new Dimension(50, 20));
        subgb.setConstraints(spstin, subc);
        pstin.add((Component)spstin, subc);
        JPanel strSPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        GridBagConstraints sc1 = new GridBagConstraints();
        strSPanel.setLayout(gb1);
        sc1.gridx = 0;
        sc1.gridy = 0;
        gb1.setConstraints(pstin, sc1);
        strSPanel.add((Component)pstin, sc1);
        JPanel finalStrSPanel = new JPanel();
        finalStrSPanel.setLayout(new BoxLayout(finalStrSPanel, 0));
        TitledBorder strSTitle = BorderFactory.createTitledBorder(this.language.getString("Width"));
        finalStrSPanel.setBorder(strSTitle);
        finalStrSPanel.add(strSPanel);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Line_color"));
        this.colorPanel.add(this.colorbt);
        if (JaxoColor.isGrayScale(this.newFillColor)) {
            this.colorPanelTitle.setTitleColor(JaxoColor.GRAYSCALE165);
            this.colorbt.setEnabled(false);
        }
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorFillbt = new JButton(this.colorFillPreviewIcon);
        this.colorFillbt.addActionListener(this);
        this.colorFillPanel = new JPanel();
        this.colorFillPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Fill_color"));
        this.colorFillPanel.setBorder(this.colorFillPanelTitle);
        this.colorFillPanel.add(this.colorFillbt);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.jglobal.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.jglobal.add((Component)finalDimSPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 5);
        gridbag.setConstraints(finalStrSPanel, c);
        this.jglobal.add((Component)finalStrSPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 0);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.jglobal.add((Component)this.colorPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 0, 0);
        this.colorFillPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorFillPanel, c);
        this.jglobal.add((Component)this.colorFillPanel, c);
        this.add(this.jtpMain);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.sBox, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            this.setAxesParameters();
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        JaxoColorChooser colorChooser;
        if (evt.getSource() == this.colorbt) {
            colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        }
        if (evt.getSource() == this.colorFillbt) {
            colorChooser = new JaxoColorChooser();
            this.newFillColor = colorChooser.color(this.newFillColor, true);
            if (this.newFillColor != null) {
                this.colorFillPreviewIcon = new ImageIcon(this.getChooserImage(this.newFillColor));
                this.colorFillbt.setIcon(this.colorFillPreviewIcon);
                this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Line_color"));
                this.colorbt.setEnabled(true);
                if (JaxoColor.isGrayScale(this.newFillColor)) {
                    this.colorPanelTitle.setTitleColor(JaxoColor.GRAYSCALE165);
                    this.colorbt.setEnabled(false);
                }
                this.colorPanel.setBorder(this.colorPanelTitle);
            }
        }
    }

    private void getXYCoord(int x, int y, int relw, int relh) {
        if (relw > 0 && relh >= 0 || relw < 0 && relh <= 0) {
            this.newXin = x;
            this.newYin = y;
            this.newXfin = x + Math.abs(relw);
            this.newYfin = y + Math.abs(relh);
        }
        if (relw >= 0 && relh < 0 || relw <= 0 && relh > 0) {
            this.newXin = x;
            this.newYin = y + Math.abs(relh);
            this.newXfin = x + Math.abs(relw);
            this.newYfin = y;
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    private void setNewBox(int xin, int yin, int xfin, int yfin) {
        this.newWidth = Math.abs(xfin - xin);
        this.newHeight = Math.abs(yfin - yin);
        this.newRelWidth = xfin - xin;
        this.newRelHeight = yfin - yin;
        if (this.newRelWidth > 0 && this.newRelHeight >= 0) {
            this.newXin = xin;
            this.newYin = yin;
        }
        if (this.newRelWidth < 0 && this.newRelHeight <= 0) {
            this.newXin = xfin;
            this.newYin = yfin;
        }
        if (this.newRelWidth >= 0 && this.newRelHeight < 0) {
            this.newXin = xin;
            this.newYin = yin + this.newRelHeight;
        }
        if (this.newRelWidth <= 0 && this.newRelHeight > 0) {
            this.newXin = xin + this.newRelWidth;
            this.newYin = yin;
        }
    }

    private Container createAxisPane() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.add(this.createAxisControls());
        return jpanel;
    }

    private Container createAxisControls() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        this.axesColor = new JColor(50, 20);
        jpanel.add((Component)Utils.labeledComponent("Axis color:", this.axesColor, true), gridbagconstraints);
        this.axesColor.setColor(this.theBox.getColor());
        this.gridColor = new JColor(50, 20);
        jpanel.add((Component)Utils.labeledComponent("Grid color:", this.gridColor, true), gridbagconstraints);
        this.gridColor.setColor(this.theBox.getGridColor());
        this.btnFontsAxes = new JButton("Axis Font");
        jpanel.add((Component)this.btnFontsAxes, gridbagconstraints);
        this.btnFontsAxes.setFont(this.theBox.getLabelFont());
        this.chkDisplay = new JCheckBox[this.NAXES];
        this.chkDisplay[this.X] = new JCheckBox("Display X");
        this.chkDisplay[this.Y] = new JCheckBox("Display Y");
        this.chkDisplayMirror = new JCheckBox[this.NAXES];
        this.chkDisplayMirror[this.X] = new JCheckBox("X mirror");
        this.chkDisplayMirror[this.Y] = new JCheckBox("Y mirror");
        this.chkDisplayGrid = new JCheckBox[this.NAXES];
        this.chkDisplayGrid[this.X] = new JCheckBox("X grid");
        this.chkDisplayGrid[this.Y] = new JCheckBox("Y grid");
        this.spnTicks = new JSpinner[this.NAXES];
        this.spnSubTicks = new JSpinner[this.NAXES];
        this.spnSubTickSize = new JSpinner[this.NAXES];
        this.spnTickSize = new JSpinner[this.NAXES];
        this.spnLabelOffset = new JSpinner[this.NAXES];
        gridbagconstraints.gridy = 1;
        jpanel.add((Component)this.chkDisplay[this.X], gridbagconstraints);
        jpanel.add((Component)this.chkDisplayMirror[this.X], gridbagconstraints);
        gridbagconstraints.gridy = 2;
        jpanel.add((Component)this.chkDisplay[this.Y], gridbagconstraints);
        jpanel.add((Component)this.chkDisplayMirror[this.Y], gridbagconstraints);
        gridbagconstraints.gridy = 3;
        jpanel.add((Component)this.chkDisplayGrid[this.X], gridbagconstraints);
        jpanel.add((Component)this.chkDisplayGrid[this.Y], gridbagconstraints);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 0;
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        this.spnTicks[this.X] = new JSpinner(new SpinnerNumberModel(5, 3, 20, 1));
        p1.add(Utils.labeledComponent("X Ticks:", this.spnTicks[this.X], true));
        this.spnTicks[this.Y] = new JSpinner(new SpinnerNumberModel(5, 3, 20, 1));
        p1.add(Utils.labeledComponent("Y Ticks:", this.spnTicks[this.Y], true));
        this.spnSubTicks[this.X] = new JSpinner(new SpinnerNumberModel(5, 2, 20, 1));
        p1.add(Utils.labeledComponent("X SubTicks:", this.spnSubTicks[this.X], true));
        this.spnSubTicks[this.Y] = new JSpinner(new SpinnerNumberModel(5, 2, 20, 1));
        p1.add(Utils.labeledComponent("Y SubTicks", this.spnSubTicks[this.Y], true));
        this.spnTickSize[this.X] = new JSpinner(new SpinnerNumberModel(0.01, 0.0, 0.999, 0.005));
        p2.add(Utils.labeledComponent("X TickSize:", this.spnTickSize[this.X], true));
        this.spnTickSize[this.Y] = new JSpinner(new SpinnerNumberModel(0.01, 0.0, 0.995, 0.005));
        p2.add(Utils.labeledComponent("Y TickSize:", this.spnTickSize[this.Y], true));
        this.spnSubTickSize[this.X] = new JSpinner(new SpinnerNumberModel(0.01, 0.0, 0.995, 0.005));
        p2.add(Utils.labeledComponent("X SubTickSize:", this.spnSubTickSize[this.X], true));
        this.spnSubTickSize[this.Y] = new JSpinner(new SpinnerNumberModel(0.01, 0.0, 0.995, 0.005));
        p2.add(Utils.labeledComponent("Y SubTickSize:", this.spnSubTickSize[this.Y], true));
        this.spnLabelOffset[this.X] = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 0.995, 0.005));
        p3.add(Utils.labeledComponent("X Offset:", this.spnLabelOffset[this.X], true));
        this.spnLabelOffset[this.Y] = new JSpinner(new SpinnerNumberModel(0.01, 0.0, 0.995, 0.005));
        p3.add(Utils.labeledComponent("Y Offset:", this.spnLabelOffset[this.Y], true));
        gridbagconstraints.gridy = 4;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)p1, gridbagconstraints);
        gridbagconstraints.gridy = 5;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)p2, gridbagconstraints);
        gridbagconstraints.gridy = 6;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)p3, gridbagconstraints);
        for (int i = 0; i < this.NAXES; ++i) {
            this.spnTicks[i].setFont(this.fdefo);
            this.spnSubTicks[i].setFont(this.fdefo);
            this.spnSubTickSize[i].setFont(this.fdefo);
            this.spnTickSize[i].setFont(this.fdefo);
            this.spnLabelOffset[i].setFont(this.fdefo);
            this.spnTicks[i].setValue(new Integer(this.theBox.getTicksNumber(i)));
            this.spnSubTicks[i].setValue(new Integer(this.theBox.getSubTicksNumber(i)));
            this.spnSubTickSize[i].setValue(new Double(this.theBox.getSubTicksSize(i)));
            this.spnTickSize[i].setValue(new Double(this.theBox.getTicksSize(i)));
            this.spnLabelOffset[i].setValue(new Double(this.theBox.getLabelSpace(i)));
            this.chkDisplay[i].setSelected(this.theBox.isShow(i));
            this.chkDisplayMirror[i].setSelected(this.theBox.isShowMirror(i));
            this.chkDisplayGrid[i].setSelected(this.theBox.isShowGrid(i));
        }
        this.btnFontsAxes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                JaAxesOptionsPanel.this.selectFontsAxes();
            }
        });
        jpanel.setBorder(BorderFactory.createTitledBorder("Axis Settings"));
        return jpanel;
    }

    protected void selectFontsAxes() {
        GHFontChooser dlg = new GHFontChooser(this, "Axes fonts");
        SimpleAttributeSet aset = new SimpleAttributeSet();
        Font f = this.theBox.getLabelFont();
        Color fgColor = this.theBox.getLabelColor();
        Color bkColor = this.theBox.getFillColor();
        StyleConstants.setFontFamily(aset, f.getName());
        StyleConstants.setFontSize(aset, f.getSize());
        int style = f.getStyle();
        StyleConstants.setItalic(aset, false);
        StyleConstants.setBold(aset, false);
        if (style == 1) {
            StyleConstants.setBold(aset, true);
        }
        if (style == 2) {
            StyleConstants.setItalic(aset, true);
        }
        StyleConstants.setBackground(aset, bkColor);
        StyleConstants.setForeground(aset, fgColor);
        dlg.setAttributes(aset);
        dlg.setVisible(true);
        aset = (SimpleAttributeSet)dlg.getAttributes();
        String newName = StyleConstants.getFontFamily(aset);
        int newSize = StyleConstants.getFontSize(aset);
        style = 0;
        if (StyleConstants.isBold(aset)) {
            style = 1;
        }
        if (StyleConstants.isItalic(aset)) {
            style = 2;
        }
        Color newc = StyleConstants.getForeground(aset);
        Color newcb = StyleConstants.getBackground(aset);
        Font ff = new Font(newName, style, newSize);
        this.theBox.setLabelColor(newc);
        this.theBox.setFillColor(newcb);
        this.theBox.setLabelFont(ff);
    }

    private Container createAxisRange() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        this.chkAuto = new JCheckBox[this.NAXES];
        this.chkAuto[this.X] = new JCheckBox("autoRange X");
        this.chkAuto[this.Y] = new JCheckBox("autoRange Y");
        gridbagconstraints.gridy = 1;
        this.chkAuto[this.X] = new JCheckBox("Auto Range X");
        jpanel.add((Component)this.chkAuto[this.X], gridbagconstraints);
        this.chkAuto[this.Y] = new JCheckBox("Auto Range Y");
        jpanel.add((Component)this.chkAuto[this.Y], gridbagconstraints);
        this.chkAuto[this.X].setSelected(this.theBox.isAutoRange(this.X));
        this.chkAuto[this.Y].setSelected(this.theBox.isAutoRange(this.Y));
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)this.createAxisExtents(), gridbagconstraints);
        jpanel.setBorder(BorderFactory.createTitledBorder("Axis Ranges"));
        return jpanel;
    }

    private Container createAxisExtents() {
        Box box = new Box(1);
        String[] as = new String[]{"Log X", "Log Y"};
        this.spnAxesMin = new JSpinner[this.NAXES];
        this.spnAxesMax = new JSpinner[this.NAXES];
        this.axesRange = new JCheckBox[this.NAXES];
        for (int i = 0; i < this.NAXES; ++i) {
            Box box1 = new Box(0);
            box1.add(new JLabel(as[i]));
            this.axesRange[i] = new JCheckBox();
            box1.add(this.axesRange[i]);
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMin[i] = new JSpinner(new SpinnerNumberModel(0.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Min:", this.spnAxesMin[i], true));
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMax[i] = new JSpinner(new SpinnerNumberModel(1.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Max:", this.spnAxesMax[i], true));
            this.spnAxesMin[i].setFont(this.fdefo);
            this.spnAxesMax[i].setFont(this.fdefo);
            this.spnAxesMin[i].setValue(new Double(this.theBox.getMin(i)));
            this.spnAxesMax[i].setValue(new Double(this.theBox.getMax(i)));
            this.axesRange[i].setSelected(this.theBox.isLogScale(i));
            box1.setAlignmentX(1.0f);
            box.add(box1);
        }
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        return box;
    }

    private void setAxesParameters() {
        if (this.newColor != null && this.newFillColor != null) {
            if (JaxoColor.isGrayScale(this.newFillColor)) {
                this.newColor = JaxoColor.BLACK;
            }
            this.theBox.setColor(this.newColor);
            this.theBox.setFillColor(this.newFillColor);
            this.newXin = this.modelXin.getNumber().intValue();
            this.newYin = this.modelYin.getNumber().intValue();
            this.newXfin = this.modelXfin.getNumber().intValue();
            this.newYfin = this.modelYfin.getNumber().intValue();
            this.newStroke = Math.abs(this.modelstin.getNumber().floatValue());
            this.theBox.setStroke(this.newStroke);
            this.setNewBox(this.newXin, this.newYin, this.newXfin, this.newYfin);
            this.theBox.setX(this.newXin);
            this.theBox.setY(this.newYin);
            if (this.newRelWidth >= 0 && this.newRelHeight >= 0 || this.newRelWidth < 0 && this.newRelHeight < 0) {
                this.theBox.setRelWAndH(this.newWidth, this.newHeight);
            } else if (this.newRelWidth >= 0 && this.newRelHeight < 0 || this.newRelWidth < 0 && this.newRelHeight >= 0) {
                this.theBox.setRelWAndH(this.newWidth, -this.newHeight);
            }
            this.theBox.setGridColor(this.gridColor.getColor());
            this.theBox.setColor(this.axesColor.getColor());
            for (int i = 0; i < this.NAXES; ++i) {
                this.theBox.setShow(i, this.chkDisplay[i].isSelected());
                this.theBox.setShowMirror(i, this.chkDisplayMirror[i].isSelected());
                this.theBox.setShowGrid(i, this.chkDisplayGrid[i].isSelected());
                this.theBox.setAutoRange(i, this.chkAuto[i].isSelected());
                double d = (Double)this.spnSubTickSize[i].getValue();
                this.theBox.setSubTicksSize(i, d);
                d = (Double)this.spnTickSize[i].getValue();
                this.theBox.setTicksSize(i, d);
                d = (Double)this.spnLabelOffset[i].getValue();
                this.theBox.setLabelSpace(i, d);
                d = (Double)this.spnAxesMin[i].getValue();
                this.theBox.setMin(i, d);
                d = (Double)this.spnAxesMax[i].getValue();
                this.theBox.setMax(i, d);
                this.theBox.setShowMirror(i, this.chkDisplayMirror[i].isSelected());
                int ii = (Integer)this.spnTicks[i].getValue();
                this.theBox.setTicksNumber(i, ii);
                ii = (Integer)this.spnSubTicks[i].getValue();
                this.theBox.setSubTicksNumber(i, ii);
                this.theBox.setLogScale(i, this.axesRange[i].isSelected());
            }
            this.changed = true;
        }
    }
}

