/*
 * Decompiled with CFR 0.152.
 */
package japlot;

import japlot.ComboBoxRenderer;
import japlot.KeyIcon;
import japlot.jaxodraw.JaxoMainPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaAxes;
import jplot.DataArray;
import jplot3d.JColor;
import jplot3d.Utils;

public class DataPanel
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private JaxoMainPanel frame;
    private DataArray da;
    private JComboBox symbolList;
    private JComboBox symbolSize;
    private JColor color;
    private JColor colorErrX;
    private JColor colorErrY;
    private JColor colorErrSysX;
    private JColor colorErrSysY;
    private JCheckBox chkFillError;
    private JCheckBox chkFillErrorSys;
    private JColor colorFillError;
    private JColor colorFillErrorSys;
    private JCheckBox[] chkErr;
    private JCheckBox[] chkErrSys;
    private JSpinner spnLineWidth;
    private JSpinner spnLineWidthErr;
    private JSpinner spnLineWidthErrSys;
    private JSpinner spnLineWidthTick;
    private JTextField jtname;
    private Icon[] images;
    private String[] images_text;
    private String[] intSizes;
    private final int MaxSymbols = 16;
    private final int MaxSizes = 20;
    private JPanel jglobal;
    private JPanel jerror;
    private JPanel jerrorSys;
    private final Font fdefo = new Font("SansSerif", 1, 14);

    public DataPanel(JaAxes ja, JaxoMainPanel frame) {
        int i;
        this.frame = frame;
        this.images_text = new String[16];
        this.intSizes = new String[20];
        this.images = new Icon[16];
        Integer[] intArray = new Integer[16];
        for (i = 0; i < 13; ++i) {
            intArray[i] = new Integer(i);
            this.images_text[i] = Integer.toString(i);
            this.images[i] = new KeyIcon(Color.black, false, i, 7);
        }
        i = 13;
        intArray[i] = new Integer(i);
        this.images_text[i] = Integer.toString(20);
        this.images[i] = new KeyIcon(Color.black, false, 20, 7);
        i = 14;
        intArray[i] = new Integer(i);
        this.images_text[i] = Integer.toString(21);
        this.images[i] = new KeyIcon(Color.black, false, 21, 7);
        i = 15;
        intArray[i] = new Integer(i);
        this.images_text[i] = Integer.toString(22);
        this.images[i] = new KeyIcon(Color.blue, false, 22, 7);
        for (i = 0; i < 20; ++i) {
            this.intSizes[i] = Integer.toString(i);
        }
        this.symbolList = new JComboBox<Integer>(intArray);
        this.symbolList.setBorder(new TitledBorder(null, "Symbols:", 0, 0, new Font("Dialog", 1, 8)));
        ComboBoxRenderer renderer = new ComboBoxRenderer(this.images, this.images_text);
        this.symbolList.setRenderer(renderer);
        this.symbolSize = new JComboBox<String>(this.intSizes);
        this.symbolSize.setBorder(new TitledBorder(null, "Size:", 0, 0, new Font("Dialog", 1, 8)));
        this.jglobal = new JPanel();
        this.jerror = new JPanel();
        this.jerrorSys = new JPanel();
        this.add("Global", this.jglobal);
        this.add("Errors", this.jerror);
        this.add("Sys Errors", this.jerrorSys);
        this.jtname = new JTextField(15);
        this.jglobal.add((Component)Utils.labeledComponent("Name:", this.jtname, true), null);
        this.jtname.setFont(this.fdefo);
        this.jglobal.add(this.symbolList);
        this.jglobal.add(this.symbolSize);
        this.color = new JColor(50, 20);
        this.jglobal.add((Component)Utils.labeledComponent("Color:", this.color, true), null);
        this.spnLineWidth = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        this.jglobal.add(Utils.labeledComponent("Width:", this.spnLineWidth, true));
        this.spnLineWidthTick = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        this.jglobal.add(Utils.labeledComponent("Tick size:", this.spnLineWidthTick, true));
        this.chkErr = new JCheckBox[2];
        this.chkErrSys = new JCheckBox[2];
        this.spnLineWidthErr = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        this.jerror.add(Utils.labeledComponent("Line Width:", this.spnLineWidthErr, true));
        this.colorErrX = new JColor(50, 20);
        this.jerror.add((Component)Utils.labeledComponent("X Color:", this.colorErrX, true), null);
        this.colorErrY = new JColor(50, 20);
        this.jerror.add((Component)Utils.labeledComponent("Y Color:", this.colorErrY, true), null);
        this.chkFillError = new JCheckBox("Fill");
        this.jerror.add((Component)this.chkFillError, null);
        this.colorFillError = new JColor(50, 20);
        this.jerror.add((Component)Utils.labeledComponent("Fill Color:", this.colorFillError, true), null);
        this.spnLineWidthErrSys = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        this.jerrorSys.add(Utils.labeledComponent("Line Width:", this.spnLineWidthErrSys, true));
        this.colorErrSysX = new JColor(50, 20);
        this.jerrorSys.add((Component)Utils.labeledComponent("X Color:", this.colorErrSysX, true), null);
        this.colorErrSysY = new JColor(50, 20);
        this.jerrorSys.add((Component)Utils.labeledComponent("Y Color:", this.colorErrSysY, true), null);
        this.chkFillErrorSys = new JCheckBox("Fill");
        this.jerrorSys.add((Component)this.chkFillErrorSys, null);
        this.colorFillErrorSys = new JColor(50, 20);
        this.jerrorSys.add((Component)Utils.labeledComponent("Fill Color:", this.colorFillErrorSys, true), null);
        this.chkErr[0] = new JCheckBox("show X");
        this.jerror.add((Component)this.chkErr[0], null);
        this.chkErr[1] = new JCheckBox("show Y");
        this.jerror.add((Component)this.chkErr[1], null);
        this.chkErrSys[0] = new JCheckBox("show X");
        this.jerrorSys.add((Component)this.chkErrSys[0], null);
        this.chkErrSys[1] = new JCheckBox("show  Y");
        this.jerrorSys.add((Component)this.chkErrSys[1], null);
    }

    public void setDataArray(DataArray da) {
        this.da = da;
        this.getStyle();
    }

    public void setStyle() {
        int id;
        this.da.setColor(this.color.getColor());
        this.da.setColorErrorsX(this.colorErrX.getColor());
        this.da.setColorErrorsY(this.colorErrY.getColor());
        this.da.setColorErrorsSysX(this.colorErrSysX.getColor());
        this.da.setColorErrorsSysY(this.colorErrSysY.getColor());
        String s = this.jtname.getText();
        s = s.trim();
        if (s != null) {
            this.da.setName(this.jtname.getText());
        }
        if ((id = this.symbolList.getSelectedIndex()) > -1 && id < 13) {
            this.da.setGraphStyle(0);
            this.da.setDrawLine(false);
            this.da.setSymbol(id);
            this.da.setDrawSymbol(true);
            this.da.setType(103);
        }
        if (id == 13) {
            this.da.setGraphStyle(0);
            this.da.setDrawLine(true);
            this.da.setGraphStyle(0);
            this.da.setType(103);
        }
        if (id == 14) {
            this.da.setGraphStyle(1);
            this.da.setSymbol(21);
            this.da.setDrawLine(false);
            this.da.setDrawSymbol(false);
            this.da.setGraphStyle(1);
            this.da.setType(101);
        }
        if (id == 15) {
            this.da.setGraphStyle(1);
            this.da.setSymbol(22);
            this.da.setDrawLine(false);
            this.da.setDrawSymbol(false);
            this.da.setGraphStyle(1);
            this.da.setType(101);
        }
        this.da.setSymbolSize(this.symbolSize.getSelectedIndex());
        this.da.errorsX(this.chkErr[0].isSelected());
        this.da.errorsY(this.chkErr[1].isSelected());
        this.da.errorsSysX(this.chkErrSys[0].isSelected());
        this.da.errorsSysY(this.chkErrSys[1].isSelected());
        int w = (Integer)this.spnLineWidth.getValue();
        this.da.setPenWidth(w);
        w = (Integer)this.spnLineWidthErr.getValue();
        this.da.setPenWidthErr(w);
        w = (Integer)this.spnLineWidthErrSys.getValue();
        this.da.setPenWidthErrSys(w);
        w = (Integer)this.spnLineWidthTick.getValue();
        this.da.setErrTicSize(w);
        this.da.errorsFill(this.chkFillError.isSelected());
        this.da.errorsFillSys(this.chkFillErrorSys.isSelected());
        this.da.setColorErrorsFill(this.colorFillError.getColor());
        this.da.setColorErrorsFillSys(this.colorFillErrorSys.getColor());
    }

    public void getStyle() {
        if (this.da.drawLine() && this.da.getGraphStyle() == 0) {
            this.symbolList.setSelectedIndex(13);
        } else if (this.da.getType() == 101 && !this.da.fill()) {
            this.symbolList.setSelectedIndex(14);
        } else if (this.da.getType() == 101 && this.da.fill()) {
            this.symbolList.setSelectedIndex(15);
        } else if (this.da.drawSymbol()) {
            this.symbolList.setSelectedIndex(this.da.getSymbol());
        }
        this.symbolSize.setSelectedIndex((int)this.da.getSymbolSize());
        this.color.setColor(this.da.getColor());
        this.colorErrX.setColor(this.da.getColorErrorsX());
        this.colorErrY.setColor(this.da.getColorErrorsY());
        this.colorErrSysX.setColor(this.da.getColorErrorsSysX());
        this.colorErrSysY.setColor(this.da.getColorErrorsSysY());
        this.spnLineWidthTick.setValue(new Integer((int)this.da.getErrTicSize()));
        this.spnLineWidth.setValue(new Integer((int)this.da.getPenWidth()));
        this.spnLineWidthErr.setValue(new Integer((int)this.da.getPenWidthErr()));
        this.spnLineWidthErrSys.setValue(new Integer((int)this.da.getPenWidthErrSys()));
        this.chkErr[0].setSelected(this.da.getErrorsX());
        this.chkErr[1].setSelected(this.da.getErrorsY());
        this.chkErrSys[0].setSelected(this.da.getErrorsSysX());
        this.chkErrSys[1].setSelected(this.da.getErrorsSysY());
        this.chkFillError.setSelected(this.da.getErrorsFill());
        this.chkFillErrorSys.setSelected(this.da.getErrorsFillSys());
        this.colorFillError.setColor(this.da.getColorErrorsFill());
        this.colorFillErrorSys.setColor(this.da.getColorErrorsFillSys());
        this.jtname.setText(this.da.getName().trim());
    }
}

