/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.jgap.distr.grid.gp.JGAPGPXStream;
import org.jgap.distr.grid.gp.JGAPRequestGP;
import org.jgap.gp.BaseGPChromosome;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPProgramBase;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.ProgramChromosome;

public class PersistableObject {
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private transient Logger log = Logger.getLogger(this.getClass());
    private Object m_object;
    private File m_file;

    public PersistableObject(File a_file) {
        this.m_file = a_file;
    }

    public PersistableObject(String a_filename) {
        this(new File(a_filename));
    }

    public void setObject(Object a_object) {
        this.m_object = a_object;
    }

    public void save() throws Exception {
        this.save(false);
    }

    public void save(boolean a_omitConfig) throws Exception {
        this.save(a_omitConfig, null);
    }

    public void save(boolean a_omitConfig, Object[][] a_omitFields) throws Exception {
        this.log.info((Object)("Saving object to file " + this.m_file.getName()));
        JGAPGPXStream xstream = new JGAPGPXStream();
        this.init(xstream);
        if (a_omitConfig) {
            xstream.omitField(GPProgramBase.class, "m_conf");
            xstream.omitField(ProgramChromosome.class, "m_configuration");
            xstream.omitField(BaseGPChromosome.class, "m_configuration");
            xstream.omitField(GPPopulation.class, "m_config");
            xstream.omitField(GPProgram.class, "m_conf");
            xstream.omitField(GPProgramBase.class, "m_conf");
            xstream.omitField(JGAPRequestGP.class, "m_config");
            xstream.omitField(CommandGene.class, "m_configuration");
        }
        if (a_omitFields != null) {
            for (int i = 0; i < a_omitFields.length; ++i) {
                Class clazz = (Class)a_omitFields[i][0];
                String fieldName = (String)a_omitFields[i][1];
                xstream.omitField(clazz, fieldName);
            }
        }
        FileWriter fw = new FileWriter(this.m_file);
        CompactWriter compact = new CompactWriter((Writer)fw);
        xstream.marshal(this.m_object, (HierarchicalStreamWriter)compact);
    }

    public Object load() throws Exception {
        return this.load(this.m_file);
    }

    public Object load(File a_file) {
        this.log.info((Object)("Loading object from file " + a_file.getName()));
        JGAPGPXStream xstream = new JGAPGPXStream();
        this.init(xstream);
        try {
            FileInputStream fis = new FileInputStream(a_file);
            this.m_object = xstream.fromXML(fis);
            fis.close();
            return this.m_object;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object getObject() {
        return this.m_object;
    }

    protected void init(XStream a_xstream) {
    }
}

