/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.supergenes;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jgap.BaseGene;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.supergenes.Supergene;
import org.jgap.supergenes.SupergeneValidator;

public abstract class AbstractSupergene
extends BaseGene
implements Supergene,
SupergeneValidator,
IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.24 $";
    public static final String GENE_DELIMITER = "#";
    public static final String GENE_DELIMITER_HEADING = "<";
    public static final String GENE_DELIMITER_CLOSING = ">";
    public static final int MAX_RETRIES = 1;
    public static final int MAX_IMMUTABLE_GENES = 100000;
    private Gene[] m_genes;
    private static Set[] m_immutable = new Set[1];
    protected SupergeneValidator m_validator = this;

    @Override
    public Gene[] getGenes() {
        return this.m_genes;
    }

    @Override
    public final Gene geneAt(int a_index) {
        return this.m_genes[a_index];
    }

    public AbstractSupergene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration(), new Gene[0]);
    }

    public AbstractSupergene(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, new Gene[0]);
    }

    public AbstractSupergene(Configuration a_conf, Gene[] a_genes) throws InvalidConfigurationException {
        super(a_conf);
        if (a_genes == null) {
            throw new RuntimeException("null value for genes not allowed!");
        }
        this.m_genes = a_genes;
    }

    @Override
    public boolean isValid() {
        if (this.m_validator == null) {
            return true;
        }
        return this.m_validator.isValid(this.m_genes, this);
    }

    @Override
    public boolean isValid(Gene[] a_case, Supergene a_forSupergene) {
        throw new Error("For " + this.getClass().getName() + ", override " + " isValid (Gene[], Supergene) or set an" + " external validator.");
    }

    @Override
    protected Gene newGeneInternal() {
        Gene[] g = new Gene[this.m_genes.length];
        for (int i = 0; i < this.m_genes.length; ++i) {
            g[i] = this.m_genes[i].newGene();
        }
        try {
            Constructor<?> constr = this.getClass().getConstructor(Configuration.class, Gene[].class);
            AbstractSupergene asg = (AbstractSupergene)constr.newInstance(this.getConfiguration(), g);
            if (this.m_validator != this) {
                asg.setValidator(this.m_validator);
            }
            return asg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Error("This should not happen. Is the constructor with parameters {org.jgap.Configuration, org,jgap,Gene[]} provided for " + this.getClass().getName() + "?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void applyMutation(int a_index, double a_percentage) {
        if (a_index < m_immutable.length && m_immutable[a_index] != null) {
            Set[] setArray = m_immutable;
            // MONITORENTER : m_immutable
            if (m_immutable[a_index].contains(this)) {
                // MONITOREXIT : setArray
                return;
            }
            // MONITOREXIT : setArray
        }
        Object backup = this.m_genes[a_index].getAllele();
        int size = this.m_genes[a_index].size();
        int mutIndex = size > 0 ? this.getConfiguration().getRandomGenerator().nextInt(size + 1) : 0;
        int i = 0;
        while (true) {
            if (i >= 1) {
                this.m_genes[a_index].setAllele(backup);
                this.markImmutable(a_index);
                return;
            }
            this.m_genes[a_index].applyMutation(mutIndex, a_percentage);
            if (this.isValid()) {
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markImmutable(int a_index) {
        Set[] setArray = m_immutable;
        synchronized (m_immutable) {
            if (m_immutable.length <= a_index) {
                Set[] r = new Set[2 * m_immutable.length];
                System.arraycopy(m_immutable, 0, r, 0, m_immutable.length);
                m_immutable = r;
            }
            if (m_immutable[a_index] == null) {
                AbstractSupergene.m_immutable[a_index] = new TreeSet();
            }
            if (m_immutable[a_index].size() < 100000) {
                m_immutable[a_index].add(this);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void reset() {
        m_immutable = new Set[1];
    }

    @Override
    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        int i;
        for (i = 0; i < this.m_genes.length; ++i) {
            this.m_genes[i].setToRandomValue(a_numberGenerator);
        }
        if (this.isValid()) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            for (int j = 0; j < this.m_genes.length; ++j) {
                this.m_genes[j].setToRandomValue(a_numberGenerator);
                if (!this.isValid()) continue;
                return;
            }
        }
    }

    @Override
    public void setAllele(Object a_superAllele) {
        if (this.m_genes.length < 1) {
            return;
        }
        Object[] a = (Object[])a_superAllele;
        if (a.length != this.m_genes.length) {
            throw new IllegalArgumentException("Record length, " + a.length + " not equal to " + this.m_genes.length);
        }
        for (int i = 0; i < this.m_genes.length; ++i) {
            this.m_genes[i].setAllele(a[i]);
        }
    }

    @Override
    public Object getAllele() {
        Object[] o = new Object[this.m_genes.length];
        for (int i = 0; i < this.m_genes.length; ++i) {
            o[i] = this.m_genes[i].getAllele();
        }
        return o;
    }

    @Override
    public String getPersistentRepresentation() throws UnsupportedOperationException {
        StringBuffer b = new StringBuffer();
        String validator = null;
        String v_representation = "";
        SupergeneValidator v = this.getValidator();
        if (v == null) {
            validator = "null";
        } else if (v == this) {
            validator = "this";
        } else {
            validator = v.getClass().getName();
            v_representation = v.getPersistent();
        }
        b.append(GENE_DELIMITER_HEADING);
        b.append(this.encode(validator + GENE_DELIMITER + v_representation));
        b.append(GENE_DELIMITER_CLOSING);
        for (int i = 0; i < this.m_genes.length; ++i) {
            Gene gene = this.m_genes[i];
            b.append(GENE_DELIMITER_HEADING);
            b.append(this.encode(gene.getClass().getName() + GENE_DELIMITER + gene.getPersistentRepresentation()));
            b.append(GENE_DELIMITER_CLOSING);
        }
        return b.toString();
    }

    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            try {
                List r = AbstractSupergene.split(a_representation);
                Iterator iter = r.iterator();
                this.m_genes = new Gene[r.size() - 1];
                String validator = (String)iter.next();
                this.setValidator(this.createValidator(this.decode(validator)));
                for (int i = 0; i < this.m_genes.length; ++i) {
                    Gene gene;
                    String g = this.decode((String)iter.next());
                    StringTokenizer st = new StringTokenizer(g, GENE_DELIMITER);
                    if (st.countTokens() != 2) {
                        throw new UnsupportedRepresentationException("In " + g + ", " + "expecting two tokens, separated by " + GENE_DELIMITER);
                    }
                    String clas = st.nextToken();
                    String representation = st.nextToken();
                    this.m_genes[i] = gene = this.createGene(clas, representation);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new UnsupportedRepresentationException(ex.getCause().getMessage());
            }
        } else {
            throw new UnsupportedRepresentationException("null value not allowed");
        }
    }

    protected SupergeneValidator createValidator(String a_rep) {
        try {
            SupergeneValidator sv;
            StringTokenizer vo = new StringTokenizer(a_rep, GENE_DELIMITER, true);
            if (vo.countTokens() != 2) {
                throw new Error("In " + a_rep + ", expecting two tokens, separated by " + GENE_DELIMITER);
            }
            String clas = vo.nextToken();
            if (clas.equals("this")) {
                sv = this;
            } else if (clas.equals("null")) {
                sv = null;
            } else {
                Class<?> svClass = Class.forName(clas);
                Constructor<?> constr = svClass.getConstructor(Configuration.class);
                sv = (SupergeneValidator)constr.newInstance(this.getConfiguration());
            }
            if (sv != null) {
                sv.setFromPersistent(this.decode(vo.nextToken()));
            }
            return sv;
        }
        catch (Exception ex) {
            throw new Error("Unable to create validator from '" + a_rep + "' for " + this.getClass().getName(), ex);
        }
    }

    protected Gene createGene(String a_geneClassName, String a_persistentRepresentation) throws Exception {
        Class<?> geneClass = Class.forName(a_geneClassName);
        Constructor<?> constr = geneClass.getConstructor(Configuration.class);
        Gene gene = (Gene)constr.newInstance(this.getConfiguration());
        gene.setValueFromPersistentRepresentation(a_persistentRepresentation);
        return gene;
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.m_genes.length; ++i) {
            this.m_genes[i].cleanup();
        }
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Supergene " + this.getClass().getName() + " {");
        for (int i = 0; i < this.m_genes.length; ++i) {
            b.append("|");
            b.append(this.m_genes[i].toString());
            b.append("|");
        }
        if (this.m_validator == null) {
            b.append(" non validating");
        } else {
            b.append(" validator: " + this.m_validator.getClass().getName());
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public int size() {
        return this.m_genes.length;
    }

    public int compareTo(Object o) {
        AbstractSupergene q = (AbstractSupergene)o;
        int c = this.m_genes.length - q.m_genes.length;
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < this.m_genes.length; ++i) {
            c = this.m_genes[i].compareTo(q.m_genes[i]);
            if (c == 0) continue;
            return c;
        }
        if (this.getClass().equals(o.getClass())) {
            return 0;
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public boolean equals(Object a_gene) {
        if (a_gene == null || !a_gene.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractSupergene age = (AbstractSupergene)a_gene;
        if (this.m_validator != age.m_validator && this.m_validator != null) {
            if (m_immutable != null && !this.m_validator.getClass().equals(age.m_validator.getClass())) {
                return false;
            }
        }
        return Arrays.equals(this.m_genes, age.m_genes);
    }

    @Override
    public int hashCode() {
        int s = 0;
        for (int i = this.m_genes.length - 1; i >= 0; --i) {
            s += this.m_genes[i].hashCode();
        }
        return s;
    }

    protected static final List split(String a_string) throws UnsupportedRepresentationException {
        List<String> a = Collections.synchronizedList(new ArrayList());
        StringTokenizer st = new StringTokenizer(a_string, "<>", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(GENE_DELIMITER_HEADING)) {
                throw new UnsupportedRepresentationException(a_string + " no open tag");
            }
            String n = st.nextToken();
            if (n.equals(GENE_DELIMITER_CLOSING)) {
                a.add("");
                continue;
            }
            a.add(n);
            if (st.nextToken().equals(GENE_DELIMITER_CLOSING)) continue;
            throw new UnsupportedRepresentationException(a_string + " no close tag");
        }
        return a;
    }

    @Override
    public void addGene(Gene a_gene) {
        Gene[] genes = new Gene[this.m_genes.length + 1];
        System.arraycopy(this.m_genes, 0, genes, 0, this.m_genes.length);
        genes[this.m_genes.length] = a_gene;
        this.m_genes = genes;
    }

    @Override
    public void setValidator(SupergeneValidator a_validator) {
        this.m_validator = a_validator;
    }

    @Override
    public SupergeneValidator getValidator() {
        return this.m_validator;
    }

    @Override
    public String getPersistent() {
        return "";
    }

    @Override
    public void setFromPersistent(String a_from) {
    }

    @Override
    public Object getInternalValue() {
        throw new RuntimeException("getInternalValue() called unexpectedly!");
    }
}

