/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl.job;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.impl.BooleanGene;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.FittestPopulationMerger;
import org.jgap.impl.job.EvolveResult;
import org.jgap.impl.job.IEvolveJob;
import org.jgap.impl.job.IJob;
import org.jgap.impl.job.MaxFunction;
import org.jgap.impl.job.SimplePopulationSplitter;

public class SimpleJobConsumer {
    private static final String CVS_REVISION = "$Revision: 1.6 $";
    private List m_jobs = new Vector();
    private List m_results = new Vector();

    public void pushJobToGrid(IJob a_job) {
        this.m_jobs.add(a_job);
        new Thread(a_job).start();
    }

    public void waitForAllJobs() {
        while (this.m_jobs.size() >= 1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
                break;
            }
            Iterator it = this.m_jobs.iterator();
            while (it.hasNext()) {
                IJob job = (IJob)it.next();
                if (!job.isFinished()) continue;
                System.out.println("Another job finished!");
                this.m_results.add(job.getResult());
                it.remove();
            }
        }
    }

    public EvolveResult[] getResults() {
        int size = this.m_results.size();
        if (size < 1) {
            throw new IllegalStateException("No results found!");
        }
        EvolveResult[] results = new EvolveResult[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (EvolveResult)this.m_results.get(i);
        }
        return results;
    }

    public void init() throws Exception {
        DefaultConfiguration gaConf = new DefaultConfiguration();
        gaConf.setPreservFittestIndividual(true);
        gaConf.setKeepPopulationSizeConstant(false);
        SimpleJobConsumer gridClient = new SimpleJobConsumer();
        Chromosome sampleChromosome = new Chromosome((Configuration)gaConf, new BooleanGene(gaConf), 16);
        gaConf.setSampleChromosome(sampleChromosome);
        gaConf.setPopulationSize(20);
        gaConf.setFitnessFunction(new MaxFunction());
        Genotype genotype = Genotype.randomInitialGenotype(gaConf);
        SimplePopulationSplitter popSplitter = new SimplePopulationSplitter(3);
        for (int i = 0; i < 50; ++i) {
            List<IEvolveJob> evolves = genotype.getEvolves(popSplitter);
            for (IEvolveJob evolve : evolves) {
                gridClient.pushJobToGrid(evolve);
            }
            gridClient.waitForAllJobs();
            FittestPopulationMerger popMerger = new FittestPopulationMerger();
            genotype.mergeResults(popMerger, gridClient.getResults());
        }
        IChromosome fittest = genotype.getFittestChromosome();
        System.out.println("Best solution: " + fittest.toString());
    }

    public static void main(String[] args) throws Exception {
        new SimpleJobConsumer().init();
        System.exit(0);
    }
}

