/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl.fitness;

import java.util.Map;
import java.util.Set;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Genotype;
import org.jgap.IChromosome;

public abstract class TruthTableFitnessFunction
extends FitnessFunction {
    private static final String CVS_REVISION = "$Revision: 1.6 $";
    private Map m_truthTable;
    public static final int MAX_FITNESS = 9999999;
    private static final int RELATION_FITNESS = 100;
    public static final int WORST = 99999;
    private Configuration m_conf;

    public TruthTableFitnessFunction() {
        this(Genotype.getStaticConfiguration());
    }

    public TruthTableFitnessFunction(Configuration a_conf) {
        this.m_conf = a_conf;
    }

    public TruthTableFitnessFunction(Configuration a_conf, Map a_truthTable) {
        this(a_conf);
        this.setTruthTable(a_truthTable);
    }

    public void setTruthTable(Map a_truthTable) {
        this.m_truthTable = a_truthTable;
    }

    public Map getTruthTable() {
        return this.m_truthTable;
    }

    @Override
    protected abstract double evaluate(IChromosome var1);

    public double calcFitness(Map a_actualInputOutput) {
        double diffAbs = 0.0;
        Set keySet = this.getTruthTable().keySet();
        for (Double inputValueWanted : keySet) {
            double deltaAbs;
            double outputValueWanted = (Double)this.getTruthTable().get(inputValueWanted);
            Double output = (Double)a_actualInputOutput.get(inputValueWanted);
            if (output != null) {
                double outputValueGiven = output;
                if (Double.isNaN(outputValueWanted)) {
                    return Double.NaN;
                }
                double delta = outputValueGiven - outputValueWanted;
                deltaAbs = (float)Math.abs(delta);
            } else {
                deltaAbs = Math.abs(outputValueWanted);
            }
            diffAbs += deltaAbs;
        }
        return diffAbs;
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }
}

