/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jgap.IBusinessKey;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.gp.BaseGPChromosome;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPInitStrategy;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.IUniqueCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.terminal.Argument;
import org.jgap.gp.terminal.NOP;
import org.jgap.util.ICloneable;
import org.jgap.util.StringKit;

public class ProgramChromosome
extends BaseGPChromosome
implements Comparable,
Cloneable,
IBusinessKey {
    private static final String CVS_REVISION = "$Revision: 1.49 $";
    static final String PERSISTENT_FIELD_DELIMITER = ":";
    static final String GENE_DELIMITER_HEADING = "<";
    static final String GENE_DELIMITER_CLOSING = ">";
    static final String GENE_DELIMITER = "#";
    private static transient Logger LOGGER = Logger.getLogger(ProgramChromosome.class);
    private CommandGene[] m_functionSet;
    private int[] m_depth;
    private Class[] argTypes;
    private transient int m_index;
    private transient int m_maxDepth;
    private CommandGene[] m_genes;
    private Object m_applicationData;
    private boolean m_compareAppData;

    public ProgramChromosome(GPConfiguration a_conf, int a_size) throws InvalidConfigurationException {
        super(a_conf);
        if (a_size <= 0) {
            throw new IllegalArgumentException("Chromosome size must be greater than zero");
        }
        this.init(a_size);
    }

    public ProgramChromosome(GPConfiguration a_conf, int a_size, IGPProgram a_ind) throws InvalidConfigurationException {
        super(a_conf, a_ind);
        if (a_size <= 0) {
            throw new IllegalArgumentException("Chromosome size must be greater than zero");
        }
        if (a_ind == null) {
            throw new IllegalArgumentException("Individual must not be null");
        }
        this.init(a_size);
    }

    public ProgramChromosome(GPConfiguration a_conf, int a_size, CommandGene[] a_functionSet, Class[] a_argTypes, IGPProgram a_ind) throws InvalidConfigurationException {
        super(a_conf, a_ind);
        if (a_size <= 0) {
            throw new IllegalArgumentException("Chromosome size must be greater than zero");
        }
        if (a_ind == null) {
            throw new IllegalArgumentException("Individual must not be null");
        }
        this.m_functionSet = a_functionSet;
        this.argTypes = a_argTypes;
        this.init(a_size);
    }

    public ProgramChromosome(GPConfiguration a_conf, CommandGene[] a_initialGenes) throws InvalidConfigurationException {
        super(a_conf);
        int i;
        for (i = 0; i < a_initialGenes.length && a_initialGenes[i] != null; ++i) {
        }
        this.init(a_initialGenes.length);
        for (int k = 0; k < i; ++k) {
            this.m_genes[k] = a_initialGenes[k];
        }
    }

    public ProgramChromosome(GPConfiguration a_conf) throws InvalidConfigurationException {
        super(a_conf);
        this.init();
    }

    public ProgramChromosome() throws InvalidConfigurationException {
        this(GPGenotype.getStaticGPConfiguration());
    }

    private void init() throws InvalidConfigurationException {
        this.init(this.getGPConfiguration().getPopulationSize());
    }

    private void init(int a_size) throws InvalidConfigurationException {
        this.m_depth = new int[a_size];
        this.m_genes = new CommandGene[a_size];
    }

    public void setArgTypes(Class[] a_argTypes) {
        this.argTypes = a_argTypes;
    }

    public synchronized Object clone() {
        try {
            int size = this.m_genes.length;
            CommandGene[] genes = new CommandGene[size];
            for (int i = 0; i < size && this.m_genes[i] != null; ++i) {
                genes[i] = ICloneable.class.isAssignableFrom(this.m_genes[i].getClass()) ? (CommandGene)((ICloneable)((Object)this.m_genes[i])).clone() : this.m_genes[i];
            }
            ProgramChromosome chrom = new ProgramChromosome(this.getGPConfiguration(), genes);
            chrom.argTypes = (Class[])this.argTypes.clone();
            if (this.getFunctionSet() != null) {
                chrom.setFunctionSet((CommandGene[])this.getFunctionSet().clone());
            }
            if (this.m_depth != null) {
                chrom.m_depth = (int[])this.m_depth.clone();
            }
            chrom.setIndividual(this.getIndividual());
            return chrom;
        }
        catch (Exception cex) {
            throw new IllegalStateException(cex);
        }
    }

    @Override
    public void cleanup() {
        int len = this.m_genes.length;
        for (int i = 0; i < len && this.m_genes[i] != null; ++i) {
            this.m_genes[i].cleanup();
        }
    }

    public void growOrFull(int a_num, int a_depth, Class a_type, Class[] a_argTypes, CommandGene[] a_functionSet, boolean a_grow, int a_tries) {
        try {
            CommandGene n;
            this.argTypes = a_argTypes;
            this.setFunctionSet(new CommandGene[a_functionSet.length + a_argTypes.length]);
            System.arraycopy(a_functionSet, 0, this.getFunctionSet(), 0, a_functionSet.length);
            for (int i = 0; i < a_argTypes.length; ++i) {
                this.m_functionSet[a_functionSet.length + i] = new Argument(this.getGPConfiguration(), i, a_argTypes[i]);
            }
            IGPInitStrategy programIniter = this.getGPConfiguration().getInitStrategy();
            if (programIniter == null) {
                n = null;
            } else {
                try {
                    n = programIniter.init(this, a_num);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            int localDepth = a_depth;
            this.m_index = 0;
            this.m_maxDepth = localDepth;
            this.growOrFullNode(a_num, localDepth, a_type, 0, this.m_functionSet, n, 0, a_grow, -1, false);
            if (!this.getGPConfiguration().validateNode(this, null, n, a_tries, a_num, 0, a_type, this.m_functionSet, a_depth, a_grow, -1, true)) {
                throw new IllegalStateException("Randomly created program violates configuration constraints (symptom 3).");
            }
            this.redepth();
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public String toString(int a_startNode) {
        String placeHolder;
        int foundIndex;
        if (a_startNode < 0) {
            return "";
        }
        String funcName = this.m_genes[a_startNode].toString();
        int j = 1;
        while ((foundIndex = funcName.indexOf(placeHolder = "&" + j)) >= 0) {
            funcName = funcName.replaceFirst(placeHolder, "");
            ++j;
        }
        if (j > 0) {
            funcName = funcName.trim();
        }
        IGPProgram ind = this.getIndividual();
        if (this.getFunctions()[a_startNode].getArity(ind) == 0) {
            return funcName + " ";
        }
        String str = "";
        str = str + funcName + " ( ";
        int arity = this.m_genes[a_startNode].getArity(ind);
        for (int i = 0; i < arity; ++i) {
            str = str + this.toString(this.getChild(a_startNode, i));
        }
        str = a_startNode == 0 ? str + ")" : str + ") ";
        return str;
    }

    @Override
    public String toStringNorm(int a_startNode) {
        if (a_startNode < 0) {
            return "";
        }
        IGPProgram ind = this.getIndividual();
        if (this.m_genes[a_startNode].getArity(ind) == 0) {
            return this.getFunctions()[a_startNode].toString();
        }
        String str = "";
        boolean paramOutput = false;
        if (this.m_genes[a_startNode].getArity(ind) > 0 && this.m_genes[a_startNode].toString().indexOf("&1") >= 0) {
            paramOutput = true;
        }
        if (this.m_genes[a_startNode].getArity(ind) == 1 || paramOutput) {
            str = str + this.getFunctions()[a_startNode].toString();
        }
        if (a_startNode > 0) {
            str = "(" + str;
        }
        for (int i = 0; i < this.m_genes[a_startNode].getArity(ind); ++i) {
            String childString = this.toStringNorm(this.getChild(a_startNode, i));
            String placeHolder = "&" + (i + 1);
            int placeholderIndex = str.indexOf(placeHolder);
            str = placeholderIndex >= 0 ? str.replaceFirst(placeHolder, childString) : str + childString;
            if (i != 0 || this.m_genes[a_startNode].getArity(ind) == 1 || paramOutput) continue;
            str = str + " " + this.m_genes[a_startNode].toString() + " ";
        }
        if (a_startNode > 0) {
            str = str + ")";
        }
        return str;
    }

    @Override
    public String getBusinessKey() {
        return this.toStringNorm(0);
    }

    public String toStringDebug() {
        IGPProgram ind = this.getIndividual();
        if (this.m_genes[0].getArity(ind) == 0) {
            return this.getClass().getName();
        }
        String s = "";
        for (int i = 0; i < this.m_genes[0].getArity(ind); ++i) {
            String childString = this.toStringNorm(this.getChild(0, i));
            s = s + GENE_DELIMITER_HEADING + childString + " >";
        }
        return s;
    }

    public boolean isPossible(Class a_returnType, int a_subReturnType, CommandGene[] a_nodeSet, boolean a_function, boolean a_growing) {
        IGPProgram ind = this.getIndividual();
        for (int i = 0; i < a_nodeSet.length; ++i) {
            if (a_nodeSet[i].getReturnType() != a_returnType || a_subReturnType != 0 && a_subReturnType != a_nodeSet[i].getSubReturnType()) continue;
            if (a_nodeSet[i].getArity(ind) == 0 && (!a_function || a_growing)) {
                return true;
            }
            if (a_nodeSet[i].getArity(ind) == 0 || !a_function) continue;
            return true;
        }
        return false;
    }

    protected CommandGene selectNode(int a_chromIndex, Class a_returnType, int a_subReturnType, CommandGene[] a_functionSet, boolean a_function, boolean a_growing) {
        Vector<CommandGene> possibleFunctions = new Vector<CommandGene>(0);
        IGPProgram ind = this.getIndividual();
        for (int i = 0; i < a_functionSet.length; ++i) {
            if (a_functionSet[i].getReturnType() != a_returnType || a_subReturnType != 0 && a_subReturnType != a_functionSet[i].getSubReturnType()) continue;
            if (a_functionSet[i].getArity(ind) == 0 && (!a_function || a_growing)) {
                possibleFunctions.add(a_functionSet[i]);
            }
            if (a_functionSet[i].getArity(ind) == 0 || !a_function) continue;
            possibleFunctions.add(a_functionSet[i]);
        }
        if (possibleFunctions.isEmpty()) {
            if (a_growing && (a_returnType == CommandGene.VoidClass || a_returnType == Void.class)) {
                try {
                    return new NOP(this.getGPConfiguration(), a_subReturnType);
                }
                catch (InvalidConfigurationException iex) {
                    throw new RuntimeException(iex);
                }
            }
            String errormsg = "Chromosome (depth " + this.getDepth(0) + ", index " + a_chromIndex + ") requires a " + (a_function ? "function" + (a_growing ? " or terminal" : "") : "terminal") + " of return type " + a_returnType + " (sub return type " + a_subReturnType + ")" + " but there is no such node available";
            if (!this.getGPConfiguration().isStrictProgramCreation()) {
                throw new IllegalStateException(errormsg);
            }
            throw new RuntimeException(errormsg);
        }
        int index = this.getGPConfiguration().getRandomGenerator().nextInt(possibleFunctions.size());
        CommandGene n = (CommandGene)possibleFunctions.elementAt(index);
        return n;
    }

    protected CommandGene[] growOrFullNode(int a_num, int a_depth, Class a_returnType, int a_subReturnType, CommandGene[] a_functionSet, CommandGene a_rootNode, int a_recurseLevel, boolean a_grow, int a_childNum, boolean a_validateNode) {
        boolean dynamize;
        boolean mutated = false;
        boolean uncloned = true;
        GPConfiguration conf = this.getGPConfiguration();
        RandomGenerator random = conf.getRandomGenerator();
        if (a_rootNode == null || a_validateNode) {
            CommandGene node;
            int tries = 0;
            int evolutionRound = this.getGPConfiguration().getGenerationNr();
            boolean aFunction = a_depth >= 1;
            CommandGene[] localFunctionSet = (CommandGene[])a_functionSet.clone();
            int len = a_functionSet.length;
            while (!(conf.validateNode(this, node = this.selectNode(a_num, a_returnType, a_subReturnType, localFunctionSet, aFunction, a_grow), a_rootNode, tries++, a_num, a_recurseLevel, a_returnType, localFunctionSet, a_depth, a_grow, a_childNum, false) || evolutionRound <= 0 && tries > len * 2)) {
                if ((localFunctionSet = this.remove(localFunctionSet, node)).length != 0) continue;
                throw new IllegalStateException("No appropriate function found during program creation!");
            }
            if (random.nextDouble() <= conf.getMutationProb() && IMutateable.class.isAssignableFrom(node.getClass())) {
                try {
                    CommandGene node2 = ((IMutateable)((Object)node)).applyMutation(0, random.nextDouble());
                    if (this.getCommandOfClass(0, node2.getClass()) >= 0) {
                        mutated = true;
                        if (node2 != node) {
                            node = node2;
                            uncloned = false;
                        }
                    }
                }
                catch (InvalidConfigurationException iex) {
                    LOGGER.warn((Object)"Ignored problem", (Throwable)iex);
                }
            }
            if (IUniqueCommand.class.isAssignableFrom(node.getClass())) {
                a_functionSet = this.remove(a_functionSet, node);
            }
            a_rootNode = node;
        }
        this.m_depth[this.m_index] = this.m_maxDepth - a_depth;
        boolean bl = dynamize = random.nextDouble() <= conf.getDynamizeArityProb();
        if (dynamize) {
            a_rootNode.dynamizeArity();
        }
        if (uncloned && !conf.isNoCommandGeneCloning() && a_rootNode instanceof ICloneable) {
            a_rootNode = (CommandGene)((ICloneable)((Object)a_rootNode)).clone();
            this.m_genes[this.m_index++] = a_rootNode;
        } else {
            this.m_genes[this.m_index++] = a_rootNode;
        }
        if (a_depth >= 1) {
            IGPProgram ind = this.getIndividual();
            int arity = a_rootNode.getArity(ind);
            for (int i = 0; i < arity; ++i) {
                if (this.m_index >= this.m_depth.length) {
                    throw new IllegalStateException("Randomly created program violates configuration constraints (symptom 1). It may be that you specified a too small number of maxNodes to use (current arity: " + i + ", overall arity: " + arity + ")!");
                }
                a_functionSet = this.growOrFullNode(a_num, a_depth - 1, a_rootNode.getChildType(this.getIndividual(), i), a_rootNode.getSubChildType(i), a_functionSet, a_rootNode, a_recurseLevel + 1, a_grow, i, true);
            }
        } else if (a_rootNode.getArity(this.getIndividual()) > 0) {
            throw new IllegalStateException("Randomly created program violates configuration constraints (symptom 2)");
        }
        return a_functionSet;
    }

    @Override
    public void redepth() {
        this.m_depth[0] = 0;
        this.redepth(0);
    }

    protected int redepth(int a_index) {
        int num = a_index + 1;
        CommandGene command = this.getNode(a_index);
        if (command == null) {
            throw new IllegalStateException("ProgramChromosome invalid at index " + a_index + " (command gene is null)");
        }
        IGPProgram ind = this.getIndividual();
        int arity = command.getArity(ind);
        for (int i = 0; i < arity; ++i) {
            if (num < this.m_depth.length) {
                this.m_depth[num] = this.m_depth[a_index] + 1;
                if ((num = this.redepth(num)) >= 0) continue;
                break;
            }
            return -1;
        }
        return num;
    }

    @Override
    public int getChild(int a_index, int a_child) {
        int len = this.getFunctions().length;
        for (int i = a_index + 1; i < len; ++i) {
            if (this.m_depth[i] <= this.m_depth[a_index]) {
                return -1;
            }
            if (this.m_depth[i] != this.m_depth[a_index] + 1 || --a_child >= 0) continue;
            return i;
        }
        throw new RuntimeException("Bad child " + a_child + " of node with index = " + a_index);
    }

    public int getChild(CommandGene a_node, int a_child) {
        int i;
        int len = this.getFunctions().length;
        int index = -1;
        for (i = 0; i < len; ++i) {
            if (this.m_genes[i] != a_node) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return -2;
        }
        for (i = index + 1; i < len; ++i) {
            if (this.m_depth[i] <= this.m_depth[index]) {
                return -1;
            }
            if (this.m_depth[i] != this.m_depth[index] + 1 || --a_child >= 0) continue;
            return i;
        }
        throw new RuntimeException("Bad child " + a_child + " of node with index = " + index);
    }

    @Override
    public CommandGene[] getFunctionSet() {
        return this.m_functionSet;
    }

    public void setFunctionSet(CommandGene[] a_functionSet) {
        this.m_functionSet = a_functionSet;
    }

    @Override
    public CommandGene[] getFunctions() {
        return this.m_genes;
    }

    public void setFunctions(CommandGene[] a_functions) throws InvalidConfigurationException {
        this.m_genes = a_functions;
    }

    public int getSize(int a_index) {
        int i;
        for (i = a_index + 1; i < this.m_genes.length && this.m_genes[i] != null && this.m_depth[i] > this.m_depth[a_index]; ++i) {
        }
        return i - a_index;
    }

    public int getDepth(int a_index) {
        int maxdepth = this.m_depth[a_index];
        for (int i = a_index + 1; i < this.m_genes.length && this.m_genes[i] != null && this.m_depth[i] > this.m_depth[a_index]; ++i) {
            if (this.m_depth[i] <= maxdepth) continue;
            maxdepth = this.m_depth[i];
        }
        return maxdepth - this.m_depth[a_index];
    }

    public int getParentNode(int a_child) {
        if (a_child >= this.m_genes.length || this.m_genes[a_child] == null) {
            return -1;
        }
        for (int i = a_child - 1; i >= 0; --i) {
            if (this.m_depth[i] != this.m_depth[a_child] - 1) continue;
            return i;
        }
        return -1;
    }

    public CommandGene getNode(Class a_type, boolean a_exactMatch) {
        return this.getNode(a_type, a_exactMatch, 0);
    }

    public CommandGene getNode(Class a_type, boolean a_exactMatch, int a_startIndex) {
        int size = this.m_genes.length;
        for (int i = a_startIndex; i < size && this.m_genes[i] != null; ++i) {
            if (a_exactMatch) {
                if (this.m_genes[i].getClass() != a_type) continue;
                this.m_genes[i].nodeIndex = i;
                return this.m_genes[i];
            }
            if (!a_type.isAssignableFrom(this.m_genes[i].getClass())) continue;
            this.m_genes[i].nodeIndex = i;
            return this.m_genes[i];
        }
        return null;
    }

    public boolean execute_boolean(Object[] args) {
        boolean rtn = this.m_genes[0].execute_boolean(this, 0, args);
        this.cleanup();
        return rtn;
    }

    public boolean execute_boolean(int n, int child, Object[] args) {
        if (child == 0) {
            return this.m_genes[n + 1].execute_boolean(this, n + 1, args);
        }
        int other = this.getChild(n, child);
        return this.m_genes[other].execute_boolean(this, other, args);
    }

    public void execute_void(Object[] args) {
        this.m_genes[0].execute_void(this, 0, args);
        this.cleanup();
    }

    public void execute_void(int n, int child, Object[] args) {
        if (child == 0) {
            this.m_genes[n + 1].execute_void(this, n + 1, args);
        } else {
            int other = this.getChild(n, child);
            this.m_genes[other].execute_void(this, other, args);
        }
    }

    public int execute_int(Object[] args) {
        int rtn = this.m_genes[0].execute_int(this, 0, args);
        this.cleanup();
        return rtn;
    }

    public int execute_int(int n, int child, Object[] args) {
        if (child == 0) {
            return this.m_genes[n + 1].execute_int(this, n + 1, args);
        }
        int other = this.getChild(n, child);
        return this.m_genes[other].execute_int(this, other, args);
    }

    public long execute_long(Object[] args) {
        long rtn = this.m_genes[0].execute_long(this, 0, args);
        this.cleanup();
        return rtn;
    }

    public long execute_long(int n, int child, Object[] args) {
        if (child == 0) {
            return this.m_genes[n + 1].execute_long(this, n + 1, args);
        }
        int other = this.getChild(n, child);
        return this.m_genes[other].execute_long(this, other, args);
    }

    public float execute_float(Object[] args) {
        float rtn = this.m_genes[0].execute_float(this, 0, args);
        this.cleanup();
        return rtn;
    }

    public float execute_float(int n, int child, Object[] args) {
        if (child == 0) {
            return this.m_genes[n + 1].execute_float(this, n + 1, args);
        }
        int other = this.getChild(n, child);
        return this.m_genes[other].execute_float(this, other, args);
    }

    public double execute_double(Object[] args) {
        double rtn = this.m_genes[0].execute_double(this, 0, args);
        this.cleanup();
        return rtn;
    }

    public double execute_double(int n, int child, Object[] args) {
        if (child == 0) {
            return this.m_genes[n + 1].execute_double(this, n + 1, args);
        }
        int other = this.getChild(n, child);
        return this.m_genes[other].execute_double(this, other, args);
    }

    public Object execute_object(Object[] args) {
        Object rtn = this.m_genes[0].execute_object(this, 0, args);
        this.cleanup();
        return rtn;
    }

    public Object execute_object(int n, int child, Object[] args) {
        if (child == 0) {
            return this.m_genes[n + 1].execute_object(this, n + 1, args);
        }
        int other = this.getChild(n, child);
        return this.m_genes[other].execute_object(this, other, args);
    }

    public Object execute(Object[] args) {
        return this.m_genes[0].execute_object(this, 0, args);
    }

    public Object execute(int n, int child, Object[] args) {
        return this.execute_object(n, child, args);
    }

    public void setGene(int index, CommandGene a_gene) {
        if (a_gene == null) {
            throw new IllegalArgumentException("Gene must not be null!");
        }
        this.m_genes[index] = a_gene;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    public int getArity() {
        return this.argTypes.length;
    }

    public int size() {
        int i;
        for (i = 0; i < this.m_genes.length && this.m_genes[i] != null; ++i) {
        }
        return i;
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        int size = this.size();
        ProgramChromosome otherChromosome = (ProgramChromosome)a_other;
        CommandGene[] otherGenes = otherChromosome.m_genes;
        if (otherChromosome.size() != size) {
            return this.size() - otherChromosome.size();
        }
        for (int i = 0; i < size; ++i) {
            int comparison = this.m_genes[i].compareTo(otherGenes[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        if (this.isCompareApplicationData()) {
            if (this.getApplicationData() == null) {
                if (otherChromosome.getApplicationData() != null) {
                    return -1;
                }
            } else {
                if (otherChromosome.getApplicationData() == null) {
                    return 1;
                }
                if (this.getApplicationData() instanceof Comparable) {
                    try {
                        return ((Comparable)this.getApplicationData()).compareTo(otherChromosome.getApplicationData());
                    }
                    catch (ClassCastException cex) {
                        return -1;
                    }
                }
                return this.getApplicationData().getClass().getName().compareTo(otherChromosome.getApplicationData().getClass().getName());
            }
        }
        return 0;
    }

    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public void setCompareApplicationData(boolean a_doCompare) {
        this.m_compareAppData = a_doCompare;
    }

    public boolean isCompareApplicationData() {
        return this.m_compareAppData;
    }

    public Object getApplicationData() {
        return this.m_applicationData;
    }

    public synchronized CommandGene getGene(int a_locus) {
        return this.m_genes[a_locus];
    }

    private CommandGene[] remove(CommandGene[] a_functionSet, CommandGene node) {
        int size = a_functionSet.length;
        for (int i = 0; i < size; ++i) {
            if (a_functionSet[i] != node) continue;
            CommandGene[] result = new CommandGene[size - 1];
            if (i > 0) {
                System.arraycopy(a_functionSet, 0, result, 0, i);
            }
            if (size - i > 1) {
                System.arraycopy(a_functionSet, i + 1, result, i, size - i - 1);
            }
            return result;
        }
        return a_functionSet;
    }

    protected String encode(String a_string) {
        return StringKit.encode(a_string);
    }

    protected String decode(String a_string) {
        return StringKit.decode(a_string);
    }

    @Override
    public String getPersistentRepresentation() {
        StringBuffer b = new StringBuffer();
        for (CommandGene gene : this.m_genes) {
            if (gene == null) break;
            b.append(GENE_DELIMITER_HEADING);
            b.append(this.encode(gene.getClass().getName() + GENE_DELIMITER + gene.getPersistentRepresentation()));
            b.append(GENE_DELIMITER_CLOSING);
        }
        return b.toString();
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            try {
                List r = ProgramChromosome.split(a_representation);
                Iterator iter = r.iterator();
                Vector<CommandGene> genes = new Vector<CommandGene>();
                while (iter.hasNext()) {
                    String g = this.decode((String)iter.next());
                    StringTokenizer st = new StringTokenizer(g, GENE_DELIMITER);
                    if (st.countTokens() != 2) {
                        throw new UnsupportedRepresentationException("In " + g + ", " + "expecting two tokens, separated by " + GENE_DELIMITER);
                    }
                    String clas = st.nextToken();
                    String representation = st.nextToken();
                    CommandGene gene = this.createGene(clas, representation);
                    genes.add(gene);
                }
                this.m_genes = genes.toArray(new CommandGene[0]);
            }
            catch (Exception ex) {
                throw new UnsupportedRepresentationException(ex.toString());
            }
        }
    }

    protected CommandGene createGene(String a_geneClassName, String a_persistentRepresentation) throws Exception {
        Class<?> geneClass = Class.forName(a_geneClassName);
        Constructor<?> constr = geneClass.getConstructor(GPConfiguration.class);
        CommandGene gene = (CommandGene)constr.newInstance(this.getGPConfiguration());
        gene.setValueFromPersistentRepresentation(a_persistentRepresentation);
        return gene;
    }

    protected static final List split(String a_string) throws UnsupportedRepresentationException {
        List<String> a = Collections.synchronizedList(new ArrayList());
        StringTokenizer st = new StringTokenizer(a_string, "<>", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(GENE_DELIMITER_HEADING)) {
                throw new UnsupportedRepresentationException(a_string + " no opening tag");
            }
            String n = st.nextToken();
            if (n.equals(GENE_DELIMITER_CLOSING)) {
                a.add("");
                continue;
            }
            a.add(n);
            if (st.nextToken().equals(GENE_DELIMITER_CLOSING)) continue;
            throw new UnsupportedRepresentationException(a_string + " no closing tag");
        }
        return a;
    }
}

