/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.io.Serializable;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.CrossMethod;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.function.SubProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.ProgramChromosome;

public class BranchTypingCross
extends CrossMethod
implements Serializable,
Comparable,
Cloneable {
    private static final String CVS_REVISION = "$Revision: 1.19 $";
    private boolean m_simpleChromosomeSelection;

    public BranchTypingCross(GPConfiguration a_config) {
        this(a_config, false);
    }

    public BranchTypingCross(GPConfiguration a_config, boolean a_simpleChromosomeSelection) {
        super(a_config);
        this.m_simpleChromosomeSelection = a_simpleChromosomeSelection;
    }

    @Override
    public IGPProgram[] operate(IGPProgram a_i1, IGPProgram a_i2) {
        try {
            int chromosomeNum;
            int i;
            if (!this.m_simpleChromosomeSelection) {
                int[] sizes = new int[a_i1.size()];
                int totalSize = 0;
                for (i = 0; i < a_i1.size(); ++i) {
                    sizes[i] = a_i1.getChromosome(i).getSize(0);
                    totalSize += sizes[i];
                }
                int nodeNum = this.getConfiguration().getRandomGenerator().nextInt(totalSize);
                for (chromosomeNum = 0; chromosomeNum < a_i1.size() && (nodeNum -= sizes[chromosomeNum]) >= 0; ++chromosomeNum) {
                }
            } else {
                chromosomeNum = this.getConfiguration().getRandomGenerator().nextInt(a_i1.size());
            }
            ProgramChromosome[] newChromosomes = this.doCross(a_i1.getChromosome(chromosomeNum), a_i2.getChromosome(chromosomeNum));
            IGPProgram[] newIndividuals = new IGPProgram[]{new GPProgram(a_i1), new GPProgram(a_i1)};
            for (i = 0; i < a_i1.size(); ++i) {
                if (i != chromosomeNum) {
                    newIndividuals[0].setChromosome(i, a_i1.getChromosome(i));
                    newIndividuals[1].setChromosome(i, a_i2.getChromosome(i));
                    continue;
                }
                newIndividuals[0].setChromosome(i, newChromosomes[0]);
                newIndividuals[1].setChromosome(i, newChromosomes[1]);
            }
            return newIndividuals;
        }
        catch (InvalidConfigurationException iex) {
            return null;
        }
    }

    protected ProgramChromosome[] doCross(ProgramChromosome a_c0, ProgramChromosome a_c1) throws InvalidConfigurationException {
        int p1;
        int p0;
        ProgramChromosome[] c = new ProgramChromosome[]{a_c0, a_c1};
        RandomGenerator random = this.getConfiguration().getRandomGenerator();
        if ((double)random.nextFloat() < this.getConfiguration().getFunctionProb()) {
            int nf = a_c0.numFunctions();
            if (nf == 0) {
                return c;
            }
            int fctIndex = random.nextInt(nf);
            p0 = a_c0.getFunction(fctIndex);
        } else {
            IMutateable term;
            p0 = a_c0.getTerminal(random.nextInt(a_c0.numTerminals()));
            CommandGene command = a_c0.getNode(p0);
            if (random.nextDouble() <= this.getConfiguration().getMutationProb() && IMutateable.class.isInstance(command) && (command = (term = (IMutateable)((Object)command)).applyMutation(0, 0.3)) != null && a_c0.getCommandOfClass(0, command.getClass()) >= 0) {
                a_c0.setGene(p0, command);
            }
        }
        CommandGene nodeP0 = a_c0.getNode(p0);
        Class type_ = nodeP0.getReturnType();
        int subType = nodeP0.getSubReturnType();
        if ((double)random.nextFloat() < this.getConfiguration().getFunctionProb()) {
            int nf = a_c1.numFunctions(type_, subType);
            if (nf == 0) {
                return c;
            }
            p1 = a_c1.getFunction(random.nextInt(nf), type_, subType);
        } else {
            IMutateable term;
            int nt = a_c1.numTerminals(type_, subType);
            if (nt == 0) {
                return c;
            }
            p1 = a_c1.getTerminal(random.nextInt(a_c1.numTerminals(type_, subType)), type_, subType);
            CommandGene command = a_c1.getNode(p1);
            if (random.nextDouble() <= this.getConfiguration().getMutationProb() && IMutateable.class.isInstance(command) && (command = (term = (IMutateable)((Object)command)).applyMutation(0, 0.3)) != null && a_c0.getCommandOfClass(0, command.getClass()) >= 0) {
                a_c1.setGene(p1, command);
            }
        }
        if (SubProgram.class.isAssignableFrom(a_c1.getFunctions()[p1].getClass())) {
            ((IMutateable)((Object)a_c1.getFunctions()[p1])).applyMutation(0, 0.5);
        }
        int s0 = a_c0.getSize(p0);
        int s1 = a_c1.getSize(p1);
        int d0 = a_c0.getDepth(p0);
        int d1 = a_c1.getDepth(p1);
        int c0s = a_c0.getSize(0);
        int c1s = a_c1.getSize(0);
        if (d0 - 1 + d1 > this.getConfiguration().getMaxCrossoverDepth() || c0s - p0 - s0 < 0 || p0 + s1 + c0s - p0 - s0 >= a_c0.getFunctions().length) {
            c[0] = a_c1;
        } else {
            c[0] = new ProgramChromosome(this.getConfiguration(), a_c0.getFunctions().length, c[0].getFunctionSet(), c[0].getArgTypes(), a_c0.getIndividual());
            System.arraycopy(a_c0.getFunctions(), 0, c[0].getFunctions(), 0, p0);
            System.arraycopy(a_c1.getFunctions(), p1, c[0].getFunctions(), p0, s1);
            System.arraycopy(a_c0.getFunctions(), p0 + s0, c[0].getFunctions(), p0 + s1, c0s - p0 - s0);
            c[0].redepth();
        }
        if (d1 - 1 + d0 > this.getConfiguration().getMaxCrossoverDepth() || c1s - p1 - s1 < 0 || p1 + s0 + c1s - p1 - s1 >= a_c1.getFunctions().length) {
            c[1] = a_c0;
        } else {
            c[1] = new ProgramChromosome(this.getConfiguration(), a_c1.getFunctions().length, c[1].getFunctionSet(), c[1].getArgTypes(), a_c1.getIndividual());
            System.arraycopy(a_c1.getFunctions(), 0, c[1].getFunctions(), 0, p1);
            System.arraycopy(a_c0.getFunctions(), p0, c[1].getFunctions(), p1, s0);
            System.arraycopy(a_c1.getFunctions(), p1 + s1, c[1].getFunctions(), p1 + s0, c1s - p1 - s1);
            c[1].redepth();
        }
        return c;
    }

    public int compareTo(Object a_other) {
        BranchTypingCross other = (BranchTypingCross)a_other;
        if (other == null) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object a_other) {
        try {
            BranchTypingCross other = (BranchTypingCross)a_other;
            return other != null;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        BranchTypingCross result = new BranchTypingCross(this.getConfiguration());
        return result;
    }
}

