/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.impl.GPConfiguration;

public abstract class CommandDynamicArity
extends CommandGene {
    private static final String CVS_REVISION = "$Revision: 1.2 $";

    public CommandDynamicArity() throws Exception {
    }

    public CommandDynamicArity(GPConfiguration a_conf, int a_arityInitial, int a_arityMin, int a_arityMax, Class a_returnType) throws InvalidConfigurationException {
        this(a_conf, a_arityInitial, a_arityMin, a_arityMax, a_returnType, 0);
    }

    public CommandDynamicArity(GPConfiguration a_conf, int a_arityInitial, int a_arityMin, int a_arityMax, Class a_returnType, int a_subReturnType) throws InvalidConfigurationException {
        this(a_conf, a_arityInitial, a_arityMin, a_arityMax, a_returnType, a_subReturnType, null);
    }

    public CommandDynamicArity(GPConfiguration a_conf, int a_arityInitial, int a_arityMin, int a_arityMax, Class a_returnType, int a_subReturnType, int[] a_subChildTypes) throws InvalidConfigurationException {
        super(a_conf, a_arityInitial, a_returnType, a_subReturnType, a_subChildTypes);
        if (a_arityMin < 1) {
            throw new RuntimeException("Minimum arity must not be less than one!");
        }
        if (a_arityMax < a_arityMin) {
            throw new RuntimeException("Minimum arity must be less than maximum arity!");
        }
        if (a_arityInitial < a_arityMin || a_arityInitial > a_arityMax) {
            throw new RuntimeException("Initial arity must be between minimum and maximum arity!");
        }
        this.setArityMin(a_arityMin);
        this.setArityMax(a_arityMax);
    }

    @Override
    public void dynamizeArity() {
        int arity = this.getArityMin() + this.getGPConfiguration().getRandomGenerator().nextInt(this.getArityMax() - this.getArityMin() + 1);
        this.setArity(arity);
    }
}

