/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.data.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.jgap.data.config.ConfigData;
import org.jgap.data.config.IConfigInfo;

public final class ConfigWriter {
    private static final String CVS_REVISION = "$Revision: 1.8 $";
    private static ConfigWriter m_cWriter;
    private Properties m_config = new Properties();

    public static ConfigWriter getInstance() {
        if (m_cWriter == null) {
            m_cWriter = new ConfigWriter();
        }
        return m_cWriter;
    }

    private ConfigWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IConfigInfo a_cInfo) {
        String name;
        ConfigData cd = a_cInfo.getConfigData();
        String nsPrefix = cd.getNS() + ".";
        for (int i = 0; i < cd.getNumLists(); ++i) {
            name = cd.getListNameAt(i);
            List values = cd.getListValuesAt(i);
            int idx = 0;
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String tmpName = name + "[" + idx + "]";
                tmpName = nsPrefix + tmpName;
                this.m_config.setProperty(tmpName, (String)iter.next());
                ++idx;
            }
        }
        String value = "";
        String tmpName = "";
        for (int i = 0; i < cd.getNumTexts(); ++i) {
            name = cd.getTextNameAt(i);
            value = cd.getTextValueAt(i);
            tmpName = nsPrefix + name;
            this.m_config.setProperty(tmpName, value);
        }
        try (FileOutputStream out = new FileOutputStream(a_cInfo.getFileName());){
            this.m_config.store(out, "---JGAP Configuration File---");
        }
        catch (IOException ioEx) {
            JOptionPane.showMessageDialog(null, "Exception " + ioEx.getMessage(), "Configuration Exception", 1);
            ioEx.printStackTrace();
        }
    }
}

