/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgap.audit.KeyedValue;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class KeyedValues
implements ICloneable,
Serializable {
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private List m_data = Collections.synchronizedList(new ArrayList());

    public int size() {
        return this.m_data.size();
    }

    public Number getValue(int a_index) {
        KeyedValue kval = (KeyedValue)this.m_data.get(a_index);
        Number result = kval != null ? (Number)kval.getValue() : (Number)null;
        return result;
    }

    public Comparable getKey(int a_index) {
        KeyedValue item = (KeyedValue)this.m_data.get(a_index);
        Comparable result = item != null ? item.getKey() : null;
        return result;
    }

    public int getIndex(Comparable a_key) {
        int i = 0;
        for (KeyedValue kv : this.m_data) {
            if (kv.getKey() != null ? kv.getKey().equals(a_key) : a_key == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List getKeys() {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        for (KeyedValue kv : this.m_data) {
            result.add(kv.getKey());
        }
        return result;
    }

    public Number getValue(Comparable a_key) {
        int index = this.getIndex(a_key);
        Number result = index >= 0 ? (Number)this.getValue(index) : (Number)null;
        return result;
    }

    public void setValue(Comparable a_key, Number a_value) {
        int keyIndex = this.getIndex(a_key);
        if (keyIndex >= 0) {
            KeyedValue kv = (KeyedValue)this.m_data.get(keyIndex);
            kv.setValue(a_value);
        } else {
            KeyedValue kv = new KeyedValue(a_key, a_value);
            this.m_data.add(kv);
        }
    }

    public boolean equals(Object a_obj) {
        if (a_obj == null) {
            return false;
        }
        if (a_obj == this) {
            return true;
        }
        if (!(a_obj instanceof KeyedValues)) {
            return false;
        }
        KeyedValues kvs = (KeyedValues)a_obj;
        int count = this.size();
        if (count != kvs.size()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Comparable k2;
            Comparable k1 = this.getKey(i);
            if (!k1.equals(k2 = kvs.getKey(i))) {
                return false;
            }
            Number v1 = this.getValue(i);
            Number v2 = kvs.getValue(i);
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.m_data.size() == 0) {
            return -29;
        }
        return this.m_data.hashCode();
    }

    @Override
    public Object clone() {
        try {
            KeyedValues clone = (KeyedValues)super.clone();
            clone.m_data = Collections.synchronizedList(new ArrayList());
            for (KeyedValue kv : this.m_data) {
                clone.m_data.add(kv.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cex) {
            throw new CloneException(cex);
        }
    }
}

