/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import org.hecl.net.HttpRequest;
import org.hecl.net.QueryParam;

class MyHttpConn {
    HttpURLConnection conn = null;
    boolean secure = false;
    InputStream is = null;
    OutputStream os = null;

    MyHttpConn(String url) throws IOException {
        this.secure = url.toLowerCase().startsWith("https");
        if (HttpRequest.DEBUGURL) {
            System.err.println("url=" + url);
        }
        URL myurl = new URL(url);
        this.conn = this.secure ? (HttpsURLConnection)myurl.openConnection() : (HttpURLConnection)myurl.openConnection();
    }

    void connect(String rm, Hashtable rfields, String qdata, QueryParam[] qparams) throws IOException {
        this.conn.setRequestMethod(rm);
        Enumeration e = rfields.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.conn.setRequestProperty(key, (String)rfields.get(key));
        }
        if (qdata != null || qparams != null) {
            this.conn.setDoOutput(true);
        }
        this.conn.connect();
        if (qdata != null || qparams != null) {
            this.os = this.conn.getOutputStream();
            if (qdata != null) {
                this.os.write(qdata.getBytes());
            } else if (qparams != null) {
                for (int i = 0; i < qparams.length; ++i) {
                    if (i != 0) {
                        this.os.write(38);
                    }
                    qparams[i].send(this.os);
                }
            }
            this.os.flush();
            this.os.close();
            this.os = null;
        }
    }

    int getResponseCode() {
        try {
            return this.conn.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    Hashtable readHeader() {
        Hashtable<String, String> tab = new Hashtable<String, String>();
        int idx = 0;
        if (this.conn.getHeaderFieldKey(0) == null) {
            ++idx;
        }
        String key = "";
        while (key != null) {
            if ((key = this.conn.getHeaderFieldKey(idx++)) == null) continue;
            tab.put(key.toLowerCase(), this.conn.getHeaderField(key));
        }
        return tab;
    }

    byte[] readBody() throws IOException {
        int bytesread;
        int len = 0;
        byte[] buf = new byte[]{};
        this.is = this.conn.getInputStream();
        len = this.conn.getContentLength();
        int actual = 0;
        if (len >= 0) {
            buf = new byte[len];
            for (bytesread = 0; bytesread != len && actual != -1; bytesread += actual) {
                actual = this.is.read(buf, bytesread, len - bytesread);
            }
        } else {
            buf = new byte[512];
            do {
                if (bytesread == buf.length) {
                    byte[] newbuf = new byte[buf.length + 512];
                    System.arraycopy(buf, 0, newbuf, 0, bytesread);
                    buf = newbuf;
                }
                if ((actual = this.is.read(buf, bytesread, buf.length - bytesread)) <= 0) continue;
                bytesread += actual;
            } while (actual > 0);
        }
        if (bytesread != buf.length) {
            byte[] tmp = new byte[buf.length];
            System.arraycopy(buf, 0, tmp, 0, bytesread);
            buf = tmp;
        }
        return buf;
    }

    void close() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }
}

