/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.net;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.hecl.net.MyHttpConn;
import org.hecl.net.QueryParam;

public class HttpRequest
extends Thread {
    public static final short SETUP = 0;
    public static final short CONNECTED = 1;
    public static final short ERROR = 2;
    public static final short TIMEOUT = 3;
    public static final short OK = 4;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_FORBIDDEN = 403;
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    private String urlstr = null;
    private byte[] inData = null;
    private String body = "";
    private String qdata = null;
    private QueryParam[] qparams = null;
    private String requestMethod = "GET";
    private int rc = -1;
    private short status = 0;
    Exception error = null;
    private Hashtable requestFields = new Hashtable();
    private Hashtable responseFields = new Hashtable();
    private static String[] urlencodemap = new String[256];
    private static String validUrlChars = "-_.!~*'()\"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final char[] hexchars = new String("0123456789ABCDEF").toCharArray();
    public static boolean DEBUGURL = false;
    public static boolean DEBUGRC = false;
    public static boolean DEBUGBODY = false;
    public static String DEFCHARSET = "ISO8859-1";
    public static final String CONTENTTYPE = "content-type";
    public static final String CONTENTENCODING = "content-encoding";
    private static final String[] ISOALIASES = new String[]{"iso-8859-1", "iso8859-1", "iso8859_1", "iso_8859_1", "iso-8859_1", "iso_8859-1"};

    public HttpRequest(String url, QueryParam[] params, boolean validate, Hashtable headerfields) {
        this.qparams = params;
        this.setup(url, validate, headerfields);
    }

    public HttpRequest(String url, String queryData, boolean validate, Hashtable headerfields) {
        this.qdata = queryData;
        this.setup(url, validate, headerfields);
    }

    private void setup(String url, boolean validate, Hashtable headerfields) {
        this.urlstr = url;
        if (headerfields != null) {
            Enumeration e = headerfields.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.requestFields.put(key, (String)headerfields.get(key));
            }
        }
        if (this.qdata != null || this.qparams != null) {
            this.requestMethod = POST;
        } else if (validate) {
            this.requestMethod = HEAD;
        }
    }

    public void addRequestField(String key, String value) {
        this.requestFields.put(key, value);
    }

    public String getResponseFieldValue(String key) {
        return (String)this.responseFields.get(key);
    }

    public Enumeration getResponseFieldNames() {
        return this.responseFields.keys();
    }

    public String getURL() {
        return this.urlstr;
    }

    public static String hexdump(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            sb.append(Integer.toHexString((b & 0xF0) >> 4));
            sb.append(Integer.toHexString(b & 0xF));
            sb.append(' ');
            if (i != 0 && (i + 1) % 8 == 0) {
                sb.append(' ');
            }
            if (i == 0 || (i + 1) % 16 != 0) continue;
            sb.append('\n');
        }
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        return new String(sb);
    }

    @Override
    public synchronized void run() {
        MyHttpConn co;
        block24: {
            co = null;
            this.rc = -1;
            this.error = null;
            this.inData = null;
            try {
                co = new MyHttpConn(this.urlstr);
            }
            catch (IOException e) {
                this.status = (short)2;
                this.error = e;
                e.printStackTrace();
                System.err.println("HttpRequest.preparation error");
                return;
            }
            try {
                if (DEBUGRC) {
                    System.err.println("Connecting...");
                }
                co.connect(this.requestMethod, this.requestFields, this.qdata, this.qparams);
                this.status = 1;
                if (DEBUGRC) {
                    System.err.println("Connected");
                }
                this.rc = co.getResponseCode();
                if (DEBUGRC) {
                    System.err.println("rc=" + this.rc);
                }
                if (this.rc == -1) {
                    this.status = (short)2;
                    return;
                }
                this.responseFields = co.readHeader();
                this.inData = co.readBody();
                this.status = (short)4;
                String charset = DEFCHARSET;
                String ct = (String)this.responseFields.get(CONTENTTYPE);
                String coding = (String)this.responseFields.get(CONTENTENCODING);
                if (ct == null) {
                    ct = "text/plain";
                    this.responseFields.put(CONTENTTYPE, ct);
                }
                if (ct != null && !ct.toLowerCase().startsWith("text") || coding != null && (coding.indexOf("gzip") >= 0 || coding.indexOf("compress") >= 0)) {
                    this.responseFields.put("binary", "1");
                } else {
                    int begin;
                    this.responseFields.put("binary", "0");
                    if (ct != null && (begin = ct.toLowerCase().indexOf("charset=")) >= 0) {
                        int end = ct.indexOf(59, begin += 8);
                        if (end == -1) {
                            end = ct.length();
                        }
                        charset = ct.substring(begin, end);
                    }
                }
                if (charset == DEFCHARSET || this.isISOCharset(charset)) {
                    this.body = HttpRequest.bytesToString(this.inData, 0, this.inData.length);
                    charset = DEFCHARSET;
                    this.responseFields.put("charset", charset);
                    break block24;
                }
                for (int i = 0; i < 3; ++i) {
                    switch (i) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            charset = charset.toLowerCase();
                            break;
                        }
                        case 2: {
                            charset = charset.toUpperCase();
                        }
                    }
                    this.responseFields.put("charset", charset);
                    try {
                        this.body = new String(this.inData, charset);
                        break;
                    }
                    catch (Exception e2) {
                        this.body = "xxx-encoding-failed-xxx\n" + e2.getMessage();
                        continue;
                    }
                }
            }
            catch (Exception e) {
                this.status = (short)2;
                this.error = e;
                e.printStackTrace();
            }
        }
        if (DEBUGBODY) {
            System.err.println(this.getBody());
        }
        if (co != null) {
            co.close();
        }
        this.inData = null;
    }

    public static byte[] asISOBytes(String s) {
        byte[] buf = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            buf[i] = (byte)ch;
        }
        return buf;
    }

    public static String bytesToString(byte[] buf) {
        return HttpRequest.bytesToString(buf, 0, buf.length);
    }

    public static String bytesToString(byte[] buf, int start, int n) {
        return HttpRequest.bytesToStringBuffer(buf, start, n).toString();
    }

    public static StringBuffer bytesToStringBuffer(byte[] buf) {
        return HttpRequest.bytesToStringBuffer(buf, 0, buf.length);
    }

    public static StringBuffer bytesToStringBuffer(byte[] buf, int start, int n) {
        StringBuffer sb = new StringBuffer(buf.length);
        int i = start;
        while (n > 0) {
            sb.append((char)buf[i]);
            ++i;
            --n;
        }
        return sb;
    }

    public int getStatus() {
        return this.status;
    }

    public Exception getException() {
        return this.error;
    }

    public String getBody() {
        return this.body;
    }

    public byte[] getBytes() {
        return this.inData;
    }

    public int getRC() {
        return this.rc;
    }

    public static String getStatusText(int status) {
        switch (status) {
            case 0: {
                return "setup";
            }
            case 1: {
                return "connected";
            }
            case 2: {
                return "error";
            }
            case 3: {
                return "timeout";
            }
            case 4: {
                return "ok";
            }
        }
        return "unknown";
    }

    public static byte[] IRIencode(String str) {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        byte[] bytearr = new byte[utflen];
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return bytearr;
    }

    public static String urlencode(byte[] s, int start, int n) {
        StringBuffer b = new StringBuffer();
        int i = start;
        while (n > 0) {
            b.append(urlencodemap[s[i] & 0xFF]);
            ++i;
            --n;
        }
        return b.toString();
    }

    public static String urlencode(byte[] s) {
        return HttpRequest.urlencode(s, 0, s.length);
    }

    public static String urlencode(String[] elems) {
        if (elems == null || elems.length == 0) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                if (i > 0) {
                    b.append(i % 2 != 0 ? (char)'=' : '&');
                }
                b.append(HttpRequest.urlencode(HttpRequest.IRIencode(elems[i])));
            }
        }
        return b.toString();
    }

    private boolean isISOCharset(String charset) {
        String lower = charset.toLowerCase();
        for (int i = 0; i < ISOALIASES.length; ++i) {
            if (!lower.equals(ISOALIASES[i])) continue;
            return true;
        }
        return false;
    }

    static {
        char[] cbuf = new char[3];
        for (int i = 0; i < 256; ++i) {
            char ch = (char)i;
            int idx = validUrlChars.indexOf(ch);
            if (idx >= 0) {
                HttpRequest.urlencodemap[i] = validUrlChars.substring(idx, idx + 1);
                continue;
            }
            cbuf[0] = 37;
            cbuf[1] = hexchars[(i & 0xF0) >> 4];
            cbuf[2] = hexchars[i & 0xF];
            HttpRequest.urlencodemap[i] = new String(cbuf);
        }
        HttpRequest.urlencodemap[32] = "+";
    }
}

