/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Vector;
import org.hecl.Command;
import org.hecl.Compare;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.MathCmds;
import org.hecl.Properties;
import org.hecl.Thing;

class SortCmd
implements Command {
    private int sortalgorithm = 0;
    private Thing sortproc = null;
    private Interp localinterp = null;

    SortCmd() {
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        Vector v = ListThing.get(argv[1]);
        this.localinterp = interp;
        this.sortalgorithm = 2;
        this.sortproc = null;
        Properties p = new Properties(new Object[]{"by", new Thing("string")});
        p.setProps(argv, 2);
        String sortby = p.getProp("by").toString();
        if (sortby.equals("int")) {
            this.sortalgorithm = 1;
        } else if (sortby.equals("proc")) {
            this.sortalgorithm = 3;
            this.sortproc = p.getProp("command");
        }
        if (v.size() != 0) {
            v = this.quicksort(v, 0, v.size() - 1);
        }
        return ListThing.create(v);
    }

    private Vector quicksort(Vector a, int lo, int hi) throws HeclException {
        int i = lo;
        int j = hi;
        Thing x = (Thing)a.elementAt((lo + hi) / 2);
        do {
            if (this.sortalgorithm == 1) {
                while (MathCmds.compare((Thing)a.elementAt(i), x) < 0) {
                    ++i;
                }
                while (MathCmds.compare((Thing)a.elementAt(j), x) > 0) {
                    --j;
                }
            } else if (this.sortalgorithm == 2) {
                while (Compare.compareString((Thing)a.elementAt(i), x) < 0) {
                    ++i;
                }
                while (Compare.compareString((Thing)a.elementAt(j), x) > 0) {
                    --j;
                }
            } else if (this.sortalgorithm == 3) {
                int vsz = a.size();
                while (Compare.compareProc((Thing)a.elementAt(i), x, this.localinterp, this.sortproc) < 0 && i < vsz) {
                    ++i;
                }
                while (Compare.compareProc((Thing)a.elementAt(j), x, this.localinterp, this.sortproc) > 0 && j > 0) {
                    --j;
                }
            }
            if (i > j) continue;
            Thing h = (Thing)a.elementAt(i);
            a.setElementAt(a.elementAt(j), i);
            a.setElementAt(h, j);
            ++i;
            --j;
        } while (i <= j);
        if (lo < j) {
            a = this.quicksort(a, lo, j);
        }
        if (i < hi && i > lo) {
            a = this.quicksort(a, i, hi);
        }
        return a;
    }
}

