/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.IntegralThing;
import org.hecl.Interp;
import org.hecl.LongThing;
import org.hecl.NumberThing;
import org.hecl.Operator;
import org.hecl.Thing;

public class MathCmds
extends Operator {
    public static final Thing E = new Thing(new DoubleThing(Math.E));
    public static final Thing PI = new Thing(new DoubleThing(Math.PI));
    public static final int CASTINT = 1;
    public static final int CASTLONG = 2;
    public static final int CASTFLOAT = 3;
    public static final int CASTDOUBLE = 4;
    public static final int TODEGREES = 5;
    public static final int TORADIANS = 6;
    public static final int ABS = 7;
    public static final int SQRT = 8;
    public static final int LOG = 9;
    public static final int SIN = 10;
    public static final int COS = 11;
    public static final int TAN = 12;
    public static final int ASIN = 13;
    public static final int ACOS = 14;
    public static final int ATAN = 15;
    public static final int EXP = 16;
    public static final int FLOOR = 17;
    public static final int CEIL = 18;
    public static final int POW = 19;
    public static final int RANDOM = 20;
    public static final int ROUND = 21;
    public static final int MIN = 22;
    public static final int MAX = 23;
    public static final int SIGNUM = 30;
    public static final int CBRT = 31;
    public static final int LOG10 = 32;
    public static final int LOG1P = 33;
    public static final int SINH = 34;
    public static final int COSH = 35;
    public static final int TANH = 36;
    public static final int EXPM1 = 37;
    public static final int HYPOT = 38;
    public static final int INCR = 50;
    public static final int DECR = 51;
    public static final int TRUE = 52;
    public static final int FALSE = 53;
    public static final int NOT = 80;
    public static final int AND = 81;
    public static final int OR = 82;
    public static final int EQ = 90;
    public static final int NEQ = 91;
    public static final int LT = 92;
    public static final int LE = 93;
    public static final int GT = 94;
    public static final int GE = 95;
    public static final int BINADD = 100;
    public static final int BINSUB = 101;
    public static final int BINMUL = 102;
    public static final int BINDIV = 103;
    public static final int MOD = 104;
    public static final int PLUS = 105;
    public static final int MINUS = 106;
    public static final int MUL = 107;
    private static int nextop = 1000;
    private static Hashtable vars = new Hashtable();
    private static Hashtable extensions = new Hashtable();
    private static Hashtable cmdtable = new Hashtable();

    public static int compare(Thing a, Thing b) {
        return MathCmds.compare(NumberThing.asNumber(a), NumberThing.asNumber(b));
    }

    public static int compare(NumberThing a, NumberThing b) {
        if (a.isIntegral() && b.isIntegral()) {
            if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                return MathCmds.compare(a.longValue(), b.longValue());
            }
            return MathCmds.compare(a.intValue(), b.intValue());
        }
        return MathCmds.compare(a.doubleValue(), b.doubleValue());
    }

    public static Thing unary(int cmdcode, Interp ip, NumberThing a) throws HeclException {
        switch (cmdcode) {
            case 1: {
                return IntThing.create(a.intValue());
            }
            case 2: {
                return LongThing.create(a.longValue());
            }
            case 3: 
            case 4: {
                return DoubleThing.create(a.doubleValue());
            }
            case 5: {
                return DoubleThing.create(Math.toDegrees(a.doubleValue()));
            }
            case 6: {
                return DoubleThing.create(Math.toRadians(a.doubleValue()));
            }
            case 7: {
                if (a.isIntegral()) {
                    IntegralThing i = (IntegralThing)a;
                    if (i.isLong()) {
                        return LongThing.create(Math.abs(i.longValue()));
                    }
                    return IntThing.create(Math.abs(i.intValue()));
                }
                return DoubleThing.create(Math.abs(a.doubleValue()));
            }
            case 10: {
                return DoubleThing.create(Math.sin(a.doubleValue()));
            }
            case 11: {
                return DoubleThing.create(Math.cos(a.doubleValue()));
            }
            case 12: {
                return DoubleThing.create(Math.tan(a.doubleValue()));
            }
            case 8: {
                return DoubleThing.create(Math.sqrt(a.doubleValue()));
            }
            case 17: {
                return DoubleThing.create(Math.floor(a.doubleValue()));
            }
            case 18: {
                return DoubleThing.create(Math.ceil(a.doubleValue()));
            }
            case 21: {
                if (a.isIntegral()) {
                    return new Thing(a.deepcopy());
                }
                long l = Math.round(a.doubleValue());
                if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    return IntThing.create((int)l);
                }
                return LongThing.create(l);
            }
            case 50: {
                return MathCmds.binary(100, ip, a, IntThing.ONE);
            }
            case 51: {
                return MathCmds.binary(101, ip, a, IntThing.ONE);
            }
            case 80: {
                return MathCmds.boolres(a.intValue() == 0);
            }
            case 9: {
                return DoubleThing.create(Math.log(a.doubleValue()));
            }
            case 13: {
                return DoubleThing.create(Math.asin(a.doubleValue()));
            }
            case 14: {
                return DoubleThing.create(Math.acos(a.doubleValue()));
            }
            case 15: {
                return DoubleThing.create(Math.atan(a.doubleValue()));
            }
            case 16: {
                return DoubleThing.create(Math.exp(a.doubleValue()));
            }
            case 30: {
                return DoubleThing.create(Math.signum(a.doubleValue()));
            }
            case 31: {
                return DoubleThing.create(Math.cbrt(a.doubleValue()));
            }
            case 32: {
                return DoubleThing.create(Math.log10(a.doubleValue()));
            }
            case 33: {
                return DoubleThing.create(Math.log1p(a.doubleValue()));
            }
            case 34: {
                return DoubleThing.create(Math.sinh(a.doubleValue()));
            }
            case 35: {
                return DoubleThing.create(Math.cosh(a.doubleValue()));
            }
            case 36: {
                return DoubleThing.create(Math.tanh(a.doubleValue()));
            }
            case 37: {
                return DoubleThing.create(Math.expm1(a.doubleValue()));
            }
        }
        throw new HeclException("Unknown unary mathcmdcode '" + cmdcode + "'.");
    }

    public static Thing binary(int cmdcode, Interp ip, NumberThing a, NumberThing b) throws HeclException {
        switch (cmdcode) {
            case 100: {
                if (a.isIntegral() && b.isIntegral()) {
                    if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                        return LongThing.create(a.longValue() + b.longValue());
                    }
                    return IntThing.create(a.intValue() + b.intValue());
                }
                return DoubleThing.create(a.doubleValue() + b.doubleValue());
            }
            case 101: {
                if (a.isIntegral() && b.isIntegral()) {
                    if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                        return LongThing.create(a.longValue() - b.longValue());
                    }
                    return IntThing.create(a.intValue() - b.intValue());
                }
                return DoubleThing.create(a.doubleValue() - b.doubleValue());
            }
            case 102: {
                if (a.isIntegral() && b.isIntegral()) {
                    if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                        return LongThing.create(a.longValue() * b.longValue());
                    }
                    return IntThing.create(a.intValue() * b.intValue());
                }
                return DoubleThing.create(a.doubleValue() * b.doubleValue());
            }
            case 103: {
                if (a.isIntegral() && b.isIntegral()) {
                    if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                        return LongThing.create(a.longValue() / b.longValue());
                    }
                    return IntThing.create(a.intValue() / b.intValue());
                }
                return DoubleThing.create(a.doubleValue() / b.doubleValue());
            }
            case 104: {
                if (a.isIntegral() && b.isIntegral()) {
                    if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                        return LongThing.create(a.longValue() % b.longValue());
                    }
                    return IntThing.create(a.intValue() % b.intValue());
                }
                return DoubleThing.create(a.doubleValue() % b.doubleValue());
            }
            case 22: {
                if (a.isIntegral() && b.isIntegral()) {
                    IntegralThing i = (IntegralThing)a;
                    IntegralThing j = (IntegralThing)b;
                    if (i.isLong() && j.isLong()) {
                        return LongThing.create(Math.min(i.longValue(), j.longValue()));
                    }
                    return IntThing.create(Math.min(i.intValue(), j.intValue()));
                }
                return DoubleThing.create(Math.min(a.doubleValue(), b.doubleValue()));
            }
            case 23: {
                if (a.isIntegral() && b.isIntegral()) {
                    IntegralThing i = (IntegralThing)a;
                    IntegralThing j = (IntegralThing)b;
                    if (i.isLong() && j.isLong()) {
                        return LongThing.create(Math.max(i.longValue(), j.longValue()));
                    }
                    return IntThing.create(Math.max(i.intValue(), j.intValue()));
                }
                return DoubleThing.create(Math.max(a.doubleValue(), b.doubleValue()));
            }
            case 81: {
                if (a.isIntegral() && b.isIntegral()) {
                    if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                        return LongThing.create(a.longValue() & b.longValue());
                    }
                    return IntThing.create(a.intValue() & b.intValue());
                }
                throw new HeclException("Integral argument required.");
            }
            case 82: {
                if (a.isIntegral() && b.isIntegral()) {
                    if (((IntegralThing)a).isLong() || ((IntegralThing)b).isLong()) {
                        return LongThing.create(a.longValue() | b.longValue());
                    }
                    return IntThing.create(a.intValue() | b.intValue());
                }
                throw new HeclException("Integral argument required.");
            }
            case 19: {
                return DoubleThing.create(Math.pow(a.doubleValue(), b.doubleValue()));
            }
            case 38: {
                return DoubleThing.create(Math.hypot(a.doubleValue(), b.doubleValue()));
            }
            case 90: {
                return MathCmds.boolres(MathCmds.compare(a, b) == 0);
            }
            case 91: {
                return MathCmds.boolres(MathCmds.compare(a, b) != 0);
            }
            case 92: {
                return MathCmds.boolres(MathCmds.compare(a, b) < 0);
            }
            case 93: {
                return MathCmds.boolres(MathCmds.compare(a, b) <= 0);
            }
            case 94: {
                return MathCmds.boolres(MathCmds.compare(a, b) > 0);
            }
            case 95: {
                return MathCmds.boolres(MathCmds.compare(a, b) >= 0);
            }
        }
        throw new HeclException("Unknown binary mathcmdcode '" + cmdcode + "'.");
    }

    private static Thing boolres(boolean res) {
        return new Thing(res ? IntThing.ONE : IntThing.ZERO);
    }

    @Override
    public Thing operate(int cmdcode, Interp ip, Thing[] argv) throws HeclException {
        NumberThing num = null;
        if (1 == this.minargs && 1 == this.maxargs) {
            return MathCmds.unary(cmdcode, ip, NumberThing.asNumber(argv[1]));
        }
        if (2 == this.minargs && 2 == this.maxargs) {
            return MathCmds.binary(cmdcode, ip, NumberThing.asNumber(argv[1]), NumberThing.asNumber(argv[2]));
        }
        switch (cmdcode) {
            case 105: {
                num = IntThing.ZERO;
                for (int i = 1; i < argv.length; ++i) {
                    num = (NumberThing)MathCmds.binary(100, ip, num, NumberThing.asNumber(argv[i])).getVal();
                }
                return new Thing(num);
            }
            case 106: {
                switch (argv.length) {
                    case 1: {
                        return new Thing(IntThing.ZERO);
                    }
                    case 2: {
                        return MathCmds.binary(101, ip, IntThing.ZERO, NumberThing.asNumber(argv[1]));
                    }
                }
                num = NumberThing.asNumber(argv[1]);
                for (int i = 2; i < argv.length; ++i) {
                    num = (NumberThing)MathCmds.binary(101, ip, num, NumberThing.asNumber(argv[i])).getVal();
                }
                return new Thing(num);
            }
            case 107: {
                num = IntThing.ONE;
                for (int i = 1; i < argv.length; ++i) {
                    num = (NumberThing)MathCmds.binary(102, ip, num, NumberThing.asNumber(argv[i])).getVal();
                }
                return new Thing(num);
            }
            case 20: {
                return DoubleThing.create(Math.random());
            }
            case 52: {
                return new Thing(IntThing.ONE);
            }
            case 53: {
                return new Thing(IntThing.ZERO);
            }
            case 81: {
                num = NumberThing.asNumber(argv[1]);
                for (int i = 2; i < argv.length; ++i) {
                    num = (NumberThing)MathCmds.binary(81, ip, num, NumberThing.asNumber(argv[i])).getVal();
                }
                return new Thing(num);
            }
            case 82: {
                num = NumberThing.asNumber(argv[1]);
                for (int i = 2; i < argv.length; ++i) {
                    num = (NumberThing)MathCmds.binary(82, ip, num, NumberThing.asNumber(argv[i])).getVal();
                }
                return new Thing(num);
            }
            case 50: {
                num = NumberThing.asNumber(argv[1]);
                if (!num.isIntegral()) {
                    throw new HeclException("Argument '" + argv[1].toString() + "' not an integer.");
                }
                IntThing offset = argv.length > 2 ? NumberThing.asNumber(argv[2]) : IntThing.ONE;
                num = ((IntegralThing)num).isLong() ? new LongThing(num.longValue() + ((NumberThing)offset).longValue()) : new IntThing(num.intValue() + ((NumberThing)offset).intValue());
                argv[1].setCopyVal(num);
                return new Thing(num);
            }
        }
        throw new HeclException("Unknown math operator '" + argv[0].toString() + "' with code '" + cmdcode + "'.");
    }

    public static void load(Interp ip) throws HeclException {
        Enumeration e = vars.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            ip.setVar(k, (Thing)vars.get(k));
        }
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
        Enumeration e = vars.keys();
        while (e.hasMoreElements()) {
            ip.unSetVar((String)e.nextElement());
        }
    }

    protected MathCmds(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    protected static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    protected static int compare(long v1, long v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    protected static int compare(double v1, double v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    static {
        cmdtable.put("true", new MathCmds(52, 0, 0));
        cmdtable.put("false", new MathCmds(53, 0, 0));
        cmdtable.put("and", new MathCmds(81, 1, -1));
        cmdtable.put("or", new MathCmds(82, 1, -1));
        cmdtable.put("1+", new MathCmds(50, 1, 2));
        cmdtable.put("1-", new MathCmds(51, 1, 2));
        cmdtable.put("incr", new MathCmds(50, 1, 2));
        cmdtable.put("int", new MathCmds(1, 1, 1));
        cmdtable.put("long", new MathCmds(2, 1, 1));
        cmdtable.put("abs", new MathCmds(7, 1, 1));
        cmdtable.put("not", new MathCmds(80, 1, 1));
        cmdtable.put("+", new MathCmds(105, -1, -1));
        cmdtable.put("-", new MathCmds(106, -1, -1));
        cmdtable.put("*", new MathCmds(107, -1, -1));
        cmdtable.put("/", new MathCmds(103, 2, 2));
        cmdtable.put("%", new MathCmds(104, 2, 2));
        cmdtable.put("=", new MathCmds(90, 2, 2));
        cmdtable.put("!=", new MathCmds(91, 2, 2));
        cmdtable.put("<", new MathCmds(92, 2, 2));
        cmdtable.put("<=", new MathCmds(93, 2, 2));
        cmdtable.put(">", new MathCmds(94, 2, 2));
        cmdtable.put(">=", new MathCmds(95, 2, 2));
        cmdtable.put("min", new MathCmds(22, 2, 2));
        cmdtable.put("max", new MathCmds(23, 2, 2));
        vars.put("pi", PI);
        vars.put("e", E);
        cmdtable.put("sqrt", new MathCmds(8, 1, 1));
        cmdtable.put("sin", new MathCmds(10, 1, 1));
        cmdtable.put("cos", new MathCmds(11, 1, 1));
        cmdtable.put("tan", new MathCmds(12, 1, 1));
        cmdtable.put("floor", new MathCmds(17, 1, 1));
        cmdtable.put("ceil", new MathCmds(18, 1, 1));
        cmdtable.put("float", new MathCmds(3, 1, 1));
        cmdtable.put("double", new MathCmds(4, 1, 1));
        cmdtable.put("toDegrees", new MathCmds(5, 1, 1));
        cmdtable.put("toRadians", new MathCmds(6, 1, 1));
        cmdtable.put("random", new MathCmds(20, 0, 0));
        cmdtable.put("pow", new MathCmds(19, 2, 2));
        cmdtable.put("log", new MathCmds(9, 1, 1));
        cmdtable.put("asin", new MathCmds(13, 1, 1));
        cmdtable.put("acos", new MathCmds(14, 1, 1));
        cmdtable.put("atan", new MathCmds(15, 1, 1));
        cmdtable.put("exp", new MathCmds(16, 1, 1));
        cmdtable.put("round", new MathCmds(21, 1, 1));
        cmdtable.put("signum", new MathCmds(30, 1, 1));
        cmdtable.put("cbrt", new MathCmds(31, 1, 1));
        cmdtable.put("log10", new MathCmds(32, 1, 1));
        cmdtable.put("log1p", new MathCmds(33, 1, 1));
        cmdtable.put("sinh", new MathCmds(34, 1, 1));
        cmdtable.put("cosh", new MathCmds(35, 1, 1));
        cmdtable.put("tanh", new MathCmds(36, 1, 1));
        cmdtable.put("expm1", new MathCmds(37, 1, 1));
        cmdtable.put("hypot", new MathCmds(38, 2, 2));
    }
}

