/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.hecl.AnonProc;
import org.hecl.ClassCommand;
import org.hecl.ClassCommandInfo;
import org.hecl.CodeThing;
import org.hecl.Command;
import org.hecl.ControlCmds;
import org.hecl.HashCmds;
import org.hecl.HeclException;
import org.hecl.HeclTask;
import org.hecl.InterpCmds;
import org.hecl.ListCmds;
import org.hecl.ListThing;
import org.hecl.MathCmds;
import org.hecl.Proc;
import org.hecl.PutsCmd;
import org.hecl.SortCmd;
import org.hecl.StringCmds;
import org.hecl.Thing;
import org.hecl.java.JavaCmd;

public class Interp
extends Thread {
    public static final String MODULE_CLASS_PACKAGE = "org.hecl";
    public static final int DONT_WAIT = 1;
    public static final int IDLE_EVENTS = 2;
    public static final int TIMER_EVENTS = 4;
    public static final int ALL_EVENTS = -2;
    public static final String ASYNCPREFIX = "async";
    public static final String IDLEPREFIX = "idle";
    public static final String TIMERPREFIX = "timer";
    public final String PROMPT = "hecl> ";
    public final String PROMPT2 = "hecl+ ";
    static final Thing GLOBALREFTHING = new Thing("");
    public long cacheversion = 0L;
    private static boolean javacmdpresent = false;
    protected Hashtable commands = new Hashtable();
    protected Hashtable auxdata = new Hashtable();
    protected Stack stack = new Stack();
    protected Stack error = new Stack();
    protected Vector timers = new Vector();
    protected Vector asyncs = new Vector();
    protected Vector idle = new Vector();
    protected Hashtable waittokens = new Hashtable();
    protected long idlegeneration = 0L;
    protected boolean running = true;
    protected long maxblocktime = 0L;
    protected Vector ci = new Vector();
    protected Hashtable classcmdcache = new Hashtable();
    static Class procclass;
    public static final char[] eol;
    public static final String fileseparator;
    public Thing currentFile = new Thing("");

    public Interp() throws HeclException {
        try {
            procclass = Class.forName("Proc");
            Class.forName("org.hecl.java.JavaCmd");
            javacmdpresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.stack.push(new Hashtable());
        this.initInterp();
        this.start();
    }

    protected String[] hashKeysToArray(Hashtable h) {
        return this.hashKeysToArray(h, "");
    }

    protected String[] hashKeysToArray(Hashtable h, String prefix) {
        Vector<String> cmds = new Vector<String>();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            cmds.add(prefix + (String)e.nextElement());
        }
        Object[] scmds = new String[cmds.size()];
        cmds.copyInto(scmds);
        return scmds;
    }

    public void addClassCmd(Class clazz, ClassCommand cmd) {
        this.classcmdcache.clear();
        int l = this.ci.size();
        for (int i = 0; i < l; ++i) {
            ClassCommandInfo info = (ClassCommandInfo)this.ci.elementAt(i);
            if (info.forClass() != clazz) continue;
            if (cmd == null) {
                this.ci.removeElementAt(i);
            } else {
                info.setCommand(cmd);
            }
            return;
        }
        if (cmd != null) {
            this.ci.addElement(new ClassCommandInfo(clazz, cmd));
        }
    }

    public void removeClassCmd(Class clazz) {
        this.addClassCmd(clazz, null);
    }

    ClassCommandInfo findClassCmd(Class clazz) {
        ClassCommandInfo found = (ClassCommandInfo)this.classcmdcache.get(clazz);
        if (found == null) {
            int l = this.ci.size();
            for (int i = 0; i < l; ++i) {
                ClassCommandInfo info = (ClassCommandInfo)this.ci.elementAt(i);
                Class cl2 = info.forClass();
                if (!cl2.isAssignableFrom(clazz)) continue;
                if (found == null) {
                    found = info;
                    continue;
                }
                if (!found.forClass().isAssignableFrom(cl2)) continue;
                found = info;
            }
            if (found != null) {
                this.classcmdcache.put(clazz, found);
            } else if (javacmdpresent) {
                try {
                    JavaCmd.load(this, clazz.getName(), null);
                    return this.findClassCmd(clazz);
                }
                catch (HeclException heclException) {
                    return this.findClassCmd(clazz);
                }
            }
        }
        return found;
    }

    public synchronized String addCommand(String name, Command c) {
        this.commands.put(name, c);
        return name;
    }

    public synchronized void removeCommand(String name) {
        this.commands.remove(name);
    }

    public synchronized boolean commandExists(String name) {
        return this.commands.containsKey(name);
    }

    public synchronized void setAuxData(String key, Object value) {
        this.auxdata.put(key, value);
    }

    public synchronized Object getAuxData(String key) {
        return this.auxdata.get(key);
    }

    public synchronized void removeAuxData(String key) {
        this.auxdata.remove(key);
    }

    public synchronized Thing eval(Thing in) throws HeclException {
        return CodeThing.get(this, in).run(this);
    }

    public HeclTask evalIdle(Thing idleThing) {
        return this.addTask(this.idle, new HeclTask(idleThing, this.idlegeneration, IDLEPREFIX), -1);
    }

    public HeclTask evalAsync(Thing asyncThing) {
        return this.addTask(this.asyncs, new HeclTask(asyncThing, 0L, ASYNCPREFIX), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thing evalAsyncAndWait(Thing in) throws HeclException {
        HeclTask t = this.evalAsync(in);
        t.setErrorPrint(false);
        boolean done = false;
        while (!t.isDone()) {
            try {
                HeclTask heclTask = t;
                synchronized (heclTask) {
                    t.wait();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Exception e = t.getError();
            if (e != null) {
                throw e;
            }
            return t.getResult();
        }
        catch (HeclException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HeclException(e.getMessage());
        }
    }

    public Thing eval(Thing in, int level) throws HeclException {
        Thing result = null;
        Vector<Hashtable> savedstack = new Vector<Hashtable>();
        int stacklen = this.stack.size();
        int i = 0;
        int end = 0;
        HeclException save_exception = null;
        end = level >= 0 ? level : stacklen - 1 + level;
        for (i = stacklen - 1; i > end; --i) {
            savedstack.addElement(this.stackDecr());
        }
        try {
            result = this.eval(in);
        }
        catch (HeclException he) {
            save_exception = he;
        }
        for (i = savedstack.size() - 1; i >= 0; --i) {
            this.stackPush((Hashtable)savedstack.elementAt(i));
        }
        if (save_exception != null) {
            throw save_exception;
        }
        return result;
    }

    public boolean hasIdleTasks() {
        return this.idle.size() == 0;
    }

    public synchronized HeclTask getEvent(String name) {
        int i;
        int n = this.timers.size();
        Vector v = new Vector();
        HeclTask t = null;
        for (i = 0; i < n; ++i) {
            t = (HeclTask)this.timers.elementAt(i);
            if (!name.equals(t.getName())) continue;
            return t;
        }
        n = this.idle.size();
        for (i = 0; i < n; ++i) {
            t = (HeclTask)this.idle.elementAt(i);
            if (!name.equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    public synchronized Vector getAllEvents() {
        int i;
        int n = this.timers.size();
        Vector v = new Vector();
        for (i = 0; i < n; ++i) {
            v.addElement(this.timers.elementAt(i));
        }
        n = this.idle.size();
        for (i = 0; i < n; ++i) {
            v.addElement(this.timers.elementAt(i));
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeclTask addTimer(Thing timerThing, int millisecs) {
        Vector vector = this.timers;
        synchronized (vector) {
            HeclTask other;
            int i;
            int n = this.timers.size();
            long ts = System.currentTimeMillis() + (long)millisecs;
            HeclTask t = new HeclTask(timerThing, ts, TIMERPREFIX);
            for (i = 0; i < n && (other = (HeclTask)this.timers.elementAt(i)).getGeneration() <= ts; ++i) {
            }
            return this.addTask(this.timers, t, i);
        }
    }

    public void cancelTimer(String name) {
        this.cancelTask(this.timers, name);
    }

    public void cancelIdle(String name) {
        this.cancelTask(this.idle, name);
    }

    public void cancelAsync(String name) {
        this.cancelTask(this.asyncs, name);
    }

    public synchronized void cancelIdle(HeclTask idletask) {
        this.idle.removeElement(idletask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean doOneEvent(int flags) {
        if ((flags & 0xFFFFFFFE) == 0) {
            flags = -2;
        }
        int count = 0;
        while (true) {
            Interp interp;
            HeclTask t;
            if ((t = this.nextTask(this.asyncs, -1L)) != null) {
                return this.executeTask(t);
            }
            long now = System.currentTimeMillis();
            if ((flags & 4) != 0 && (t = this.nextTask(this.timers, now)) != null) {
                return this.executeTask(t);
            }
            if ((flags & 1) != 0) {
                this.maxblocktime = 0L;
            } else {
                this.maxblocktime = 1000L;
                interp = this;
                synchronized (interp) {
                    if (this.timers.size() > 0) {
                        t = (HeclTask)this.timers.elementAt(0);
                        this.maxblocktime = t.getGeneration() - now;
                    }
                }
            }
            if ((flags & 2) != 0) {
                this.serviceIdleTask();
            }
            if (count > 0 || this.maxblocktime <= 0L) break;
            Interp.yield();
            interp = this;
            synchronized (interp) {
                try {
                    this.wait(this.maxblocktime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++count;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForToken(String tokenname) throws HeclException {
        boolean exists = false;
        WaitToken token = null;
        Interp interp = this;
        synchronized (interp) {
            exists = this.waittokens.containsKey(tokenname);
            if (exists) {
                throw new HeclException("Wait token '" + tokenname + "' already exists.");
            }
            token = new WaitToken();
            this.waittokens.put(tokenname, token);
        }
        boolean b = true;
        while (b) {
            Interp interp2 = this;
            synchronized (interp2) {
                b = token.waiting;
            }
            if (!b) continue;
            this.doOneEvent(-2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyToken(String tokenname) throws HeclException {
        Interp interp = this;
        synchronized (interp) {
            WaitToken token = (WaitToken)this.waittokens.get(tokenname);
            if (token == null) {
                throw new HeclException("No wait token '" + tokenname + "'.");
            }
            token.waiting = false;
            this.waittokens.remove(tokenname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.running = false;
        Interp interp = this;
        synchronized (interp) {
            this.notify();
        }
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        while (this.running) {
            this.doOneEvent(-2);
        }
    }

    private void initInterp() throws HeclException {
        InterpCmds.load(this);
        MathCmds.load(this);
        ListCmds.load(this);
        ControlCmds.load(this);
        StringCmds.load(this);
        HashCmds.load(this);
        this.commands.put("puts", new PutsCmd());
        this.commands.put("sort", new SortCmd());
        this.addClassCmd(procclass, new AnonProc());
        this.addClassCmd(Proc.class, new AnonProc());
    }

    public synchronized void cmdRename(String oldname, String newname) throws HeclException {
        this.cmdAlias(oldname, newname);
        this.commands.remove(oldname);
    }

    public synchronized void cmdAlias(String oldname, String newname) throws HeclException {
        Command tmp = (Command)this.commands.get(oldname);
        if (tmp == null) {
            throw new HeclException("Command " + oldname + " does not exist");
        }
        this.commands.put(newname, tmp);
    }

    public synchronized void stackIncr() {
        this.stackPush(new Hashtable());
    }

    public synchronized Hashtable stackDecr() {
        return (Hashtable)this.stack.pop();
    }

    public synchronized void stackPush(Hashtable vars) {
        ++this.cacheversion;
        this.stack.push(vars);
    }

    private Hashtable getVarhash(int level) {
        return level < 0 ? (Hashtable)this.stack.peek() : (Hashtable)this.stack.elementAt(level);
    }

    public Thing getVar(Thing varname) throws HeclException {
        return this.getVar(varname.toString(), -1);
    }

    public Thing getVar(String varname) throws HeclException {
        return this.getVar(varname, -1);
    }

    public synchronized Thing getVar(String varname, int level) throws HeclException {
        Hashtable globalhash;
        Hashtable lookup = this.getVarhash(level);
        Thing res = (Thing)lookup.get(varname);
        if (res == GLOBALREFTHING && (res = (Thing)(globalhash = this.getVarhash(0)).get(varname)) == GLOBALREFTHING) {
            System.err.println("Unexpected GLOBALREFTHING in globalhash");
            res = null;
        }
        if (res == null) {
            throw new HeclException("Variable " + varname + " does not exist");
        }
        return res;
    }

    public void setVar(Thing varname, Thing value) throws HeclException {
        this.setVar(varname.toString(), value);
    }

    public void setVar(String varname, Thing value) {
        this.setVar(varname, value, -1);
    }

    public synchronized void setVar(String varname, Thing value, int level) {
        Thing oldval;
        Hashtable lookup = this.getVarhash(level);
        ++this.cacheversion;
        if (lookup.containsKey(varname)) {
            oldval = (Thing)lookup.get(varname);
            if (oldval.global && level != 0) {
                value.global = true;
                Hashtable globalhash = this.getVarhash(0);
                globalhash.put(varname, value);
            }
        }
        lookup.put(varname, value);
        if (value.isLiteral()) {
            try {
                Thing copy;
                value = copy = value.deepcopy();
            }
            catch (HeclException he) {
                System.err.println("Interp.java: This can never happen!");
            }
        }
        if (value == GLOBALREFTHING) {
            Hashtable globalhash = this.getVarhash(0);
            if (lookup != globalhash) {
                lookup.put(varname, value);
                if (null == globalhash.get(varname)) {
                    globalhash.put(varname, new Thing(""));
                }
            }
            return;
        }
        if (lookup.containsKey(varname) && (oldval = (Thing)lookup.get(varname)) == GLOBALREFTHING) {
            lookup = this.getVarhash(0);
        }
        lookup.put(varname, value);
    }

    public void unSetVar(Thing varname) throws HeclException {
        this.unSetVar(varname.toString(), -1);
    }

    public synchronized void unSetVar(String varname) throws HeclException {
        this.unSetVar(varname, -1);
    }

    public synchronized void unSetVar(String varname, int level) throws HeclException {
        Hashtable lookup = this.getVarhash(level);
        Thing value = (Thing)lookup.get(varname);
        if (value != null) {
            Hashtable globalhash;
            ++this.cacheversion;
            lookup.remove(varname);
            if (value.global && (value = (Thing)(globalhash = this.getVarhash(0)).get(varname)) != null) {
                globalhash.remove(varname);
            }
        } else {
            throw new HeclException("Variable " + varname + " does not exist");
        }
    }

    public boolean existsVar(Thing varname) throws HeclException {
        return this.existsVar(varname.toString());
    }

    public boolean existsVar(String varname) {
        return this.existsVar(varname, -1);
    }

    public synchronized boolean existsVar(String varname, int level) {
        Hashtable lookup = this.getVarhash(level);
        return lookup.containsKey(varname);
    }

    public void addError(Thing err) {
        this.error.push(err);
    }

    public void clearError() {
        this.error = new Stack();
    }

    public static void checkArgCount(Thing[] argv, int minargs, int maxargs) throws HeclException {
        int n = argv.length - 1;
        if (minargs >= 0 && n < minargs) {
            throw new HeclException("Too few arguments, at least " + minargs + " arguments required.");
        }
        if (maxargs >= 0 && n > maxargs) {
            throw new HeclException("Bad argument count, max. " + maxargs + " arguments allowed.");
        }
    }

    protected synchronized HeclTask nextTask(Vector v, long until) {
        HeclTask t = null;
        if (v.size() > 0) {
            t = (HeclTask)v.elementAt(0);
            if (until < 0L || t.getGeneration() <= until) {
                v.removeElementAt(0);
            } else {
                t = null;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean serviceIdleTask() {
        long oldgeneration;
        Interp interp = this;
        synchronized (interp) {
            if (this.idle.size() == 0) {
                this.idlegeneration = 0L;
                return false;
            }
            oldgeneration = this.idlegeneration++;
        }
        HeclTask t = this.nextTask(this.idle, oldgeneration);
        if (t != null) {
            t.execute(this);
        }
        if (this.idle.size() > 0) {
            this.maxblocktime = 0L;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeclTask addTask(Vector v, HeclTask task, int pos) {
        Vector vector = v;
        synchronized (vector) {
            if (pos < 0) {
                v.addElement(task);
            } else {
                v.insertElementAt(task, pos);
            }
            return task;
        }
    }

    private synchronized void cancelTask(Vector v, String name) {
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            HeclTask t = (HeclTask)v.elementAt(i);
            if (!name.equals(t.getName())) continue;
            v.removeElementAt(i);
            return;
        }
    }

    private boolean executeTask(HeclTask task) {
        try {
            task.execute(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void backgroundError(String errorMessage) {
        try {
            Vector<Thing> v = new Vector<Thing>();
            v.addElement(new Thing("bgerror"));
            v.addElement(new Thing(errorMessage));
            this.eval(ListThing.create(v), 0);
        }
        catch (Exception e) {
            System.err.println("Hecl severe bg error: " + errorMessage + "\n" + e.toString());
            e.printStackTrace();
        }
    }

    static String readLine(InputStreamReader is) {
        StringBuffer b = new StringBuffer();
        int ch = -1;
        try {
            while ((ch = is.read()) != -1) {
                if (ch == 13) continue;
                if (ch != 10) {
                    b.append((char)ch);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (b.length() > 0 || ch != -1) {
            return b.toString();
        }
        return null;
    }

    static {
        eol = System.getProperty("line.separator").toCharArray();
        fileseparator = System.getProperty("file.separator");
    }

    protected static class WaitToken {
        public volatile boolean waiting = true;

        protected WaitToken() {
        }
    }
}

