/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import org.hecl.Interp;
import org.hecl.Thing;

public class HeclTask {
    protected final char sep = (char)35;
    protected Thing tscript;
    protected long tgeneration;
    protected String tname;
    protected Thing result = null;
    protected Exception error = null;
    protected boolean showbgerror = true;
    protected volatile boolean done = false;
    protected static long tasknum;

    public HeclTask(Thing script, long generation, String name) {
        this.tscript = script;
        this.tgeneration = generation;
        this.tname = (name != null ? name : "task") + '#' + ++tasknum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thing execute(Interp ip) {
        try {
            this.result = ip.eval(this.tscript, 0);
        }
        catch (Exception e) {
            this.error = e;
            if (this.showbgerror) {
                e.printStackTrace();
                ip.backgroundError(e.toString());
            }
        }
        finally {
            HeclTask heclTask = this;
            synchronized (heclTask) {
                this.done = true;
                this.notifyAll();
            }
        }
        return this.result;
    }

    public Exception getError() {
        return this.error;
    }

    public String getType() {
        return this.tname.substring(0, this.tname.lastIndexOf(35));
    }

    public long getGeneration() {
        return this.tgeneration;
    }

    public String getName() {
        return this.tname;
    }

    public Thing getResult() {
        return this.result;
    }

    public Thing getScript() {
        return this.tscript;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setErrorPrint(boolean onoff) {
        this.showbgerror = onoff;
    }
}

