/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtikz;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Closeable;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import net.sf.jtikz.GraphicsCommand;
import net.sf.jtikz.GraphicsInterfaceRepaintManager;

public abstract class AbstractGraphicsInterface
extends Graphics2D
implements Closeable,
Flushable {
    LinkedList<AbstractGraphicsInterface> children;
    AbstractGraphicsInterface parent;
    AffineTransform transform;
    boolean closed;
    String preamble;
    Shape currentClip;
    Color color;
    Font font;
    Thread shutdownHook;
    Color background;
    BasicStroke stroke;
    LinkedList<GraphicsCommand> commands;
    public boolean verbose = false;
    protected PrintStream out;

    protected void addCommand(Object command) {
        if (this.parent != null) {
            this.parent.addCommand(command);
        } else {
            if (this.verbose) {
                System.err.println("Command: " + command);
            }
            GraphicsCommand grcmd = new GraphicsCommand(command, this);
            grcmd.verbose = this.verbose;
            this.commands.addLast(grcmd);
        }
    }

    protected LinkedList<GraphicsCommand> getCommands() {
        return this.commands;
    }

    protected abstract AbstractGraphicsInterface newInstance();

    @Override
    public final AbstractGraphicsInterface create() {
        if (this.verbose) {
            System.err.println("create()");
        }
        AbstractGraphicsInterface g = this.newInstance();
        this.children.add(g);
        g.parent = this;
        g.setClip(this.getClip());
        g.transform = new AffineTransform(this.transform);
        if (this.verbose) {
            System.err.println("Transform: " + g.transform);
        }
        return g;
    }

    @Override
    public final AbstractGraphicsInterface create(int x, int y, int width, int height) {
        if (this.verbose) {
            System.err.println("create(" + x + ", " + y + ", " + width + ", " + height + ", " + this.currentClip + ")");
        }
        AbstractGraphicsInterface g = this.create();
        g.setClip(x, y, width, height);
        g.translate(x, y);
        return g;
    }

    protected AbstractGraphicsInterface getParent() {
        return this.parent;
    }

    public AbstractGraphicsInterface() {
        this(System.out);
    }

    public AbstractGraphicsInterface(OutputStream os) {
        if (os == null) {
            os = System.out;
        }
        this.out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        this.parent = null;
        this.transform = new AffineTransform();
        this.closed = false;
        this.preamble = "";
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                AbstractGraphicsInterface.this.flush();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.flush();
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void draw(Shape shape) {
        this.handlePath(shape.getPathIterator(this.transform), Action.DRAW);
    }

    @Override
    public void fill(Shape shape) {
        this.handlePath(shape.getPathIterator(this.transform), Action.FILL);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.handlePath(p.getPathIterator(this.transform), Action.DRAW);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.handlePath(p.getPathIterator(this.transform), Action.FILL);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fillPolygon(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints < 2) {
            return;
        }
        if (xPoints[0] == xPoints[nPoints - 1] && yPoints[0] == yPoints[nPoints - 1]) {
            this.drawPolygon(xPoints, yPoints, nPoints);
        } else {
            double[] newx = new double[xPoints.length];
            double[] newy = new double[yPoints.length];
            Point2D.Double p1 = new Point2D.Double();
            Point2D.Double p2 = new Point2D.Double();
            for (int i = 0; i < nPoints; ++i) {
                p1.x = xPoints[i];
                p1.y = yPoints[i];
                this.transform.transform(p1, p2);
                newx[i] = p2.getX();
                newy[i] = p2.getY();
            }
            this.handlePolyline(newx, newy, nPoints);
        }
    }

    protected abstract void handlePath(PathIterator var1, Action var2);

    protected void handlePolyline(double[] xPoints, double[] yPoints, int nPoints) {
        for (int i = 1; i < nPoints; ++i) {
            this.handleLine(xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i]);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Point2D p1 = this.transform.transform(new Point2D.Double(x1, y1), null);
        Point2D p2 = this.transform.transform(new Point2D.Double(x2, y2), null);
        this.handleLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    protected abstract void handleLine(double var1, double var3, double var5, double var7);

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.handleOval(x, y, width, height, false);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.handleOval(x, y, width, height, true);
    }

    private void handleOval(int x, int y, int width, int height, boolean fill) {
        Point2D p1 = this.transform.transform(new Point2D.Double(x, y), null);
        this.handleOval(p1.getX(), p1.getY(), (double)width, (double)height, fill);
    }

    protected abstract void handleOval(double var1, double var3, double var5, double var7, boolean var9);

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.handleRoundRect(x, y, width, height, arcWidth, arcHeight, true);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.handleRoundRect(x, y, width, height, arcWidth, arcHeight, false);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.handleRoundRect(x, y, width, height, 0, 0, true);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.handleRoundRect(x, y, width, height, 0, 0, false);
    }

    private void handleRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean fill) {
        Point2D p1 = this.transform.transform(new Point2D.Double(x, y), null);
        this.handleRoundRect(p1.getX(), p1.getY(), (double)width, (double)height, (double)arcWidth, (double)arcHeight, fill);
    }

    protected abstract void handleRoundRect(double var1, double var3, double var5, double var7, double var9, double var11, boolean var13);

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.handleArc(x, y, width, height, startAngle, arcAngle, false);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.handleArc(x, y, width, height, startAngle, arcAngle, true);
    }

    private void handleArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
        Point2D p1 = this.transform.transform(new Point2D.Double(x, y), null);
        this.handleArc(p1.getX(), p1.getY(), (double)width, (double)height, startAngle, arcAngle, fill);
    }

    protected abstract void handleArc(double var1, double var3, double var5, double var7, int var9, int var10, boolean var11);

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Point2D p1 = this.transform.transform(new Point2D.Double(x, y), null);
        this.handleClearRect(p1.getX(), p1.getY(), width, height);
    }

    protected abstract void handleClearRect(double var1, double var3, double var5, double var7);

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Composite getComposite() {
        return AlphaComposite.getInstance(2);
    }

    @Override
    public void setComposite(Composite composite) {
    }

    @Override
    public Paint getPaint() {
        return this.color;
    }

    @Override
    public void setPaint(Paint paint) {
        if (!(paint instanceof Color)) {
            return;
        }
        this.setColor((Color)paint);
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new IllegalStateException("This AbstractGraphicsInterface has already been closed!");
        }
        if (this.parent != null) {
            return;
        }
        this.flushInternal();
        this.children = new LinkedList();
        this.font = new Font("Arial", 0, 12);
        this.stroke = new BasicStroke();
        this.color = Color.BLACK;
        this.background = Color.WHITE;
        this.preamble = "";
        this.commands = new LinkedList();
    }

    protected abstract void flushInternal();

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (AbstractGraphicsInterface child : this.children) {
                child.close();
            }
            this.flush();
            this.closed = true;
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    @Override
    public void transform(AffineTransform transform) {
        this.transform.concatenate(transform);
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.transform.setTransform(transform);
    }

    @Override
    public void setClip(Shape clip) {
        this.currentClip = clip;
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void clip(Shape clip) {
        this.setClip(clip);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        return this.currentClip;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.currentClip == null ? null : this.currentClip.getBounds();
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.drawString(s, (float)x, (float)y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        Point2D p1 = this.transform.transform(new Point2D.Double(x, y), null);
        this.handleDrawString(s, p1.getX(), p1.getY());
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        StringBuffer s = new StringBuffer("");
        char c = iterator.first();
        while (c != '\uffff') {
            s.append(c);
            c = iterator.next();
        }
        this.drawString(s.toString(), x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    protected abstract void handleDrawString(String var1, double var2, double var4);

    public void paintComponent(Component component) {
        RepaintManager old = RepaintManager.currentManager(component);
        RepaintManager.setCurrentManager(new GraphicsInterfaceRepaintManager(this));
        try {
            SwingUtilities.invokeAndWait(new Repainter(component, this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        RepaintManager.setCurrentManager(old);
    }

    @Override
    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        ColorModel c = image.getColorModel();
        Raster r = image.getData();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
            }
        }
    }

    @Override
    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(image, null);
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public abstract boolean drawImage(Image var1, AffineTransform var2, ImageObserver var3);

    @Override
    public abstract void drawRenderableImage(RenderableImage var1, AffineTransform var2);

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return;
        }
        this.stroke = (BasicStroke)stroke;
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
    }

    public void addRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return true;
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return true;
    }

    private static class Repainter
    implements Runnable {
        Component component;
        Graphics g;

        public Repainter(Component component, Graphics g) {
            this.component = component;
            this.g = g;
        }

        @Override
        public void run() {
            this.component.paint(this.g);
        }
    }

    protected static enum Action {
        DRAW,
        FILL,
        CLIP;

    }
}

