/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class StatTipCmd
implements Command {
    API api;
    boolean debug = false;

    public StatTipCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        double Fy;
        double Fx;
        double y0;
        double x0;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        switch (argd.length) {
            case 4: {
                x0 = argd[0];
                y0 = argd[1];
                Fx = argd[2];
                Fy = argd[3];
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        double x1 = x0 + this.api.fu(Fx);
        double y1 = y0 + this.api.fu(Fy);
        String xBstr = StringThing.get(DoubleThing.create(x1));
        String yBstr = StringThing.get(DoubleThing.create(y1));
        String answer = xBstr + " " + yBstr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

