/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import net.sf.drawj2d.cmd.statics.clKraft;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class StatMequilibriumCmd
implements Command {
    API api;
    boolean debug = false;

    public StatMequilibriumCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        double M;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        if (argd.length < 5) {
            throw new HeclException("Illegal nb of arguments.");
        }
        assert (argd.length >= 5);
        double[] here = this.api.here();
        double xB = argd[0];
        double yB = argd[1];
        double FxB = argd[2];
        double FyB = argd[3];
        clKraft FB = new clKraft(FxB, FyB, xB, yB);
        double MB = FB.getM(here);
        switch (argd.length) {
            case 8: {
                double x0 = argd[4];
                double y0 = argd[5];
                double Fx = argd[6];
                double Fy = argd[7];
                clKraft F = new clKraft(Fx, Fy, x0, y0);
                M = F.getM(here);
                break;
            }
            case 5: {
                M = argd[4];
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        double f = -M / MB;
        String xstr = StringThing.get(DoubleThing.create(xB));
        String ystr = StringThing.get(DoubleThing.create(yB));
        String Fxstr = StringThing.get(DoubleThing.create(FxB *= f));
        String Fystr = StringThing.get(DoubleThing.create(FyB *= f));
        String answer = xstr + " " + ystr + " " + Fxstr + " " + Fystr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

