/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import java.util.ArrayList;
import java.util.Arrays;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomExtendCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        if (argd.length < 4) {
            throw new HeclException("Illegal nb of arguments.");
        }
        assert (argd.length >= 5);
        double x0 = argd[0];
        double y0 = argd[1];
        double x1 = argd[2];
        double y1 = argd[3];
        double dx = x1 - x0;
        double dy = y1 - y0;
        double L = Math.hypot(dx, dy);
        double[] A = new double[2];
        double[] B = new double[2];
        switch (argd.length) {
            case 6: {
                double dLA = argd[4];
                double dLB = argd[5];
                B[0] = x1 + dLB * dx / L;
                B[1] = y1 + dLB * dy / L;
                A[0] = x0 - dLA * dx / L;
                A[1] = y0 - dLA * dy / L;
                break;
            }
            case 5: {
                double dL = argd[4];
                B[0] = x1 + dL * dx / L;
                B[1] = y1 + dL * dy / L;
                A[0] = x0 - dL * dx / L;
                A[1] = y0 - dL * dy / L;
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        String xAstr = StringThing.get(DoubleThing.create(A[0]));
        String yAstr = StringThing.get(DoubleThing.create(A[1]));
        String xBstr = StringThing.get(DoubleThing.create(B[0]));
        String yBstr = StringThing.get(DoubleThing.create(B[1]));
        String answer = xAstr + " " + yAstr + " " + xBstr + " " + yBstr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

