/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class TexlabelCmd
implements Command {
    API api;
    boolean debug = false;

    public TexlabelCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        if (argv.length < 2) {
            throw new HeclException("Illegal nb of arguments.");
        }
        String lb = StringThing.get(argv[1]);
        block0 : switch (argv.length - 1) {
            case 1: {
                this.api.texlabel(lb);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                assert (argv.length > 2);
                Thing[] argv2 = new Thing[argv.length - 2];
                for (int i = 2; i < argv.length; ++i) {
                    argv2[i - 2] = argv[i];
                }
                ArrayList<Thing> singleargv2 = this.splitArgv2(argv2);
                switch (singleargv2.size()) {
                    case 1: {
                        String dir = StringThing.get(argv[2]);
                        this.api.texlabel(lb, dir);
                        break block0;
                    }
                    case 4: {
                        double[] argd = new double[4];
                        for (int i = 0; i < 4; ++i) {
                            argd[i] = NumberThing.asNumber(singleargv2.get(i)).doubleValue();
                        }
                        this.api.texlabelline(argd[0], argd[1], argd[2], argd[3], lb);
                        break block0;
                    }
                }
                throw new HeclException("Illegal nb of arguments.");
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return null;
    }

    private ArrayList<Thing> splitArgv2(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 0; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

