/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.awt.FontFormatException;
import java.io.IOException;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class FontCmd
implements Command {
    API api;
    boolean debug = false;

    public FontCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        String font = "";
        int style = 0;
        int size = 0;
        if (argv.length == 1) {
            this.api.font();
        } else {
            assert (argv.length > 1);
            for (int i = 1; i < argv.length; ++i) {
                Thing arg = argv[i];
                if (NumberThing.isNumber(arg)) {
                    size = NumberThing.asNumber(arg).intValue();
                    continue;
                }
                String str = StringThing.get(arg);
                int fontstyle = this.getFontStyle(str);
                if (fontstyle >= 0) {
                    style = fontstyle;
                    continue;
                }
                font = str;
            }
            try {
                this.api.font(font, style, size);
            }
            catch (FontFormatException e) {
                throw new HeclException(e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new HeclException(e.getLocalizedMessage());
            }
        }
        return null;
    }

    private int getFontStyle(String str) {
        String s = str.toLowerCase();
        if (s.equals("bold") || s.equals("bf")) {
            return 1;
        }
        if (s.equals("italic") || s.equals("it")) {
            return 2;
        }
        if (s.equals("plain") || s.equals("up")) {
            return 0;
        }
        return -1;
    }
}

