/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class DimangleCmd
implements Command {
    API api;
    boolean debug = false;

    public DimangleCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        String lb = "";
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            Thing currentThing = singleargv.get(i);
            try {
                argd[i] = NumberThing.asNumber(currentThing).doubleValue();
                continue;
            }
            catch (NumberFormatException ex) {
                if (lb.equals("")) {
                    lb = StringThing.get(currentThing);
                    continue;
                }
                throw new HeclException("Illegal arguments.");
            }
        }
        double x0 = this.api.here()[0];
        double y0 = this.api.here()[1];
        switch (nbsingleargs) {
            case 7: {
                if (lb.equals("")) {
                    lb = StringThing.get(singleargv.get(6));
                }
                this.api.dimangle(argd[0], argd[1], argd[2], argd[3], argd[4], argd[5], false, lb);
                break;
            }
            case 6: {
                this.api.dimangle(argd[0], argd[1], argd[2], argd[3], argd[4], argd[5], false);
                break;
            }
            case 5: {
                if (lb.equals("")) {
                    lb = StringThing.get(singleargv.get(4));
                }
                this.api.dimangle(x0, y0, argd[0], argd[1], argd[2], argd[3], false, lb);
                break;
            }
            case 4: {
                this.api.dimangle(x0, y0, argd[0], argd[1], argd[2], argd[3], false);
                break;
            }
            case 3: {
                if (lb.equals("")) {
                    lb = StringThing.get(singleargv.get(2));
                }
                double xP = x0 + 10.0 * Math.cos(argd[0] * Math.PI / 180.0);
                double yP = y0 + 10.0 * Math.sin(argd[0] * Math.PI / 180.0);
                double xQ = x0 + 10.0 * Math.cos(argd[1] * Math.PI / 180.0);
                double yQ = y0 + 10.0 * Math.sin(argd[1] * Math.PI / 180.0);
                this.api.dimangle(x0, y0, xP, yP, xQ, yQ, false, lb);
                break;
            }
            case 2: {
                double x_P = x0 + 10.0 * Math.cos(argd[0] * Math.PI / 180.0);
                double y_P = y0 + 10.0 * Math.sin(argd[0] * Math.PI / 180.0);
                double x_Q = x0 + 10.0 * Math.cos(argd[1] * Math.PI / 180.0);
                double y_Q = y0 + 10.0 * Math.sin(argd[1] * Math.PI / 180.0);
                this.api.dimangle(x0, y0, x_P, y_P, x_Q, y_Q, false);
                break;
            }
            case 1: {
                Thing currentThing = singleargv.get(0);
                NumberThing digits = NumberThing.asNumber(currentThing);
                if (digits.isIntegral()) {
                    this.api.decdigitsangle(digits.intValue());
                    break;
                }
                throw new HeclException("Illegal argument. Number of digits (integer) expected, but got: " + StringThing.get(currentThing));
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return null;
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

