/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import com.udojava.evalex.Expression;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import net.sf.drawj2d.UTF2asciiConverter;
import net.sf.drawj2d.cmd.Fkt;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class API {
    static final int SOLID = 1;
    static final int DASHED = 2;
    static final int DOTTED = 3;
    static final int DASHDOTTED = 4;
    private final Graphics2D g;
    private Point2D currentpos = new Point2D.Double(0.0, 0.0);
    UTF2asciiConverter UTFconverter = new UTF2asciiConverter();
    static final double inch = 25.4;
    private final Stack<clBlock> blocks = new Stack();
    private final float stdstroke = 0.5f;
    float[] dashed = new float[]{2.0f, 1.5f};
    float[] dotted = new float[]{0.0f, 1.5f};
    float[] dashdotted = new float[]{2.0f, 1.5f, 0.0f, 1.5f};
    private float currentstrokesize = 0.5f;
    private int currentlinetype = 1;
    private final int schriftgrStd = 4;
    private int schriftgr = 4;
    private final String fontStd = "Serif";
    private final String texfont = "/org/scilab/forge/jlatexmath/fonts/latin/jlm_cmr10.ttf";
    private Font jarfont;
    private String font = "Serif";
    private double lastavailabletextwidth = -1.0;
    private boolean lastavailabletextjustified = false;
    private final double bzuh = 0.61;
    boolean horizFontOnly = false;
    private final int digitsStd = 3;
    private int digits = 3;
    private int angledigitsStd;
    private int angledigits = this.angledigitsStd = 2;
    private final int forcedigitsStd = 1;
    private int forcedigits = 1;
    private double u = 1.0;
    private double naturalunit = 1.0;
    private double fu = 1.0;
    private final boolean debug = false;

    public API(Graphics2D g) {
        this.g = g;
        this.pen();
        this.font();
        try {
            g.getFontMetrics().getStringBounds("Test", g);
        }
        catch (Exception e) {
            this.horizFontOnly = true;
        }
    }

    public void pen(Color color) {
        this.g.setColor(color);
    }

    public void pen(float size) {
        this.currentstrokesize = size;
        this.pen(this.currentlinetype);
    }

    public void pen(int linetype) {
        boolean solidline;
        float[] dash = null;
        switch (linetype) {
            case 2: {
                dash = this.dashed;
                solidline = false;
                break;
            }
            case 3: {
                dash = this.dotted;
                solidline = false;
                break;
            }
            case 4: {
                dash = this.dashdotted;
                solidline = false;
                break;
            }
            case 1: {
                solidline = true;
                break;
            }
            default: {
                assert (false);
                solidline = true;
            }
        }
        boolean cap = true;
        boolean join = true;
        float miterlimit = 10.0f;
        float dashphase = 0.0f;
        BasicStroke stroke = solidline ? new BasicStroke(this.currentstrokesize, 1, 1) : new BasicStroke(this.currentstrokesize, 1, 1, 10.0f, dash, 0.0f);
        this.g.setStroke(stroke);
        this.currentlinetype = linetype;
    }

    public final void pen() {
        this.g.setColor(Color.BLACK);
        this.g.setStroke(new BasicStroke(0.5f, 1, 1));
        this.currentstrokesize = 0.5f;
        this.currentlinetype = 1;
    }

    public final void opacity(float opacity) {
        this.g.setComposite(AlphaComposite.getInstance(3, opacity));
    }

    public void font(String font, int style, int size) throws FontFormatException, IOException {
        if (size == 0) {
            size = this.schriftgr;
        }
        if (font.equals("")) {
            font = this.font;
        }
        if (font.equalsIgnoreCase("tex")) {
            this.jarfont = Font.createFont(0, this.getClass().getResourceAsStream("/org/scilab/forge/jlatexmath/fonts/latin/jlm_cmr10.ttf")).deriveFont(style, size);
            this.g.setFont(this.jarfont);
        } else {
            this.g.setFont(new Font(font, style, size));
        }
        this.font = font;
        this.schriftgr = size;
    }

    public final void font() {
        this.g.setFont(new Font("Serif", 0, 4));
        this.font = "Serif";
        this.schriftgr = 4;
    }

    public void unitlength(double mm) {
        this.u = mm;
        this.naturalunit = 1.0;
    }

    public void unitlength(double scale, double unit) {
        this.u = scale * unit;
        this.naturalunit = unit;
    }

    public double mm(double mm) {
        return mm / this.u;
    }

    public void forceunitlength(double mm, int decdigits) {
        this.fu = mm;
        this.forcedigits = decdigits;
    }

    public double fu(double kN) {
        return kN * this.fu / this.u;
    }

    public double expr(String str) {
        MathContext mc = new MathContext(17);
        Expression expression = new Expression(str, mc);
        BigDecimal result = expression.eval();
        double val = result.doubleValue();
        return val;
    }

    public void offset(double dX, double dY) {
        this.g.translate(dX * this.u, dY * this.u);
    }

    public boolean rotate(double \u03b1) {
        if (this.blocks.size() < 1) {
            return false;
        }
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double \u03b1rad = Math.toRadians(\u03b1);
        double cos = Math.cos(\u03b1rad);
        double sin = Math.sin(\u03b1rad);
        this.g.rotate(\u03b1rad);
        double x1 = x0 * cos + y0 * sin;
        double y1 = -x0 * sin + y0 * cos;
        this.currentpos.setLocation(x1, y1);
        return true;
    }

    public boolean flip() {
        if (this.blocks.size() < 1) {
            return false;
        }
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.g.scale(1.0, -1.0);
        this.currentpos.setLocation(x0, -y0);
        return true;
    }

    public boolean scale(double sx, double sy) {
        if (this.blocks.size() < 1) {
            return false;
        }
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.g.scale(sx, sy);
        this.currentpos.setLocation(x0 / sx, y0 / sy);
        return true;
    }

    public int block() {
        clBlock bl = new clBlock(this.g.getTransform(), this.currentpos);
        this.blocks.push(bl);
        this.offset(this.currentpos.getX(), this.currentpos.getY());
        this.currentpos.setLocation(0.0, 0.0);
        return this.blocks.size();
    }

    public int endblock() {
        clBlock bl;
        try {
            bl = this.blocks.pop();
        }
        catch (EmptyStackException e) {
            return -1;
        }
        AffineTransform savedAT = bl.getAffineTransform();
        this.g.setTransform(savedAT);
        this.currentpos.setLocation(bl.getPos());
        return this.blocks.size();
    }

    public void moveto(double x1, double y1) {
        this.currentpos.setLocation(x1, y1);
    }

    public void moveto(double[] xy) {
        this.currentpos.setLocation(xy[0], xy[1]);
    }

    public void movetox(double x1) {
        this.currentpos.setLocation(x1, this.currentpos.getY());
    }

    public void movetoy(double y1) {
        this.currentpos.setLocation(this.currentpos.getX(), y1);
    }

    public double[] here() {
        double[] here = new double[]{this.currentpos.getX(), this.currentpos.getY()};
        return here;
    }

    public void moverel(double dx, double dy) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.currentpos.setLocation(x0 + dx, y0 + dy);
    }

    public void movepolar(double dL, double \u03b1) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double dx = dL * Math.cos(Math.toRadians(\u03b1));
        double dy = dL * Math.sin(Math.toRadians(\u03b1));
        this.currentpos.setLocation(x0 + dx, y0 + dy);
    }

    public void lineto(double x1, double y1) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.g.draw(new Line2D.Double(x0 * this.u, y0 * this.u, x1 * this.u, y1 * this.u));
        this.currentpos.setLocation(x1, y1);
    }

    public void linetox(double x1) {
        this.lineto(x1, this.currentpos.getY());
    }

    public void linetoy(double y1) {
        this.lineto(this.currentpos.getX(), y1);
    }

    public void line(double x0, double y0, double x1, double y1) {
        this.g.draw(new Line2D.Double(x0 * this.u, y0 * this.u, x1 * this.u, y1 * this.u));
        this.currentpos.setLocation(x1, y1);
    }

    public void linerel(double dx, double dy) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        this.g.draw(new Line2D.Double(x0 * this.u, y0 * this.u, x1 * this.u, y1 * this.u));
        this.currentpos.setLocation(x1, y1);
    }

    public void linepolar(double dL, double \u03b1) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double x1 = x0 + dL * Math.cos(Math.toRadians(\u03b1));
        double y1 = y0 + dL * Math.sin(Math.toRadians(\u03b1));
        this.g.draw(new Line2D.Double(x0 * this.u, y0 * this.u, x1 * this.u, y1 * this.u));
        this.currentpos.setLocation(x1, y1);
    }

    public void linemid(double L, double \u03b1) {
        double dx = L / 2.0 * Math.cos(Math.toRadians(\u03b1));
        double dy = L / 2.0 * Math.sin(Math.toRadians(\u03b1));
        double x0 = this.currentpos.getX() - dx;
        double y0 = this.currentpos.getY() - dy;
        double x1 = this.currentpos.getX() + dx;
        double y1 = this.currentpos.getY() + dy;
        this.g.draw(new Line2D.Double(x0 * this.u, y0 * this.u, x1 * this.u, y1 * this.u));
    }

    public void point() {
        double durchmesser = 1.4 * (double)this.currentstrokesize;
        this.g.fill(this.kreis(this.currentpos, durchmesser));
    }

    public void point(double x1, double y1) {
        this.moveto(x1, y1);
        this.point();
    }

    public void arrowto(double x1, double y1) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.pfeil(x0, y0, x1, y1);
        this.currentpos.setLocation(x1, y1);
    }

    public void arrowrel(double dx, double dy) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        this.pfeil(x0, y0, x1, y1);
        this.currentpos.setLocation(x1, y1);
    }

    public void arrow(double x0, double y0, double x1, double y1) {
        this.pfeil(x0, y0, x1, y1);
        this.currentpos.setLocation(x1, y1);
    }

    public void arrowsto(double x1, double y1) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.doppelpfeil(x0, y0, x1, y1, false);
        this.currentpos.setLocation(x1, y1);
    }

    public void arrowsrel(double dx, double dy) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        this.doppelpfeil(x0, y0, x1, y1, false);
        this.currentpos.setLocation(x1, y1);
    }

    public void arrows(double x0, double y0, double x1, double y1) {
        this.doppelpfeil(x0, y0, x1, y1, false);
        this.currentpos.setLocation(x1, y1);
    }

    public void force(double Fx, double Fy, boolean isTeX) {
        double F = Math.hypot(Fx, Fy);
        String lb = Fkt.nf(F, this.forcedigits);
        this.force(Fx, Fy, lb, isTeX);
    }

    public void force(double Fx, double Fy, String lb, boolean isTeX) {
        double F = Math.hypot(Fx, Fy);
        if (F > 0.0) {
            double x0 = this.currentpos.getX();
            double y0 = this.currentpos.getY();
            double x1 = x0 + Fx * this.fu / this.u;
            double y1 = y0 + Fy * this.fu / this.u;
            this.pfeil(x0, y0, x1, y1);
            if (isTeX) {
                this.texlabelline(x0, y0, x1, y1, lb);
            } else {
                this.labelline(x0, y0, x1, y1, lb);
            }
            this.currentpos.setLocation(x1, y1);
        }
    }

    public void force2(double Fx, double Fy, boolean isTeX) {
        double F = Math.hypot(Fx, Fy);
        String lb = Fkt.nf(F, this.forcedigits);
        this.force2(Fx, Fy, lb, isTeX);
    }

    public void force2(double Fx, double Fy, String lb, boolean isTeX) {
        double F = Math.hypot(Fx, Fy);
        if (F > 0.0) {
            double x1 = this.currentpos.getX();
            double y1 = this.currentpos.getY();
            double x0 = x1 - Fx * this.fu / this.u;
            double y0 = y1 - Fy * this.fu / this.u;
            this.pfeil(x0, y0, x1, y1);
            if (isTeX) {
                this.texlabelline(x0, y0, x1, y1, lb);
            } else {
                this.labelline(x0, y0, x1, y1, lb);
            }
        }
    }

    public void circle(double radius) {
        this.g.draw(this.kreis(this.currentpos, 2.0 * radius * this.u));
    }

    public void circle(double x1, double y1, double radius) {
        this.currentpos.setLocation(x1, y1);
        this.g.draw(this.kreis(this.currentpos, 2.0 * radius * this.u));
    }

    public void ellipse(double radius1, double radius2, double angle1) {
        double centerx = this.currentpos.getX() * this.u;
        double centery = this.currentpos.getY() * this.u;
        Ellipse2D.Double ellip = new Ellipse2D.Double(centerx - (radius1 *= this.u), centery - (radius2 *= this.u), 2.0 * radius1, 2.0 * radius2);
        double alphaRot = Math.toRadians(angle1);
        AffineTransform rotiert = AffineTransform.getRotateInstance(alphaRot, centerx, centery);
        Graphics2D tempGraphics = (Graphics2D)this.g.create();
        tempGraphics.setStroke(this.g.getStroke());
        tempGraphics.transform(rotiert);
        tempGraphics.draw(ellip);
        tempGraphics.dispose();
    }

    public void fillellipse(double radius1, double radius2, double angle1) {
        double centerx = this.currentpos.getX() * this.u;
        double centery = this.currentpos.getY() * this.u;
        Ellipse2D.Double ellip = new Ellipse2D.Double(centerx - (radius1 *= this.u), centery - (radius2 *= this.u), 2.0 * radius1, 2.0 * radius2);
        double alphaRot = Math.toRadians(angle1);
        AffineTransform rotiert = AffineTransform.getRotateInstance(alphaRot, centerx, centery);
        Graphics2D tempGraphics = (Graphics2D)this.g.create();
        tempGraphics.setStroke(this.g.getStroke());
        tempGraphics.transform(rotiert);
        tempGraphics.fill(ellip);
        tempGraphics.dispose();
    }

    public void arc(double radius, double startangle, double endangle) {
        double centerx = this.currentpos.getX() * this.u;
        double centery = this.currentpos.getY() * this.u;
        radius *= this.u;
        double extent = endangle - startangle;
        if (extent < 0.0) {
            extent += 360.0;
        }
        Rectangle2D.Double quadr = new Rectangle2D.Double(centerx - radius, centery - radius, 2.0 * radius, 2.0 * radius);
        Arc2D.Double bogen = new Arc2D.Double(quadr, -endangle, extent, 0);
        this.g.draw(bogen);
    }

    public void arc(double x1, double y1, double radius, double startangle, double endangle) {
        this.currentpos.setLocation(x1, y1);
        this.arc(radius, startangle, endangle);
    }

    public void fillsegment(double radius, double startangle, double endangle) {
        double centerx = this.currentpos.getX() * this.u;
        double centery = this.currentpos.getY() * this.u;
        radius *= this.u;
        double extent = endangle - startangle;
        if (extent < 0.0) {
            extent += 360.0;
        }
        Rectangle2D.Double quadr = new Rectangle2D.Double(centerx - radius, centery - radius, 2.0 * radius, 2.0 * radius);
        Arc2D.Double bogen = new Arc2D.Double(quadr, -endangle, extent, 0);
        this.g.fill(bogen);
    }

    public void quadcurve(double x0, double y0, double xCtrl, double yCtrl, double x1, double y1) {
        this.g.draw(new QuadCurve2D.Double(x0 * this.u, y0 * this.u, xCtrl * this.u, yCtrl * this.u, x1 * this.u, y1 * this.u));
        this.currentpos.setLocation(x1, y1);
    }

    public void cubiccurve(double x0, double y0, double x0Ctrl, double y0Ctrl, double x1Ctrl, double y1Ctrl, double x1, double y1) {
        this.g.draw(new CubicCurve2D.Double(x0 * this.u, y0 * this.u, x0Ctrl * this.u, y0Ctrl * this.u, x1Ctrl * this.u, y1Ctrl * this.u, x1 * this.u, y1 * this.u));
        this.currentpos.setLocation(x1, y1);
    }

    public void rect(double dx, double dy) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double X0 = Math.min(x0, x0 + dx);
        double Y0 = Math.min(y0, y0 + dy);
        double dX = Math.abs(dx);
        double dY = Math.abs(dy);
        this.g.draw(new Rectangle2D.Double(X0 * this.u, Y0 * this.u, dX * this.u, dY * this.u));
    }

    public void fillrect(double dx, double dy) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double X0 = Math.min(x0, x0 + dx);
        double Y0 = Math.min(y0, y0 + dy);
        double dX = Math.abs(dx);
        double dY = Math.abs(dy);
        this.g.fill(new Rectangle2D.Double(X0 * this.u, Y0 * this.u, dX * this.u, dY * this.u));
    }

    public void rod(double L, double w, double \u03b1) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double cos = Math.cos(Math.toRadians(\u03b1));
        double sin = Math.sin(Math.toRadians(\u03b1));
        double x1 = x0 + L * cos;
        double y1 = y0 + L * sin;
        double dx = w / 2.0 * sin;
        double dy = -w / 2.0 * cos;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo((x0 - dx) * this.u, (y0 - dy) * this.u);
        ((Path2D)path).lineTo((x0 + dx) * this.u, (y0 + dy) * this.u);
        ((Path2D)path).lineTo((x1 + dx) * this.u, (y1 + dy) * this.u);
        ((Path2D)path).lineTo((x1 - dx) * this.u, (y1 - dy) * this.u);
        path.closePath();
        this.g.draw(path);
        this.currentpos.setLocation(x1, y1);
    }

    public void fillrod(double L, double w, double \u03b1) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double cos = Math.cos(Math.toRadians(\u03b1));
        double sin = Math.sin(Math.toRadians(\u03b1));
        double x1 = x0 + L * cos;
        double y1 = y0 + L * sin;
        double dx = w / 2.0 * sin;
        double dy = -w / 2.0 * cos;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo((x0 - dx) * this.u, (y0 - dy) * this.u);
        ((Path2D)path).lineTo((x0 + dx) * this.u, (y0 + dy) * this.u);
        ((Path2D)path).lineTo((x1 + dx) * this.u, (y1 + dy) * this.u);
        ((Path2D)path).lineTo((x1 - dx) * this.u, (y1 - dy) * this.u);
        path.closePath();
        this.g.fill(path);
        this.currentpos.setLocation(x1, y1);
    }

    public void polygon(double[] x, double[] y) {
        assert (x.length == y.length);
        assert (x.length > 2);
        this.currentpos.setLocation(x[0], y[0]);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x[0] * this.u, y[0] * this.u);
        for (int i = 1; i < x.length; ++i) {
            ((Path2D)path).lineTo(x[i] * this.u, y[i] * this.u);
        }
        path.closePath();
        this.g.draw(path);
    }

    public void fillpolygon(double[] x, double[] y) {
        assert (x.length == y.length);
        assert (x.length > 2);
        this.currentpos.setLocation(x[0], y[0]);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x[0] * this.u, y[0] * this.u);
        for (int i = 1; i < x.length; ++i) {
            ((Path2D)path).lineTo(x[i] * this.u, y[i] * this.u);
        }
        path.closePath();
        this.g.fill(path);
    }

    public void fillcircle(double radius) {
        this.g.fill(this.kreis(this.currentpos, 2.0 * radius * this.u));
    }

    public void label(String label) {
        this.label(label, "NE");
    }

    public void label(String label, String relpos) {
        double h;
        double w;
        double xpix = this.currentpos.getX() * this.u;
        double ypix = this.currentpos.getY() * this.u;
        if (this.UTFconverter.containsUnicodeHexCharacters(label)) {
            label = this.UTFconverter.convert2UTF(label);
        }
        if (this.horizFontOnly) {
            w = (double)label.length() * 0.61 * (double)this.schriftgr;
            h = this.schriftgr;
        } else {
            Rectangle2D fr = this.g.getFontMetrics().getStringBounds(label, this.g);
            w = fr.getWidth();
            h = fr.getHeight();
        }
        if (relpos.equals("N")) {
            xpix -= w / 2.0;
            ypix -= h / 3.0;
        } else if (relpos.equals("NW")) {
            xpix -= w + h / 4.0;
            ypix -= h / 3.0;
        } else if (relpos.equals("W")) {
            xpix -= w + h / 4.0;
            ypix += h / 3.0;
        } else if (relpos.equals("SW")) {
            xpix -= w + h / 4.0;
            ypix += h;
        } else if (relpos.equals("S")) {
            xpix -= w / 2.0;
            ypix += h;
        } else if (relpos.equals("SE")) {
            xpix += h / 4.0;
            ypix += h;
        } else if (relpos.equals("E")) {
            xpix += h / 4.0;
            ypix += h / 3.0;
        } else if (relpos.equals("NE")) {
            xpix += h / 4.0;
            ypix -= h / 3.0;
        } else if (relpos.equals("C")) {
            xpix -= w / 2.0;
            ypix += h / 3.0;
        } else if (!relpos.equals("BL")) {
            xpix += h / 4.0;
            ypix -= h / 3.0;
        }
        this.g.drawString(label, (float)xpix, (float)ypix);
    }

    public void texlabel(String latex) {
        this.texlabel(latex, "NE");
    }

    public void texlabel(String latex, String relpos) {
        double cx = this.currentpos.getX();
        double cy = this.currentpos.getY();
        double xpix = this.currentpos.getX() * this.u;
        double ypix = this.currentpos.getY() * this.u;
        if (this.UTFconverter.containsUnicodeHexCharacters(latex)) {
            latex = this.UTFconverter.convert2UTF(latex);
        }
        TeXFormula formula = new TeXFormula(latex);
        formula.setColor(this.g.getColor());
        TeXIcon icon = formula.createTeXIcon(2, (float)this.schriftgr, true);
        double w = icon.getTrueIconWidth();
        double h = icon.getTrueIconHeight();
        TeXIcon tempicon = new TeXFormula("b").createTeXIcon(2, (float)this.schriftgr, true);
        double hmin = tempicon.getTrueIconHeight();
        if (h < hmin) {
            h = hmin;
        }
        if (relpos.equals("N")) {
            xpix -= w / 2.0;
            ypix -= h / 3.0;
        } else if (relpos.equals("NW")) {
            xpix -= w + h / 4.0;
            ypix -= h / 3.0;
        } else if (relpos.equals("W")) {
            xpix -= w + h / 4.0;
            ypix += h / 3.0;
        } else if (relpos.equals("SW")) {
            xpix -= w + h / 4.0;
            ypix += h;
        } else if (relpos.equals("S")) {
            xpix -= w / 2.0;
            ypix += h;
        } else if (relpos.equals("SE")) {
            xpix += h / 4.0;
            ypix += h;
        } else if (relpos.equals("E")) {
            xpix += h / 4.0;
            ypix += h / 3.0;
        } else if (relpos.equals("NE")) {
            xpix += h / 4.0;
            ypix -= h / 3.0;
        } else if (relpos.equals("C")) {
            xpix -= w / 2.0;
            ypix += h / 2.0;
        } else if (!relpos.equals("BL")) {
            xpix += h / 4.0;
            ypix -= h / 3.0;
        }
        Graphics2D tempGraphics = (Graphics2D)this.g.create();
        tempGraphics.translate(xpix, ypix);
        tempGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        tempGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        tempGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        tempGraphics.scale(this.schriftgr, this.schriftgr);
        Box box = icon.getBox();
        box.draw(tempGraphics, 0.0f, 0.0f);
        tempGraphics.dispose();
        this.currentpos.setLocation(cx, cy);
    }

    public void text(String text) {
        this.text(text, this.lastavailabletextwidth, this.lastavailabletextjustified);
    }

    public void text(String text, double availablewidth, boolean justified) {
        String[] words;
        double h;
        double w;
        if (availablewidth >= 0.0) {
            this.lastavailabletextwidth = availablewidth;
        } else {
            availablewidth = this.lastavailabletextwidth >= 0.0 ? this.lastavailabletextwidth : this.mm(150.0);
        }
        this.lastavailabletextjustified = justified;
        double xpix = this.currentpos.getX() * this.u;
        double ypix = this.currentpos.getY() * this.u;
        if (this.UTFconverter.containsUnicodeHexCharacters(text)) {
            text = this.UTFconverter.convert2UTF(text);
        }
        if (this.horizFontOnly) {
            w = (double)text.length() * 0.61 * (double)this.schriftgr;
            h = this.schriftgr;
        } else {
            Rectangle2D fr = this.g.getFontMetrics().getStringBounds(text, this.g);
            w = fr.getWidth();
            h = fr.getHeight();
        }
        double hLF = Math.max(h, 1.2 * (double)this.schriftgr);
        hLF = Math.ceil(hLF);
        if (w <= availablewidth * this.u) {
            this.g.drawString(text, (float)xpix, (float)ypix);
            this.currentpos.setLocation(this.currentpos.getX(), this.currentpos.getY() + hLF / this.u);
            return;
        }
        double wS = this.g.getFontMetrics().getStringBounds(" ", this.g).getWidth();
        try {
            words = text.split("[ \\t\\u2000-\\u200a\\u205f]");
        }
        catch (PatternSyntaxException e) {
            words = text.split("[ \\t]");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Work around activated. JRE: " + Runtime.class.getPackage().getSpecificationVersion());
        }
        double[] widths = new double[words.length];
        for (int i = 0; i < words.length; ++i) {
            widths[i] = this.g.getFontMetrics().getStringBounds(words[i], this.g).getWidth();
        }
        int writtenwords = 0;
        while (writtenwords < words.length) {
            int i = 0;
            for (double usedwith = 0.0; usedwith <= availablewidth * this.u; usedwith += widths[writtenwords + i - 1]) {
                if (++i > 1) {
                    usedwith += wS;
                }
                if (writtenwords + i - 1 >= words.length) break;
            }
            if (justified && writtenwords + i - 1 < words.length) {
                if (i == 1 || i == 2) {
                    this.g.drawString(words[writtenwords], (float)xpix, (float)ypix);
                    ++writtenwords;
                } else {
                    assert (i > 2);
                    double textonlywidth = 0.0;
                    for (int j = 0; j < i - 1; ++j) {
                        textonlywidth += widths[writtenwords + j];
                    }
                    double space = (availablewidth * this.u - textonlywidth) / (double)(i - 2);
                    double xpixpos = xpix;
                    for (int j = 0; j < i - 1; ++j) {
                        this.g.drawString(words[writtenwords + j], (float)xpixpos, (float)ypix);
                        xpixpos += widths[writtenwords + j];
                        xpixpos += space;
                    }
                    writtenwords += i - 1;
                }
            } else {
                StringBuilder sb = new StringBuilder();
                if (i == 1) {
                    sb.append(words[writtenwords]);
                    ++writtenwords;
                } else {
                    for (int j = 0; j < i - 1; ++j) {
                        if (j > 0) {
                            sb.append(" ");
                        }
                        sb.append(words[writtenwords + j]);
                    }
                    writtenwords += i - 1;
                }
                this.g.drawString(sb.toString(), (float)xpix, (float)ypix);
            }
            ypix += hLF;
        }
        this.currentpos.setLocation(this.currentpos.getX(), ypix / this.u);
    }

    public void decdigits(int nb) {
        this.digits = nb >= 0 ? nb : 3;
    }

    public void dimlineto(double x1, double y1, boolean isTeX) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.dimline(x0, y0, x1, y1, isTeX);
    }

    public void dimlineto(double x1, double y1, String lb, boolean isTeX) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        this.dimline(x0, y0, x1, y1, lb, isTeX);
    }

    public void dimlinerel(double dx, double dy, boolean isTeX) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        this.dimline(x0, y0, x1, y1, isTeX);
    }

    public void dimlinerel(double dx, double dy, String lb, boolean isTeX) {
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        this.dimline(x0, y0, x1, y1, lb, isTeX);
    }

    public void dimline(double x0, double y0, double x1, double y1, boolean isTeX) {
        Point2D.Double P1 = new Point2D.Double(x1, y1);
        Point2D.Double P0 = new Point2D.Double(x0, y0);
        double dim = P1.distance(P0);
        String dimstr = Fkt.nf(dim, this.digits);
        if (dimstr.contains(".")) {
            while (dimstr.endsWith("0")) {
                dimstr = dimstr.substring(0, dimstr.length() - 1);
            }
            if (dimstr.endsWith(".")) {
                dimstr = dimstr.substring(0, dimstr.length() - 1);
            }
        }
        this.dimline(x0, y0, x1, y1, dimstr, isTeX);
    }

    public void dimline(double x0, double y0, double x1, double y1, String lb, boolean isTeX) {
        this.doppelpfeil(x0, y0, x1, y1, true);
        if (isTeX) {
            this.texlabelline(x0, y0, x1, y1, lb);
        } else {
            this.labelline(x0, y0, x1, y1, lb);
        }
        this.currentpos.setLocation(x1, y1);
    }

    public void labelline(double x0, double y0, double x1, double y1, String lb) {
        Point2D PM = this.mitte(new Point2D.Double(x0, y0), new Point2D.Double(x1, y1));
        if (this.horizFontOnly) {
            String pos = Math.abs(x1 - x0) < Math.abs(y1 - y0) ? "E" : "N";
            double curX = this.currentpos.getX();
            double curY = this.currentpos.getY();
            this.currentpos.setLocation(PM);
            this.label(lb, pos);
            this.currentpos.setLocation(curX, curY);
        } else {
            if (this.UTFconverter.containsUnicodeHexCharacters(lb)) {
                lb = this.UTFconverter.convert2UTF(lb);
            }
            Rectangle2D fr = this.g.getFontMetrics().getStringBounds(lb, this.g);
            double w = fr.getWidth();
            double h = fr.getHeight();
            double dx = x1 - x0;
            double dy = y1 - y0;
            double alphaRot = dx == 0.0 ? -1.5707963267948966 : Math.atan(dy / dx);
            float xpix = (float)(PM.getX() * this.u);
            float ypix = (float)(PM.getY() * this.u);
            AffineTransform rotiert = AffineTransform.getRotateInstance(alphaRot, xpix, ypix);
            Graphics2D tempGraphics = (Graphics2D)this.g.create();
            tempGraphics.setStroke(this.g.getStroke());
            tempGraphics.transform(rotiert);
            tempGraphics.translate(-w / 2.0, -h / 3.0);
            tempGraphics.drawString(lb, xpix, ypix);
            tempGraphics.dispose();
        }
    }

    public void texlabelline(double x0, double y0, double x1, double y1, String latex) {
        Point2D PM = this.mitte(new Point2D.Double(x0, y0), new Point2D.Double(x1, y1));
        if (this.UTFconverter.containsUnicodeHexCharacters(latex)) {
            latex = this.UTFconverter.convert2UTF(latex);
        }
        TeXFormula formula = new TeXFormula(latex);
        formula.setColor(this.g.getColor());
        TeXIcon icon = formula.createTeXIcon(2, (float)this.schriftgr, true);
        double w = icon.getTrueIconWidth();
        double h = icon.getTrueIconHeight();
        double dx = x1 - x0;
        double dy = y1 - y0;
        double alphaRot = dx == 0.0 ? -1.5707963267948966 : Math.atan(dy / dx);
        float xpix = (float)(PM.getX() * this.u);
        float ypix = (float)(PM.getY() * this.u);
        AffineTransform rotiert = AffineTransform.getRotateInstance(alphaRot, 0.0, 0.0);
        Graphics2D tempGraphics = (Graphics2D)this.g.create();
        tempGraphics.translate(xpix, ypix);
        tempGraphics.setStroke(this.g.getStroke());
        tempGraphics.transform(rotiert);
        tempGraphics.translate(-w / 2.0, -h / 3.0);
        tempGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        tempGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        tempGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        tempGraphics.scale(this.schriftgr, this.schriftgr);
        Box box = icon.getBox();
        box.draw(tempGraphics, 0.0f, 0.0f);
        tempGraphics.dispose();
    }

    public void decdigitsangle(int nb) {
        this.angledigits = nb >= 0 ? nb : this.angledigitsStd;
    }

    public void dimangle(double x0, double y0, double xP, double yP, double xQ, double yQ, boolean isTeX) {
        double angledeg;
        String dimstr;
        double dir1;
        double dir2 = Math.atan2(yQ - y0, xQ - x0);
        double anglerad = dir2 - (dir1 = Math.atan2(yP - y0, xP - x0));
        if (anglerad < 0.0) {
            anglerad += Math.PI * 2;
        }
        if ((dimstr = Fkt.nf(angledeg = 57.29577951308232 * anglerad, this.angledigits)).contains(".")) {
            while (dimstr.endsWith("0")) {
                dimstr = dimstr.substring(0, dimstr.length() - 1);
            }
            if (dimstr.endsWith(".")) {
                dimstr = dimstr.substring(0, dimstr.length() - 1);
            }
        }
        if (isTeX || !this.font.equalsIgnoreCase("Tex")) {
            dimstr = dimstr + "\u00b0";
        }
        if (Math.abs(angledeg - 90.0) < 1.0E-10 && this.angledigits < 10) {
            dimstr = ".";
        }
        this.dimangle(x0, y0, xP, yP, xQ, yQ, isTeX, dimstr);
    }

    public void dimangle(double x0, double y0, double xP, double yP, double xQ, double yQ, boolean isTeX, String lb) {
        double dir1;
        double dir2 = Math.atan2(yQ - y0, xQ - x0);
        if (dir2 < 0.0) {
            dir2 += Math.PI * 2;
        }
        if ((dir1 = Math.atan2(yP - y0, xP - x0)) < 0.0) {
            dir1 += Math.PI * 2;
        }
        double r = 4.0;
        this.arc(x0, y0, r / this.u, 57.29577951308232 * dir1, 57.29577951308232 * dir2);
        double textdir = (dir1 + dir2) / 2.0;
        if (dir2 < dir1) {
            textdir += Math.PI;
        }
        assert (textdir >= 0.0);
        String orientation = textdir <= 0.7853981633974483 ? "E" : (textdir < 2.356194490192345 ? "S" : (textdir <= 3.9269908169872414 ? "W" : (textdir < 5.497787143782138 ? "N" : "E")));
        if (lb.equals(".")) {
            this.moverel(0.6 * r / this.u * Math.cos(textdir), 0.6 * r / this.u * Math.sin(textdir));
            this.point();
        } else {
            this.moverel(r / this.u * Math.cos(textdir), r / this.u * Math.sin(textdir));
            if (isTeX) {
                this.texlabel(lb, orientation);
            } else {
                this.label(lb, orientation);
            }
        }
        this.currentpos.setLocation(x0, y0);
    }

    public void image(String filename, double dpi, double pxX, double pxY, double massstab) throws FileNotFoundException, IOException {
        File file = new File(filename);
        BufferedImage image = ImageIO.read(file);
        double x0 = this.currentpos.getX();
        double y0 = this.currentpos.getY();
        double scalexu = massstab == 0.0 ? 25.4 / dpi : massstab / this.naturalunit * 25.4 / dpi * this.u;
        int sx1 = 0;
        int sy1 = 0;
        int sw = image.getWidth();
        int sh = image.getHeight();
        double dx1 = x0 * this.u - scalexu * pxX;
        double dy1 = y0 * this.u - scalexu * pxY;
        double dw = scalexu * (double)sw;
        double dh = scalexu * (double)sh;
        double sf = 256.0;
        AffineTransform scaled = AffineTransform.getScaleInstance(1.0 / sf, 1.0 / sf);
        Graphics2D tempGraphics = (Graphics2D)this.g.create();
        tempGraphics.translate(dx1, dy1);
        tempGraphics.transform(scaled);
        tempGraphics.drawImage(image, 0, 0, (int)(sf * dw), (int)(sf * dh), sx1, sy1, sx1 + sw, sy1 + sh, null);
        tempGraphics.dispose();
    }

    int getdecdigits() {
        return this.digits;
    }

    double getunitlength() {
        return this.u;
    }

    private Ellipse2D.Double kreis(Point2D zentrum, double diameter) {
        Ellipse2D.Double derkreis = new Ellipse2D.Double(zentrum.getX() * this.u - diameter / 2.0, zentrum.getY() * this.u - diameter / 2.0, diameter, diameter);
        return derkreis;
    }

    private Point2D mitte(Point2D pkt1, Point2D pkt2) {
        Point2D.Double pkt = new Point2D.Double();
        ((Point2D)pkt).setLocation((pkt1.getX() + pkt2.getX()) / 2.0, (pkt1.getY() + pkt2.getY()) / 2.0);
        return pkt;
    }

    private void pfeil(double vonX, double vonY, double bisX, double bisY) {
        vonX *= this.u;
        vonY *= this.u;
        bisX *= this.u;
        bisY *= this.u;
        double spitzenl\u00e4ngeMax = 5.291666666666667;
        double spitzenl\u00e4ngeMin = 2.4694444444444446;
        double spitzenl\u00e4nge = Math.hypot(bisY - vonY, bisX - vonX) / 4.0;
        if (spitzenl\u00e4nge > spitzenl\u00e4ngeMax) {
            spitzenl\u00e4nge = spitzenl\u00e4ngeMax;
        }
        if (spitzenl\u00e4nge < spitzenl\u00e4ngeMin) {
            spitzenl\u00e4nge = spitzenl\u00e4ngeMin;
        }
        double dx = spitzenl\u00e4nge * (bisX - vonX) / Math.hypot(bisY - vonY, bisX - vonX);
        double dy = spitzenl\u00e4nge * (bisY - vonY) / Math.hypot(bisY - vonY, bisX - vonX);
        if (Math.hypot(bisY - vonY, bisX - vonX) >= spitzenl\u00e4nge) {
            this.g.draw(new Line2D.Double(vonX, vonY, bisX - dx / 2.0, bisY - dy / 2.0));
        }
        GeneralPath spitze = new GeneralPath();
        spitze.moveTo((float)bisX, (float)bisY);
        spitze.lineTo((float)(bisX - dx + dy / 3.0), (float)(bisY - dy - dx / 3.0));
        spitze.lineTo((float)(bisX - dx - dy / 3.0), (float)(bisY - dy + dx / 3.0));
        spitze.closePath();
        this.g.fill(spitze);
    }

    private void doppelpfeil(double vonX, double vonY, double bisX, double bisY, boolean withbar) {
        vonX *= this.u;
        vonY *= this.u;
        bisX *= this.u;
        bisY *= this.u;
        double spitzenl\u00e4ngeMax = 3.8805555555555555;
        double spitzenl\u00e4ngeMin = 1.7638888888888888;
        double spitzenl\u00e4nge = Math.hypot(bisY - vonY, bisX - vonX) / 4.0;
        if (spitzenl\u00e4nge > spitzenl\u00e4ngeMax) {
            spitzenl\u00e4nge = spitzenl\u00e4ngeMax;
        }
        if (spitzenl\u00e4nge < spitzenl\u00e4ngeMin) {
            spitzenl\u00e4nge = spitzenl\u00e4ngeMin;
        }
        double dx = spitzenl\u00e4nge * (bisX - vonX) / Math.hypot(bisY - vonY, bisX - vonX);
        double dy = spitzenl\u00e4nge * (bisY - vonY) / Math.hypot(bisY - vonY, bisX - vonX);
        if (Math.hypot(bisY - vonY, bisX - vonX) >= spitzenl\u00e4nge) {
            this.g.draw(new Line2D.Double(vonX + dx / 2.0, vonY + dy / 2.0, bisX - dx / 2.0, bisY - dy / 2.0));
        }
        GeneralPath spitzeBis = new GeneralPath();
        spitzeBis.moveTo((float)bisX, (float)bisY);
        spitzeBis.lineTo((float)(bisX - dx + dy / 3.0), (float)(bisY - dy - dx / 3.0));
        spitzeBis.lineTo((float)(bisX - dx - dy / 3.0), (float)(bisY - dy + dx / 3.0));
        spitzeBis.closePath();
        this.g.fill(spitzeBis);
        GeneralPath spitzeVon = new GeneralPath();
        spitzeVon.moveTo((float)vonX, (float)vonY);
        spitzeVon.lineTo((float)(vonX + dx - dy / 3.0), (float)(vonY + dy + dx / 3.0));
        spitzeVon.lineTo((float)(vonX + dx + dy / 3.0), (float)(vonY + dy - dx / 3.0));
        spitzeVon.closePath();
        this.g.fill(spitzeVon);
        if (withbar) {
            Stroke cstroke = this.g.getStroke();
            this.g.setStroke(new BasicStroke(this.currentstrokesize / 2.0f));
            this.g.draw(new Line2D.Double(vonX + dy / 2.0, vonY - dx / 2.0, vonX - dy / 2.0, vonY + dx / 2.0));
            this.g.draw(new Line2D.Double(bisX + dy / 2.0, bisY - dx / 2.0, bisX - dy / 2.0, bisY + dx / 2.0));
            this.g.setStroke(cstroke);
        }
    }

    private class clBlock {
        private final AffineTransform at;
        private final Point2D pos;

        private clBlock(AffineTransform at, Point2D pos) {
            this.at = at;
            this.pos = new Point2D.Double(pos.getX(), pos.getY());
        }

        private AffineTransform getAffineTransform() {
            return this.at;
        }

        private Point2D getPos() {
            return this.pos;
        }
    }
}

