/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d;

public class UTF2asciiConverter {
    private String escape = "esc";

    public UTF2asciiConverter() {
    }

    public UTF2asciiConverter(String escape) {
        this.escape = escape;
    }

    public boolean containsNonAsciiCharacters(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public boolean containsUnicodeHexCharacters(String text) {
        int escL = this.escape.length();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i + escL + 5 > text.length() || !text.substring(i, i + escL).equals(this.escape) || text.charAt(i + escL) != 'u') continue;
            String hex = text.substring(i + escL + 1, i + escL + 5);
            assert (hex.length() == 4);
            try {
                int num = Integer.parseInt(hex, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public String convert2UnicodeHex(String text) {
        if (text == null) {
            assert (false);
            return null;
        }
        int escL = this.escape.length();
        try {
            StringBuffer sb = new StringBuffer(text.length() + 80);
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c <= '\u007f') {
                    sb.append(c);
                    continue;
                }
                sb.append(this.escape);
                sb.append("u");
                if (c <= '\u00ff') {
                    sb.append("00");
                } else if (c <= '\u0fff') {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(c));
            }
            return sb.toString();
        }
        catch (Exception e) {
            System.err.println("[clUTF2asciiConverter] Error converting the text to UnicodeHex: " + text);
            System.err.println(e.getMessage());
            return text;
        }
    }

    public String convert2UTF(String text) {
        if (text == null) {
            assert (false);
            return null;
        }
        int escL = this.escape.length();
        try {
            StringBuffer sb = new StringBuffer(text.length() + 80);
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (i + escL + 5 <= text.length() && text.substring(i, i + escL).equals(this.escape) && text.charAt(i + escL) == 'u') {
                    String hex = text.substring(i + escL + 1, i + escL + 5);
                    assert (hex.length() == 4);
                    try {
                        int num = Integer.parseInt(hex, 16);
                        sb.append((char)num);
                        i += this.escape.length() + 4;
                    }
                    catch (NumberFormatException nume) {
                        sb.append(c);
                    }
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (Exception e) {
            System.err.println("[clUTF2asciiConverter] Error converting the text to UTF: " + text);
            System.err.println(e.getMessage());
            return text;
        }
    }

    public static void main(String[] args) {
        String konvertierterText;
        String text = "Zeile enth\u00e4lt NichtAsciiZeichen: \u00e4,\u00e9,\u03c9. \u03a0 := Pi;";
        if (args.length > 0) {
            text = args[0];
        }
        UTF2asciiConverter converter = new UTF2asciiConverter();
        System.out.println("");
        System.out.println("zu untersuchender Text:");
        System.out.println(text);
        System.out.println("");
        if (converter.containsNonAsciiCharacters(text)) {
            konvertierterText = converter.convert2UnicodeHex(text);
            System.out.println("konvertierter Text:");
            System.out.println(konvertierterText);
        } else {
            System.out.println("Der untersuchte Text enthaelt nur Ascii-Zeichen.");
            konvertierterText = text;
        }
        System.out.println("------------------");
        System.out.println("Rueckkonvertierung in Unicode-Zeichen");
        System.out.println("zu untersuchender Text: ");
        System.out.println(konvertierterText);
        System.out.println("");
        converter = new UTF2asciiConverter();
        if (converter.containsUnicodeHexCharacters(konvertierterText)) {
            String rueckkonvertierterText = converter.convert2UTF(konvertierterText);
            System.out.println("rueckkonvertierter Text:");
            System.out.println(rueckkonvertierterText);
        } else {
            System.out.println("Der untersuchte Text enthaelt keine Zeichen in UnicodeHex-Darstellung.");
        }
        System.exit(0);
    }
}

