/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.drawj2d.Drawj2d;
import net.sf.drawj2d.bgd.BgdInterpreter;
import net.sf.drawj2d.cmd.HCLparser;
import net.sf.drawj2d.inConst;
import net.sf.jtikz.TikzGraphics2D;

public class JtikzMode
implements inConst {
    private double res;
    private int pxwidth;
    private int pxheight;
    boolean success = true;
    private int type;
    private final boolean quiet;
    private final boolean verbose;
    private final String filename;
    private final String suffix;
    private final String quelldatei;
    private final double width;
    private final double height;
    private final double originX;
    private final double originY;
    private final int srcType;
    private final boolean debug = false;

    public JtikzMode(Drawj2d c) {
        this.quiet = c.quiet;
        this.verbose = c.verbose;
        this.width = c.width;
        this.height = c.height;
        this.originX = c.originX;
        this.originY = c.originY;
        this.filename = c.zieldatei;
        this.suffix = c.outputtype.toLowerCase();
        this.quelldatei = c.quelldatei;
        this.srcType = c.srcType;
        if (!this.quiet) {
            System.out.println("Mode: JTikZ");
        }
        this.res = 72.0;
        if (this.suffix.equals("tikz") || this.suffix.equals("jtikz")) {
            this.type = 6;
        } else {
            System.err.println("Not supported: " + this.suffix);
            this.success = false;
        }
    }

    public void setResolution(double resolution) {
        if (!this.quiet) {
            System.out.println("Setting resolution without effect for tikz");
        }
    }

    public boolean run() {
        this.pxwidth = (int)Math.rint(this.width * this.res / 25.4);
        this.pxheight = (int)Math.rint(this.height * this.res / 25.4);
        if (this.success) {
            this.writeOutput();
        }
        return this.success;
    }

    private void writeOutput() {
        assert (this.type == 6);
        FileOutputStream file = null;
        try {
            file = new FileOutputStream(this.filename);
            TikzGraphics2D tikz = new TikzGraphics2D(file);
            if (this.verbose) {
                tikz.verbose = true;
            }
            this.draw(tikz);
            tikz.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.success = false;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JtikzMode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.success) {
            System.out.println("Output written to: " + this.filename);
        } else {
            System.out.println("Error occurred. Check for error messages.");
        }
    }

    private void draw(TikzGraphics2D tikz) {
        switch (this.srcType) {
            case 102: {
                tikz.scale(this.res / 25.4, this.res / 25.4);
                tikz.translate(this.originX, this.originY);
                BgdInterpreter bgd_interp = new BgdInterpreter(tikz, this.width, this.height);
                bgd_interp.setVerbose(this.verbose);
                this.success = bgd_interp.sourceFile(this.quelldatei);
                boolean autoscale = true;
                if (!this.success) break;
                bgd_interp.interpret(autoscale);
                break;
            }
            case 103: {
                System.err.println("Support for ypd files not implemented in JTikZ mode.");
                this.success = false;
                break;
            }
            default: {
                tikz.scale(this.res / 25.4, this.res / 25.4);
                tikz.translate(this.originX, this.originY);
                HCLparser parser = new HCLparser(tikz);
                parser.setVerbose(this.verbose);
                this.success = parser.sourceFile(this.quelldatei);
            }
        }
    }
}

