/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.sf.drawj2d.Drawj2d;
import net.sf.drawj2d.bgd.BgdInterpreter;
import net.sf.drawj2d.cmd.HCLparser;
import net.sf.drawj2d.inConst;
import net.sf.drawj2d.yacas.PlotDataParser;

public class JREMode
implements inConst {
    private double res;
    private int pxwidth;
    private int pxheight;
    boolean success = true;
    private int type;
    private final boolean quiet;
    private final boolean verbose;
    private final String filename;
    private final String suffix;
    private final String quelldatei;
    private final double width;
    private final double height;
    private final double originX;
    private final double originY;
    private final int srcType;
    private JFrame frame;
    private final boolean debug = false;

    public JREMode(Drawj2d c) {
        String[] IOsuffixes;
        this.quiet = c.quiet;
        this.verbose = c.verbose;
        this.width = c.width;
        this.height = c.height;
        this.originX = c.originX;
        this.originY = c.originY;
        this.filename = c.zieldatei;
        this.suffix = c.outputtype.toLowerCase();
        this.quelldatei = c.quelldatei;
        this.srcType = c.srcType;
        if (!this.quiet) {
            System.out.println("Mode: JRE");
        }
        for (String t : IOsuffixes = ImageIO.getWriterFileSuffixes()) {
            if (!t.equals(this.suffix)) continue;
            this.type = 5;
            this.res = 200.0;
        }
        if (this.suffix.equalsIgnoreCase("screen")) {
            this.type = 7;
            try {
                this.res = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (HeadlessException e) {
                this.res = 72.0;
            }
        }
    }

    public void setResolution(double resolution) {
        this.res = resolution;
    }

    public boolean run() {
        this.pxwidth = (int)Math.rint(this.width * this.res / 25.4);
        this.pxheight = (int)Math.rint(this.height * this.res / 25.4);
        switch (this.type) {
            case 5: {
                this.writeOutput();
                break;
            }
            case 7: {
                this.showOutput();
                break;
            }
            default: {
                System.err.println("Not supported: " + this.suffix);
                this.success = false;
            }
        }
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput() {
        assert (this.type == 5);
        FileOutputStream file = null;
        try {
            file = new FileOutputStream(this.filename);
            int imgtype = 2;
            if (this.suffix.equals("jpeg") || this.suffix.equals("jpg") || this.suffix.equals("bmp")) {
                imgtype = 1;
            }
            if (this.suffix.equals("wbmp")) {
                imgtype = 12;
            }
            BufferedImage bi = new BufferedImage(this.pxwidth, this.pxheight, imgtype);
            Graphics2D ig2 = bi.createGraphics();
            this.draw(ig2);
            ImageIO.write((RenderedImage)bi, this.suffix, file);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.success = false;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.success = false;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JREMode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.success) {
            System.out.println("Output written to: " + this.filename);
        } else {
            System.out.println("Error occurred. Check for error messages.");
        }
    }

    private void showOutput() {
        assert (this.type == 7);
        this.frame = new JFrame();
        this.frame.setTitle("Drawj2d: " + this.quelldatei);
        this.frame.setDefaultCloseOperation(2);
        class Zeichenpanel
        extends JPanel {
            JREMode mode;

            Zeichenpanel(JREMode mode) {
                this.mode = mode;
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                Color remember = g2.getColor();
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.mode.pxwidth, this.mode.pxheight);
                g2.setColor(remember);
                this.mode.draw(g2);
            }
        }
        final Zeichenpanel p = new Zeichenpanel(this);
        p.setPreferredSize(new Dimension(this.pxwidth, this.pxheight));
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)this.pxwidth < scr.getWidth() - 100.0 && (double)this.pxheight < scr.getHeight() - 100.0) {
            this.frame.add((Component)p, "Center");
            this.frame.setResizable(false);
        } else {
            JScrollPane sp = new JScrollPane(p, 22, 32);
            this.frame.add((Component)sp, "Center");
        }
        JLabel info = new JLabel("ESC close, F5 refresh");
        this.frame.add((Component)info, "South");
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.frame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), "Redraw");
        this.frame.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JREMode.this.frame.dispose();
            }
        });
        this.frame.getRootPane().getActionMap().put("Redraw", new AbstractAction(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                p.repaint();
            }
        });
        if (this.success) {
            System.out.println("Preview: " + this.quelldatei);
        } else {
            System.out.println("Error occurred. Check for error messages.");
        }
    }

    private void draw(Graphics2D g) {
        switch (this.srcType) {
            case 102: {
                g.scale(this.res / 25.4, this.res / 25.4);
                g.translate(this.originX, this.originY);
                BgdInterpreter bgd_interp = new BgdInterpreter(g, this.width, this.height);
                bgd_interp.setVerbose(this.verbose);
                this.success = bgd_interp.sourceFile(this.quelldatei);
                boolean autoscale = true;
                if (!this.success) break;
                bgd_interp.interpret(autoscale);
                break;
            }
            case 103: {
                PlotDataParser ypd_parser = new PlotDataParser(g, this.pxwidth, this.pxheight);
                ypd_parser.setOrigin((int)Math.rint(this.originX * this.res / 25.4), (int)Math.rint(this.originY * this.res / 25.4));
                ypd_parser.setVerbose(this.verbose);
                this.success = ypd_parser.sourceFile(this.quelldatei);
                break;
            }
            default: {
                g.scale(this.res / 25.4, this.res / 25.4);
                g.translate(this.originX, this.originY);
                HCLparser ig_parser = new HCLparser(g);
                ig_parser.setVerbose(this.verbose);
                this.success = ig_parser.sourceFile(this.quelldatei);
            }
        }
    }
}

