/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public abstract class DiagramComponent {
    private static final boolean DEBUG = false;

    protected static ShapePoint makePointForCell(TextGrid.Cell cell2, TextGrid grid, int cellWidth, int cellHeight, boolean allRound) {
        if (grid.isCorner(cell2) && allRound) {
            return new ShapePoint(cell2.x * cellWidth + cellWidth / 2, cell2.y * cellHeight + cellHeight / 2, 1);
        }
        if (grid.isNormalCorner(cell2)) {
            return new ShapePoint(cell2.x * cellWidth + cellWidth / 2, cell2.y * cellHeight + cellHeight / 2, 0);
        }
        if (grid.isRoundCorner(cell2)) {
            return new ShapePoint(cell2.x * cellWidth + cellWidth / 2, cell2.y * cellHeight + cellHeight / 2, 1);
        }
        if (grid.isLinesEnd(cell2)) {
            return new ShapePoint(cell2.x * cellWidth + cellWidth / 2, cell2.y * cellHeight + cellHeight / 2, 0);
        }
        if (grid.isIntersection(cell2)) {
            return new ShapePoint(cell2.x * cellWidth + cellWidth / 2, cell2.y * cellHeight + cellHeight / 2, 0);
        }
        throw new RuntimeException("Cannot make point for cell " + cell2);
    }

    public static DiagramComponent createClosedFromBoundaryCells(TextGrid grid, CellSet cells, int cellWidth, int cellHeight) {
        return DiagramComponent.createClosedFromBoundaryCells(grid, cells, cellWidth, cellHeight, false);
    }

    public static DiagramComponent createClosedFromBoundaryCells(TextGrid grid, CellSet cells, int cellWidth, int cellHeight, boolean allRound) {
        if (cells.getType(grid) == 1) {
            throw new IllegalArgumentException("CellSet is closed and cannot be handled by this method");
        }
        if (cells.size() < 2) {
            return null;
        }
        DiagramShape shape = new DiagramShape();
        shape.setClosed(true);
        if (grid.containsAtLeastOneDashedLine(cells)) {
            shape.setStrokeDashed(true);
        }
        TextGrid workGrid = new TextGrid(grid.getWidth(), grid.getHeight());
        grid.copyCellsTo(cells, workGrid);
        TextGrid.Cell start = cells.getFirst();
        if (workGrid.isCorner(start)) {
            shape.addToPoints(DiagramComponent.makePointForCell(start, workGrid, cellWidth, cellHeight, allRound));
        }
        TextGrid.Cell previous = start;
        TextGrid.Cell cell2 = null;
        CellSet nextCells = workGrid.followCell(previous);
        if (nextCells.size() == 0) {
            return null;
        }
        cell2 = nextCells.getFirst();
        if (workGrid.isCorner(cell2)) {
            shape.addToPoints(DiagramComponent.makePointForCell(cell2, workGrid, cellWidth, cellHeight, allRound));
        }
        while (!cell2.equals(start)) {
            nextCells = workGrid.followCell(cell2, previous);
            if (nextCells.size() == 1) {
                previous = cell2;
                cell2 = nextCells.getFirst();
                if (cell2.equals(start) || !workGrid.isCorner(cell2)) continue;
                shape.addToPoints(DiagramComponent.makePointForCell(cell2, workGrid, cellWidth, cellHeight, allRound));
                continue;
            }
            if (nextCells.size() > 1) {
                return null;
            }
            throw new RuntimeException("cannot create closed shape from boundary cells, nowhere to go from " + cell2 + " coming from " + previous + " in grid:\n" + grid + "\nmaybe you have an edge pointing nowhere?");
        }
        return shape;
    }
}

