/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.Pair;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.CompositeDiagramShape;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.DiagramText;
import org.stathissideris.ascii2image.graphics.FontMeasurer;
import org.stathissideris.ascii2image.graphics.ShapeEdge;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.AbstractionGrid;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public class Diagram {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    private ArrayList shapes = new ArrayList();
    private ArrayList compositeShapes = new ArrayList();
    private ArrayList textObjects = new ArrayList();
    private int width;
    private int height;
    private int cellWidth;
    private int cellHeight;

    public Diagram(TextGrid grid, ConversionOptions options, ProcessingOptions processingOptions) {
        DiagramComponent shape;
        this.cellWidth = options.renderingOptions.getCellWidth();
        this.cellHeight = options.renderingOptions.getCellHeight();
        this.width = grid.getWidth() * this.cellWidth;
        this.height = grid.getHeight() * this.cellHeight;
        TextGrid workGrid = new TextGrid(grid);
        workGrid.replaceTypeOnLine();
        workGrid.replacePointMarkersOnLine();
        int width = grid.getWidth();
        int height = grid.getHeight();
        AbstractionGrid temp = new AbstractionGrid(workGrid, workGrid.getAllBoundaries());
        ArrayList boundarySetsStep1 = temp.getDistinctShapes();
        ArrayList boundarySetsStep2 = new ArrayList();
        for (CellSet set : boundarySetsStep1) {
            TextGrid fillBuffer = new TextGrid(width * 3, height * 3);
            for (int yi = 0; yi < height * 3; ++yi) {
                for (int xi = 0; xi < width * 3; ++xi) {
                    TextGrid copyGrid;
                    if (!fillBuffer.isBlank(xi, yi)) continue;
                    TextGrid textGrid = copyGrid = new AbstractionGrid(workGrid, set).getCopyOfInternalBuffer();
                    textGrid.getClass();
                    CellSet boundaries = copyGrid.findBoundariesExpandingFrom(new TextGrid.Cell(textGrid, xi, yi));
                    if (boundaries.size() == 0) continue;
                    boundarySetsStep2.add(boundaries.makeScaledOneThirdEquivalent());
                    TextGrid textGrid2 = copyGrid = new AbstractionGrid(workGrid, set).getCopyOfInternalBuffer();
                    textGrid2.getClass();
                    CellSet filled = copyGrid.fillContinuousArea(new TextGrid.Cell(textGrid2, xi, yi), '*');
                    fillBuffer.fillCellsWith(filled, '*');
                    fillBuffer.fillCellsWith(boundaries, '-');
                }
            }
        }
        boundarySetsStep2 = CellSet.removeDuplicateSets(boundarySetsStep2);
        int originalSize = boundarySetsStep2.size();
        boundarySetsStep2 = CellSet.removeDuplicateSets(boundarySetsStep2);
        ArrayList<CellSet> open = new ArrayList<CellSet>();
        ArrayList<CellSet> closed = new ArrayList<CellSet>();
        ArrayList<CellSet> mixed = new ArrayList<CellSet>();
        for (CellSet set : boundarySetsStep2) {
            int type = set.getType(workGrid);
            if (type == 0) {
                closed.add(set);
                continue;
            }
            if (type == 1) {
                open.add(set);
                continue;
            }
            if (type != 2) continue;
            mixed.add(set);
        }
        boolean hadToEliminateMixed = false;
        if (mixed.size() > 0 && closed.size() > 0) {
            hadToEliminateMixed = true;
            for (CellSet set : mixed) {
                for (CellSet closedSet : closed) {
                    set.subtractSet(closedSet);
                }
                if (set.getType(workGrid) != 1) continue;
                boundarySetsStep2.remove(set);
                boundarySetsStep2.addAll(set.breakIntoDistinctBoundaries(workGrid));
            }
        } else if (mixed.size() > 0 && closed.size() == 0) {
            hadToEliminateMixed = true;
            for (CellSet set : mixed) {
                boundarySetsStep2.remove(set);
                boundarySetsStep2.addAll(set.breakTrulyMixedBoundaries(workGrid));
            }
        }
        if (hadToEliminateMixed) {
            open = new ArrayList();
            closed = new ArrayList();
            mixed = new ArrayList();
            for (CellSet set : boundarySetsStep2) {
                int type = set.getType(workGrid);
                if (type == 0) {
                    closed.add(set);
                    continue;
                }
                if (type == 1) {
                    open.add(set);
                    continue;
                }
                if (type != 2) continue;
                mixed.add(set);
            }
        }
        boolean removedAnyObsolete = this.removeObsoleteShapes(workGrid, closed);
        boolean allCornersRound = false;
        if (processingOptions.areAllCornersRound()) {
            allCornersRound = true;
        }
        ArrayList<DiagramComponent> closedShapes = new ArrayList<DiagramComponent>();
        for (CellSet set : closed) {
            shape = DiagramComponent.createClosedFromBoundaryCells(workGrid, set, this.cellWidth, this.cellHeight, allCornersRound);
            if (shape == null) continue;
            if (shape instanceof DiagramShape) {
                this.addToShapes((DiagramShape)shape);
                closedShapes.add(shape);
                continue;
            }
            if (!(shape instanceof CompositeDiagramShape)) continue;
            this.addToCompositeShapes((CompositeDiagramShape)shape);
        }
        if (processingOptions.performSeparationOfCommonEdges()) {
            this.separateCommonEdges(closedShapes);
        }
        for (CellSet set : open) {
            if (set.size() == 1) {
                DiagramShape shape2;
                TextGrid.Cell cell2 = set.getFirst();
                if (grid.cellContainsDashedLineChar(cell2) || (shape2 = DiagramShape.createSmallLine(workGrid, cell2, this.cellWidth, this.cellHeight)) == null) continue;
                this.addToShapes(shape2);
                shape2.connectEndsToAnchors(workGrid, this);
                continue;
            }
            shape = CompositeDiagramShape.createOpenFromBoundaryCells(workGrid, set, this.cellWidth, this.cellHeight, allCornersRound);
            if (shape == null) continue;
            if (shape instanceof CompositeDiagramShape) {
                this.addToCompositeShapes((CompositeDiagramShape)shape);
                ((CompositeDiagramShape)shape).connectEndsToAnchors(workGrid, this);
                continue;
            }
            if (!(shape instanceof DiagramShape)) continue;
            this.addToShapes((DiagramShape)shape);
            ((DiagramShape)shape).connectEndsToAnchors(workGrid, this);
            ((DiagramShape)shape).moveEndsToCellEdges(grid, this);
        }
        for (TextGrid.CellColorPair pair3 : grid.findColorCodes()) {
            ShapePoint point2 = new ShapePoint(this.getCellMidX(pair3.cell), this.getCellMidY(pair3.cell));
            for (DiagramShape shape3 : this.getShapes()) {
                if (!shape3.contains(point2)) continue;
                shape3.setFillColor(pair3.color);
            }
        }
        for (TextGrid.CellTagPair pair4 : grid.findMarkupTags()) {
            CustomShapeDefinition def;
            ShapePoint point3 = new ShapePoint(this.getCellMidX(pair4.cell), this.getCellMidY(pair4.cell));
            DiagramShape containingShape = null;
            for (DiagramShape shape4 : this.getShapes()) {
                if (!shape4.contains(point3)) continue;
                if (containingShape == null) {
                    containingShape = shape4;
                    continue;
                }
                if (!shape4.isSmallerThan(containingShape)) continue;
                containingShape = shape4;
            }
            if (containingShape == null) continue;
            if (pair4.tag.equals("d")) {
                def = processingOptions.getFromCustomShapes("d");
                if (def == null) {
                    containingShape.setType(3);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (pair4.tag.equals("s")) {
                def = processingOptions.getFromCustomShapes("s");
                if (def == null) {
                    containingShape.setType(4);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (pair4.tag.equals("io")) {
                def = processingOptions.getFromCustomShapes("io");
                if (def == null) {
                    containingShape.setType(5);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (pair4.tag.equals("c")) {
                def = processingOptions.getFromCustomShapes("c");
                if (def == null) {
                    containingShape.setType(6);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (pair4.tag.equals("mo")) {
                def = processingOptions.getFromCustomShapes("mo");
                if (def == null) {
                    containingShape.setType(7);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (pair4.tag.equals("tr")) {
                def = processingOptions.getFromCustomShapes("tr");
                if (def == null) {
                    containingShape.setType(8);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (pair4.tag.equals("o")) {
                def = processingOptions.getFromCustomShapes("o");
                if (def == null) {
                    containingShape.setType(9);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            def = processingOptions.getFromCustomShapes(pair4.tag);
            containingShape.setType(9999);
            containingShape.setDefinition(def);
        }
        for (TextGrid.Cell cell3 : workGrid.findArrowheads()) {
            DiagramShape arrowhead = DiagramShape.createArrowhead(workGrid, cell3, this.cellWidth, this.cellHeight);
            if (arrowhead != null) {
                this.addToShapes(arrowhead);
                continue;
            }
            System.err.println("Could not create arrowhead shape. Unexpected error.");
        }
        for (TextGrid.Cell cell4 : grid.getPointMarkersOnLine()) {
            DiagramShape mark = new DiagramShape();
            mark.addToPoints(new ShapePoint(this.getCellMidX(cell4), this.getCellMidY(cell4)));
            mark.setType(2);
            mark.setFillColor(Color.white);
            this.shapes.add(mark);
        }
        this.removeDuplicateShapes();
        workGrid = new TextGrid(grid);
        workGrid.removeNonText();
        TextGrid textGroupGrid = new TextGrid(workGrid);
        CellSet gaps = textGroupGrid.getAllBlanksBetweenCharacters();
        textGroupGrid.fillCellsWith(gaps, '|');
        CellSet nonBlank = textGroupGrid.getAllNonBlank();
        ArrayList textGroups = nonBlank.breakIntoDistinctBoundaries();
        Font font = FontMeasurer.instance().getFontFor(this.cellHeight);
        for (CellSet textGroupCellSet : textGroups) {
            TextGrid isolationGrid = new TextGrid(width, height);
            workGrid.copyCellsTo(textGroupCellSet, isolationGrid);
            ArrayList<TextGrid.CellStringPair> strings = isolationGrid.findStrings();
            for (TextGrid.CellStringPair pair5 : strings) {
                DiagramText textObject;
                TextGrid.Cell cell5 = pair5.cell;
                String string = pair5.string;
                TextGrid textGrid = isolationGrid;
                textGrid.getClass();
                TextGrid.Cell lastCell = new TextGrid.Cell(textGrid, cell5.x + string.length() - 1, cell5.y);
                int minX = this.getCellMinX(cell5);
                int y = this.getCellMaxY(cell5);
                int maxX = this.getCellMaxX(lastCell);
                if (FontMeasurer.instance().getWidthFor(string, font) > maxX - minX) {
                    Font lessWideFont = FontMeasurer.instance().getFontFor(maxX - minX, string);
                    textObject = new DiagramText(minX, y, string, lessWideFont);
                } else {
                    textObject = new DiagramText(minX, y, string, font);
                }
                textObject.centerVerticallyBetween(this.getCellMinY(cell5), this.getCellMaxY(cell5));
                int otherStart = isolationGrid.otherStringsStartInTheSameColumn(cell5);
                int otherEnd = isolationGrid.otherStringsEndInTheSameColumn(lastCell);
                if (0 == otherStart && 0 == otherEnd) {
                    textObject.centerHorizontallyBetween(minX, maxX);
                } else if (otherEnd > 0 && otherStart == 0) {
                    textObject.alignRightEdgeTo(maxX);
                } else if (otherEnd > 0 && otherStart > 0) {
                    if (otherEnd > otherStart) {
                        textObject.alignRightEdgeTo(maxX);
                    } else if (otherEnd == otherStart) {
                        textObject.centerHorizontallyBetween(minX, maxX);
                    }
                }
                this.addToTextObjects(textObject);
            }
        }
        for (DiagramShape shape5 : this.getAllDiagramShapes()) {
            Color fillColor = shape5.getFillColor();
            if (!shape5.isClosed() || shape5.getType() == 1 || fillColor == null || !BitmapRenderer.isColorDark(fillColor)) continue;
            for (DiagramText textObject : this.getTextObjects()) {
                if (!shape5.intersects(textObject.getBounds())) continue;
                textObject.setColor(Color.white);
            }
        }
        for (DiagramShape shape5 : this.getAllDiagramShapes()) {
            if (shape5.getType() != 9999) continue;
            for (DiagramText textObject : this.getTextObjects()) {
                textObject.setHasOutline(true);
                textObject.setColor(DiagramText.DEFAULT_COLOR);
            }
        }
    }

    public ArrayList getAllDiagramShapes() {
        ArrayList shapes = new ArrayList();
        shapes.addAll(this.getShapes());
        for (CompositeDiagramShape compShape : this.getCompositeShapes()) {
            shapes.addAll(compShape.getShapes());
        }
        return shapes;
    }

    private boolean removeObsoleteShapes(TextGrid grid, ArrayList<CellSet> sets) {
        boolean removedAny = false;
        ArrayList<CellSet> filledSets = new ArrayList<CellSet>();
        for (CellSet set : sets) {
            if ((set = set.getFilledEquivalent(grid)) == null) {
                return false;
            }
            filledSets.add(set);
        }
        ArrayList<Integer> toBeRemovedIndices = new ArrayList<Integer>();
        for (CellSet set : filledSets) {
            ArrayList<CellSet> common = new ArrayList<CellSet>();
            common.add(set);
            for (CellSet set2 : filledSets) {
                if (set == set2 || !set.hasCommonCells(set2)) continue;
                common.add(set2);
            }
            if (common.size() == 2) continue;
            CellSet largest = set;
            for (CellSet set2 : common) {
                if (set2.size() <= largest.size()) continue;
                largest = set2;
            }
            common.remove(largest);
            TextGrid gridOfSmalls = new TextGrid(largest.getMaxX() + 2, largest.getMaxY() + 2);
            CellSet sumOfSmall = new CellSet();
            for (CellSet set2 : common) {
                gridOfSmalls.fillCellsWith(set2, '*');
            }
            TextGrid gridLargest = new TextGrid(largest.getMaxX() + 2, largest.getMaxY() + 2);
            gridLargest.fillCellsWith(largest, '*');
            int index = filledSets.indexOf(largest);
            if (!gridLargest.equals(gridOfSmalls) || toBeRemovedIndices.contains(new Integer(index))) continue;
            toBeRemovedIndices.add(new Integer(index));
        }
        ArrayList<CellSet> setsToBeRemoved = new ArrayList<CellSet>();
        Iterator<CellSet> it = toBeRemovedIndices.iterator();
        while (it.hasNext()) {
            int i = (Integer)((Object)it.next());
            setsToBeRemoved.add(sets.get(i));
        }
        for (CellSet set : setsToBeRemoved) {
            removedAny = true;
            sets.remove(set);
        }
        return removedAny;
    }

    public float getMinimumOfCellDimension() {
        return Math.min(this.getCellWidth(), this.getCellHeight());
    }

    private void separateCommonEdges(ArrayList shapes) {
        float offset = this.getMinimumOfCellDimension() / 5.0f;
        ArrayList edges = new ArrayList();
        for (DiagramShape shape : shapes) {
            edges.addAll(shape.getEdges());
        }
        ArrayList<Pair<ShapeEdge, ShapeEdge>> listOfPairs = new ArrayList<Pair<ShapeEdge, ShapeEdge>>();
        Iterator it = edges.iterator();
        int startIndex = 1;
        while (it.hasNext()) {
            ShapeEdge edge1 = (ShapeEdge)it.next();
            for (int i = startIndex; i < edges.size(); ++i) {
                ShapeEdge edge2 = (ShapeEdge)edges.get(i);
                if (!edge1.touchesWith(edge2)) continue;
                listOfPairs.add(new Pair<ShapeEdge, ShapeEdge>(edge1, edge2));
            }
            ++startIndex;
        }
        ArrayList<Object> movedEdges = new ArrayList<Object>();
        for (Pair pair3 : listOfPairs) {
            if (!movedEdges.contains(pair3.first)) {
                ((ShapeEdge)pair3.first).moveInwardsBy(offset);
                movedEdges.add(pair3.first);
            }
            if (movedEdges.contains(pair3.second)) continue;
            ((ShapeEdge)pair3.second).moveInwardsBy(offset);
            movedEdges.add(pair3.second);
        }
    }

    private void removeDuplicateShapes() {
        ArrayList<DiagramShape> originalShapes = new ArrayList<DiagramShape>();
        Iterator shapesIt = this.getShapesIterator();
        while (shapesIt.hasNext()) {
            DiagramShape shape = (DiagramShape)shapesIt.next();
            boolean isOriginal = true;
            for (DiagramShape originalShape : originalShapes) {
                if (!shape.equals(originalShape)) continue;
                isOriginal = false;
            }
            if (!isOriginal) continue;
            originalShapes.add(shape);
        }
        this.shapes.clear();
        this.shapes.addAll(originalShapes);
    }

    private void addToTextObjects(DiagramText shape) {
        this.textObjects.add(shape);
    }

    private void addToCompositeShapes(CompositeDiagramShape shape) {
        this.compositeShapes.add(shape);
    }

    private void addToShapes(DiagramShape shape) {
        this.shapes.add(shape);
    }

    public Iterator getShapesIterator() {
        return this.shapes.iterator();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public ArrayList getCompositeShapes() {
        return this.compositeShapes;
    }

    public ArrayList getShapes() {
        return this.shapes;
    }

    public int getCellMinX(TextGrid.Cell cell2) {
        return Diagram.getCellMinX(cell2, this.cellWidth);
    }

    public static int getCellMinX(TextGrid.Cell cell2, int cellXSize) {
        return cell2.x * cellXSize;
    }

    public int getCellMidX(TextGrid.Cell cell2) {
        return Diagram.getCellMidX(cell2, this.cellWidth);
    }

    public static int getCellMidX(TextGrid.Cell cell2, int cellXSize) {
        return cell2.x * cellXSize + cellXSize / 2;
    }

    public int getCellMaxX(TextGrid.Cell cell2) {
        return Diagram.getCellMaxX(cell2, this.cellWidth);
    }

    public static int getCellMaxX(TextGrid.Cell cell2, int cellXSize) {
        return cell2.x * cellXSize + cellXSize;
    }

    public int getCellMinY(TextGrid.Cell cell2) {
        return Diagram.getCellMinY(cell2, this.cellHeight);
    }

    public static int getCellMinY(TextGrid.Cell cell2, int cellYSize) {
        return cell2.y * cellYSize;
    }

    public int getCellMidY(TextGrid.Cell cell2) {
        return Diagram.getCellMidY(cell2, this.cellHeight);
    }

    public static int getCellMidY(TextGrid.Cell cell2, int cellYSize) {
        return cell2.y * cellYSize + cellYSize / 2;
    }

    public int getCellMaxY(TextGrid.Cell cell2) {
        return Diagram.getCellMaxY(cell2, this.cellHeight);
    }

    public static int getCellMaxY(TextGrid.Cell cell2, int cellYSize) {
        return cell2.y * cellYSize + cellYSize;
    }

    public TextGrid.Cell getCellFor(ShapePoint point2) {
        TextGrid g;
        if (point2 == null) {
            throw new IllegalArgumentException("ShapePoint cannot be null");
        }
        TextGrid textGrid = g = new TextGrid();
        textGrid.getClass();
        return new TextGrid.Cell(textGrid, (int)point2.x / this.cellWidth, (int)point2.y / this.cellHeight);
    }

    public ArrayList getTextObjects() {
        return this.textObjects;
    }
}

