/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.layering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.hector2.MinMax;
import net.sourceforge.plantuml.hector2.mpos.MutationLayer;
import net.sourceforge.plantuml.hector2.mpos.MutationLayerMove;

public class Layer {
    private final int id;
    private final Map<IEntity, Integer> entities = new HashMap<IEntity, Integer>();

    public Layer(int id) {
        this.id = id;
    }

    public Layer duplicate() {
        Layer result = new Layer(this.id);
        result.entities.putAll(this.entities);
        return result;
    }

    public List<MutationLayer> getPossibleMutations() {
        ArrayList<MutationLayerMove> result = new ArrayList<MutationLayerMove>();
        for (Map.Entry<IEntity, Integer> ent : this.entities.entrySet()) {
            IEntity entity = ent.getKey();
            int longitude = ent.getValue();
            if (this.isLongitudeFree(longitude + 2)) {
                result.add(new MutationLayerMove(this, entity, longitude + 2));
            }
            if (!this.isLongitudeFree(longitude - 2)) continue;
            result.add(new MutationLayerMove(this, entity, longitude - 2));
        }
        return Collections.unmodifiableList(result);
    }

    private boolean isLongitudeFree(int longitude) {
        return !this.entities.values().contains(longitude);
    }

    public void put(IEntity ent, int longitude) {
        if (!this.entities.containsKey(ent)) {
            throw new IllegalArgumentException();
        }
        this.entities.put(ent, longitude);
    }

    public void add(IEntity ent) {
        int pos = this.entities.size() * 2;
        this.entities.put(ent, pos);
    }

    public Collection<IEntity> entities() {
        return Collections.unmodifiableCollection(this.entities.keySet());
    }

    public int getLongitude(IEntity ent) {
        return this.entities.get(ent);
    }

    public MinMax getMinMaxLongitudes() {
        return MinMax.from(this.entities.values());
    }

    public String toString() {
        return "layer " + this.id + " " + this.entities;
    }

    public final int getId() {
        return this.id;
    }
}

